/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.opentracing;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import java.io.IOException;
import org.glassfish.jersey.opentracing.LocalizationMessages;
import org.glassfish.jersey.opentracing.OpenTracingUtils;

public class OpenTracingClientResponseFilter
implements ClientResponseFilter {
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        Object spanProperty = requestContext.getProperty("span");
        if (spanProperty != null && spanProperty instanceof Span) {
            ((Span)spanProperty).setTag(Tags.HTTP_STATUS.getKey(), (Number)responseContext.getStatus()).setTag(LocalizationMessages.OPENTRACING_TAG_HAS_RESPONSE_ENTITY(), responseContext.hasEntity()).setTag(LocalizationMessages.OPENTRACING_TAG_RESPONSE_LENGTH(), (Number)responseContext.getLength()).setTag(LocalizationMessages.OPENTRACING_TAG_RESPONSE_HEADERS(), OpenTracingUtils.headersAsString(responseContext.getHeaders())).finish();
        }
    }
}

