/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.opentracing;

import io.opentracing.util.GlobalTracer;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import java.util.logging.Logger;
import org.glassfish.jersey.Beta;
import org.glassfish.jersey.opentracing.LocalizationMessages;
import org.glassfish.jersey.opentracing.OpenTracingApplicationEventListener;
import org.glassfish.jersey.opentracing.OpenTracingClientRequestFilter;
import org.glassfish.jersey.opentracing.OpenTracingClientResponseFilter;

@Beta
public class OpenTracingFeature
implements Feature {
    private static final Logger LOGGER = Logger.getLogger(OpenTracingFeature.class.getName());
    private final Verbosity verbosity;
    public static final String SPAN_CONTEXT_PROPERTY = "span";
    public static final String DEFAULT_RESOURCE_SPAN_NAME = "jersey-resource";
    public static final String DEFAULT_CHILD_SPAN_NAME = "jersey-resource-app";
    public static final String DEFAULT_REQUEST_SPAN_NAME = "jersey-server";

    public OpenTracingFeature() {
        this.verbosity = Verbosity.INFO;
    }

    public OpenTracingFeature(Verbosity verbosity) {
        this.verbosity = verbosity;
    }

    public boolean configure(FeatureContext context) {
        if (!GlobalTracer.isRegistered()) {
            LOGGER.warning(LocalizationMessages.OPENTRACING_TRACER_NOT_REGISTERED());
        }
        switch (context.getConfiguration().getRuntimeType()) {
            case CLIENT: {
                ((FeatureContext)context.register(OpenTracingClientRequestFilter.class)).register(OpenTracingClientResponseFilter.class);
                break;
            }
            case SERVER: {
                context.register((Object)new OpenTracingApplicationEventListener(this.verbosity));
            }
        }
        return true;
    }

    public static enum Verbosity {
        INFO,
        TRACE;

    }
}

