/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.opentracing;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.glassfish.jersey.opentracing.LocalizationMessages;
import org.glassfish.jersey.opentracing.OpenTracingFeature;
import org.glassfish.jersey.opentracing.OpenTracingUtils;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

class OpenTracingApplicationEventListener
implements ApplicationEventListener {
    private final Tracer globalTracer = GlobalTracer.get();
    private final OpenTracingFeature.Verbosity verbosity;

    public OpenTracingApplicationEventListener(OpenTracingFeature.Verbosity verbosity) {
        this.verbosity = verbosity;
    }

    public void onEvent(ApplicationEvent event) {
    }

    public RequestEventListener onRequest(RequestEvent requestEvent) {
        if (requestEvent.getType() == RequestEvent.Type.START) {
            Span requestSpan = this.handleRequestStart(requestEvent.getContainerRequest());
            return new OpenTracingRequestEventListener(requestSpan);
        }
        return null;
    }

    private Span handleRequestStart(ContainerRequest request) {
        Map<String, String> mappedHeaders = request.getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> OpenTracingUtils.formatList((List)entry.getValue())));
        SpanContext extractedContext = this.globalTracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapAdapter(mappedHeaders));
        Tracer.SpanBuilder spanBuilder = this.globalTracer.buildSpan("jersey-server").withTag(Tags.SPAN_KIND.getKey(), "server").withTag(Tags.HTTP_METHOD.getKey(), request.getMethod()).withTag(Tags.HTTP_URL.getKey(), request.getRequestUri().toASCIIString()).withTag(LocalizationMessages.OPENTRACING_TAG_REQUEST_HEADERS(), OpenTracingUtils.headersAsString(request.getHeaders())).withTag(LocalizationMessages.OPENTRACING_TAG_HAS_REQUEST_ENTITY(), request.hasEntity());
        if (extractedContext != null) {
            spanBuilder = spanBuilder.asChildOf(extractedContext);
        }
        Span span = spanBuilder.start();
        request.setProperty("span", (Object)span);
        span.log(LocalizationMessages.OPENTRACING_LOG_REQUEST_STARTED());
        return span;
    }

    class OpenTracingRequestEventListener
    implements RequestEventListener {
        private Span requestSpan;
        private Span resourceSpan = null;

        OpenTracingRequestEventListener(Span requestSpan) {
            this.requestSpan = requestSpan;
        }

        public void onEvent(RequestEvent event) {
            switch (event.getType()) {
                case MATCHING_START: {
                    this.logVerbose(LocalizationMessages.OPENTRACING_LOG_MATCHING_STARTED());
                    break;
                }
                case LOCATOR_MATCHED: {
                    this.logVerbose(LocalizationMessages.OPENTRACING_LOG_LOCATOR_MATCHED(OpenTracingUtils.formatList(event.getUriInfo().getMatchedResourceLocators())));
                    break;
                }
                case SUBRESOURCE_LOCATED: {
                    this.logVerbose(LocalizationMessages.OPENTRACING_LOG_SUBRESOURCE_LOCATED(OpenTracingUtils.formatList(event.getUriInfo().getLocatorSubResources())));
                    break;
                }
                case REQUEST_MATCHED: {
                    this.logVerbose(LocalizationMessages.OPENTRACING_LOG_REQUEST_MATCHED(event.getUriInfo().getMatchedResourceMethod().getInvocable().getDefinitionMethod()));
                    this.log(LocalizationMessages.OPENTRACING_LOG_REQUEST_FILTERING_STARTED());
                    break;
                }
                case REQUEST_FILTERED: {
                    ArrayList requestFilters = new ArrayList();
                    event.getContainerRequestFilters().forEach(requestFilters::add);
                    this.logVerbose(LocalizationMessages.OPENTRACING_LOG_REQUEST_FILTERING_FINISHED(requestFilters.size()));
                    if (requestFilters.size() <= 0) break;
                    this.log(LocalizationMessages.OPENTRACING_LOG_APPLIED_REQUEST_FILTERS(OpenTracingUtils.formatProviders(requestFilters)));
                    break;
                }
                case RESOURCE_METHOD_START: {
                    this.logVerbose(LocalizationMessages.OPENTRACING_LOG_RESOURCE_METHOD_STARTED(event.getUriInfo().getMatchedResourceMethod().getInvocable().getDefinitionMethod()));
                    this.resourceSpan = OpenTracingApplicationEventListener.this.globalTracer.buildSpan("jersey-resource").asChildOf(this.requestSpan).start();
                    event.getContainerRequest().setProperty("span", (Object)this.resourceSpan);
                    break;
                }
                case RESOURCE_METHOD_FINISHED: {
                    this.log(LocalizationMessages.OPENTRACING_LOG_RESOURCE_METHOD_FINISHED());
                    break;
                }
                case RESP_FILTERS_START: {
                    event.getContainerRequest().setProperty("span", (Object)this.requestSpan);
                    this.resourceSpan.finish();
                    this.logVerbose(LocalizationMessages.OPENTRACING_LOG_RESPONSE_FILTERING_STARTED());
                    break;
                }
                case RESP_FILTERS_FINISHED: {
                    ArrayList responseFilters = new ArrayList();
                    event.getContainerResponseFilters().forEach(responseFilters::add);
                    this.logVerbose(LocalizationMessages.OPENTRACING_LOG_RESPONSE_FILTERING_FINISHED(responseFilters.size()));
                    if (responseFilters.size() <= 0) break;
                    this.log(LocalizationMessages.OPENTRACING_LOG_APPLIED_RESPONSE_FILTERS(OpenTracingUtils.formatProviders(responseFilters)));
                    break;
                }
                case ON_EXCEPTION: {
                    if (this.resourceSpan != null) {
                        this.resourceSpan.setTag(Tags.ERROR.getKey(), true);
                        this.resourceSpan.finish();
                    }
                    this.requestSpan.setTag(Tags.ERROR.getKey(), true);
                    this.logError(event.getException());
                    break;
                }
                case EXCEPTION_MAPPER_FOUND: {
                    this.log(LocalizationMessages.OPENTRACING_LOG_EXCEPTION_MAPPER_FOUND(event.getExceptionMapper().getClass().getName()));
                    break;
                }
                case EXCEPTION_MAPPING_FINISHED: {
                    this.log(LocalizationMessages.OPENTRACING_LOG_EXCEPTION_MAPPING_FINISHED() + (event.isResponseSuccessfullyMapped() ? LocalizationMessages.OPENTRACING_LOG_EXCEPTION_MAPPING_SUCCESS() : LocalizationMessages.OPENTRACING_LOG_EXCEPTION_MAPPING_NOEXCEPTION_OR_FAILED()));
                    break;
                }
                case FINISHED: {
                    if (this.requestSpan == null) break;
                    ContainerResponse response = event.getContainerResponse();
                    if (response != null) {
                        int status = response.getStatus();
                        this.requestSpan.setTag(Tags.HTTP_STATUS.getKey(), (Number)status).setTag(LocalizationMessages.OPENTRACING_TAG_HAS_RESPONSE_ENTITY(), response.hasEntity()).setTag(LocalizationMessages.OPENTRACING_TAG_RESPONSE_LENGTH(), (Number)response.getLength());
                        if (400 <= status) {
                            this.requestSpan.setTag(Tags.ERROR.getKey(), true);
                        }
                    }
                    this.requestSpan.finish();
                }
            }
        }

        private void logVerbose(String s) {
            this.log(OpenTracingFeature.Verbosity.TRACE, s);
        }

        private void log(String s) {
            this.log(OpenTracingFeature.Verbosity.INFO, s);
        }

        private void log(OpenTracingFeature.Verbosity level, String s) {
            if (level.ordinal() <= OpenTracingApplicationEventListener.this.verbosity.ordinal()) {
                this.requestSpan.log(s);
            }
        }

        private void logError(Throwable t) {
            HashMap<String, Object> errorMap = new HashMap<String, Object>(2);
            errorMap.put("event", "error");
            errorMap.put("error.object", t);
            this.requestSpan.log(errorMap);
        }
    }
}

