/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.opentracing;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.glassfish.jersey.opentracing.LocalizationMessages;
import org.glassfish.jersey.opentracing.OpenTracingUtils;

class OpenTracingClientRequestFilter
implements ClientRequestFilter {
    OpenTracingClientRequestFilter() {
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        Tracer.SpanBuilder spanBuilder = GlobalTracer.get().buildSpan(LocalizationMessages.OPENTRACING_SPAN_PREFIX_CLIENT() + requestContext.getMethod()).withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.HTTP_URL.getKey(), requestContext.getUri().toASCIIString()).withTag(Tags.HTTP_METHOD.getKey(), requestContext.getMethod()).withTag(LocalizationMessages.OPENTRACING_TAG_HAS_REQUEST_ENTITY(), requestContext.hasEntity()).withTag(LocalizationMessages.OPENTRACING_TAG_ACCEPTABLE_MEDIA_TYPES(), requestContext.getAcceptableMediaTypes().stream().map(MediaType::toString).collect(Collectors.joining(", "))).withTag(LocalizationMessages.OPENTRACING_TAG_REQUEST_HEADERS(), OpenTracingUtils.headersAsString(requestContext.getHeaders()));
        Object property = requestContext.getProperty("span");
        if (property != null && property instanceof SpanContext) {
            spanBuilder = spanBuilder.asChildOf((SpanContext)property);
        }
        Span span = spanBuilder.start();
        requestContext.setProperty("span", (Object)span);
        HashMap<String, String> addedHeaders = new HashMap<String, String>();
        GlobalTracer.get().inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new TextMapAdapter(addedHeaders));
        addedHeaders.forEach((key, value) -> requestContext.getHeaders().add(key, value));
    }
}

