/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.aggregator;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.examples.aggregator.Message;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.OutboundEvent;
import org.glassfish.jersey.media.sse.SseBroadcaster;
import org.glassfish.jersey.server.ChunkedOutput;

@Path(value="message/stream/jersey")
public final class MessageStreamResourceJersey {
    private static final Logger LOGGER = Logger.getLogger(MessageStreamResourceJersey.class.getName());
    private static SseBroadcaster broadcaster = new SseBroadcaster(){

        public void onException(ChunkedOutput<OutboundEvent> chunkedOutput, Exception exception) {
            LOGGER.log(Level.SEVERE, "Error broadcasting message.", exception);
        }
    };
    private static AtomicLong nextMessageId = new AtomicLong(0L);

    @PUT
    @Consumes(value={"application/json"})
    public void putMessage(Message message) {
        LOGGER.info("--> Message received.");
        OutboundEvent event = new OutboundEvent.Builder().id(String.valueOf(nextMessageId.getAndIncrement())).mediaType(MediaType.APPLICATION_JSON_TYPE).data(Message.class, (Object)message).build();
        broadcaster.broadcast((Object)event);
    }

    @GET
    @Produces(value={"text/event-stream"})
    public EventOutput getMessageStream() {
        LOGGER.info("--> SSE connection received.");
        EventOutput eventOutput = new EventOutput();
        broadcaster.add((ChunkedOutput)eventOutput);
        return eventOutput;
    }
}

