/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.aggregator;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.KeyStroke;

public final class RemoveSelectedListItemsAction
extends AbstractAction {
    private final JList list;
    private final DefaultListModel listModel;

    public RemoveSelectedListItemsAction(JList list, DefaultListModel model) {
        if (list == null || model == null) {
            throw new NullPointerException("Bound JList component and it's model must not be null.");
        }
        this.list = list;
        this.listModel = model;
        this.putValue("Name", "Delete");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.removeSelectedListItems();
    }

    private void removeSelectedListItems() {
        boolean itemsSelected;
        Object[] selectedValues = this.list.getSelectedValues();
        boolean bl = itemsSelected = selectedValues.length > 0;
        if (itemsSelected && this.confirmRemove()) {
            for (Object selectedValue : selectedValues) {
                this.listModel.removeElement(selectedValue);
            }
        }
    }

    private boolean confirmRemove() {
        return true;
    }
}

