/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.sse.jaxrs;

import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseBroadcaster;
import jakarta.ws.rs.sse.SseEventSink;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@Path(value="domain")
public class DomainResource {
    private static final Map<Integer, Process> processes = new ConcurrentHashMap<Integer, Process>();

    @Path(value="start")
    @POST
    public Response post(@DefaultValue(value="0") @QueryParam(value="testSources") int testSources, @Context Sse sse) {
        Process process = new Process(testSources, sse);
        processes.put(process.getId(), process);
        Executors.newSingleThreadExecutor().execute(process);
        URI processIdUri = UriBuilder.fromResource(DomainResource.class).path("process/{id}").build(new Object[]{process.getId()});
        return Response.created((URI)processIdUri).build();
    }

    @Path(value="process/{id}")
    @Produces(value={"text/event-stream"})
    @GET
    public void getProgress(@PathParam(value="id") int id, @DefaultValue(value="false") @QueryParam(value="testSource") boolean testSource, @Context SseEventSink eventSink) {
        Process process = processes.get(id);
        if (process != null) {
            if (testSource) {
                process.release();
            }
        } else {
            throw new NotFoundException();
        }
        process.getBroadcaster().register(eventSink);
    }

    static class Process
    implements Runnable {
        private static final AtomicInteger counter = new AtomicInteger(0);
        private final int id;
        private final CountDownLatch latch;
        private final SseBroadcaster broadcaster;
        private final Sse sse;

        Process(int testReceivers, Sse sse) {
            this.sse = sse;
            this.broadcaster = sse.newBroadcaster();
            this.id = counter.incrementAndGet();
            this.latch = testReceivers > 0 ? new CountDownLatch(testReceivers) : null;
        }

        int getId() {
            return this.id;
        }

        SseBroadcaster getBroadcaster() {
            return this.broadcaster;
        }

        void release() {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        @Override
        public void run() {
            try {
                if (this.latch != null) {
                    this.latch.await(5L, TimeUnit.SECONDS);
                }
                this.broadcaster.broadcast(this.sse.newEventBuilder().name("domain-progress").data(String.class, (Object)("starting domain " + this.id + " ...")).build());
                this.broadcaster.broadcast(this.sse.newEventBuilder().name("domain-progress").data(String.class, (Object)"50%").build());
                this.broadcaster.broadcast(this.sse.newEventBuilder().name("domain-progress").data(String.class, (Object)"60%").build());
                this.broadcaster.broadcast(this.sse.newEventBuilder().name("domain-progress").data(String.class, (Object)"70%").build());
                this.broadcaster.broadcast(this.sse.newEventBuilder().name("domain-progress").data(String.class, (Object)"99%").build());
                this.broadcaster.broadcast(this.sse.newEventBuilder().name("domain-progress").data(String.class, (Object)"done").build());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

