/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.server.async.managed;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.glassfish.jersey.examples.server.async.managed.Message;
import org.glassfish.jersey.server.ManagedAsync;

@Path(value="chat")
@Produces(value={"application/json"})
public class ChatResource {
    private static final BlockingQueue<AsyncResponse> suspended = new ArrayBlockingQueue<AsyncResponse>(5);

    @GET
    @ManagedAsync
    public void getMessage(@Suspended AsyncResponse ar) throws InterruptedException {
        suspended.put(ar);
    }

    @POST
    @ManagedAsync
    public String postMessage(Message message) throws InterruptedException {
        AsyncResponse asyncResponse = suspended.take();
        asyncResponse.resume((Object)message);
        return "Sent!";
    }
}

