/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.managedclient;

import java.io.IOException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;

public class CustomHeaderFilter
implements ContainerRequestFilter,
ClientRequestFilter {
    private final String headerName;
    private final String headerValue;

    public CustomHeaderFilter(String headerName, String headerValue) {
        if (headerName == null || headerValue == null) {
            throw new IllegalArgumentException("Header name and value must not be null.");
        }
        this.headerName = headerName;
        this.headerValue = headerValue;
    }

    public void filter(ContainerRequestContext ctx) throws IOException {
        if (!this.headerValue.equals(ctx.getHeaderString(this.headerName))) {
            ctx.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)String.format("Expected header '%s' not present or value not equal to '%s'", this.headerName, this.headerValue)).build());
        }
    }

    public void filter(ClientRequestContext ctx) throws IOException {
        ctx.getHeaders().putSingle((Object)this.headerName, (Object)this.headerValue);
    }
}

