/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.jackson;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Provider;
import org.glassfish.jersey.examples.jackson.CombinedAnnotationBean;

@Provider
public class MyObjectMapperProvider
implements ContextResolver<ObjectMapper> {
    final ObjectMapper defaultObjectMapper = MyObjectMapperProvider.createDefaultMapper();
    final ObjectMapper combinedObjectMapper = MyObjectMapperProvider.createCombinedObjectMapper();

    public ObjectMapper getContext(Class<?> type) {
        if (type == CombinedAnnotationBean.class) {
            return this.combinedObjectMapper;
        }
        return this.defaultObjectMapper;
    }

    private static ObjectMapper createCombinedObjectMapper() {
        return new ObjectMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, true).configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true).setAnnotationIntrospector(MyObjectMapperProvider.createJaxbJacksonAnnotationIntrospector());
    }

    private static ObjectMapper createDefaultMapper() {
        ObjectMapper result = new ObjectMapper();
        result.enable(SerializationFeature.INDENT_OUTPUT);
        return result;
    }

    private static AnnotationIntrospector createJaxbJacksonAnnotationIntrospector() {
        JakartaXmlBindAnnotationIntrospector jaxbIntrospector = new JakartaXmlBindAnnotationIntrospector(TypeFactory.defaultInstance());
        JacksonAnnotationIntrospector jacksonIntrospector = new JacksonAnnotationIntrospector();
        return AnnotationIntrospector.pair((AnnotationIntrospector)jacksonIntrospector, (AnnotationIntrospector)jaxbIntrospector);
    }
}

