/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.expect100continue.netty.connector;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.http.Expect100ContinueFeature;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.netty.connector.NettyConnectorProvider;

public class NettyClient {
    public static void main(String[] args) throws InterruptedException {
        NettyClient.test();
    }

    public static void test() throws InterruptedException {
        ClientConfig defaultConfig = new ClientConfig();
        defaultConfig.property("jersey.config.client.logging.verbosity", (Object)LoggingFeature.Verbosity.PAYLOAD_ANY);
        defaultConfig.connectorProvider((ConnectorProvider)new NettyConnectorProvider());
        defaultConfig.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.CHUNKED);
        defaultConfig.register((Object)Expect100ContinueFeature.basic());
        Client client = ClientBuilder.newClient((Configuration)defaultConfig);
        WebTarget webTarget = client.target("http://127.0.0.1:3000");
        Invocation.Builder invocationBuilder = webTarget.request();
        invocationBuilder.header("Accept", (Object)"application/json");
        for (int i = 0; i < 5; ++i) {
            System.out.println();
            System.out.println("****************** Iteration #" + i + " ******************");
            Response response = invocationBuilder.post(NettyClient.generateSimpleEntity());
            System.out.println("Response status = " + response.getStatus());
            System.out.println("Response status 204 means No Content, so we do not expect body here");
            System.out.println("**************************************************");
            System.out.println();
        }
        System.out.println("Client connection should be closed manually with Ctrl-C");
    }

    private static Entity<String> generateSimpleEntity() {
        return Entity.entity((Object)"{\"message\":\"Hello from java client\"}", (MediaType)MediaType.APPLICATION_JSON_TYPE);
    }

    private static void enableLogging(Level logLevel) {
        Handler[] handlers;
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(logLevel);
        Logger nettyLog = Logger.getLogger("io.netty");
        nettyLog.setLevel(logLevel);
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            handler.setLevel(logLevel);
        }
    }
}

