/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.helloworld;

import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.examples.helloworld.AppScopedResource;
import org.glassfish.jersey.examples.helloworld.CustomInterceptor;
import org.glassfish.jersey.examples.helloworld.HelloWorldResource;
import org.glassfish.jersey.examples.helloworld.RequestScopedResource;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.jboss.weld.environment.se.Weld;

public class App {
    private static final URI BASE_URI = URI.create("http://localhost:8080/weld/");
    public static final String ROOT_PATH = "application.wadl";

    public static void main(String[] args) {
        try {
            System.out.println("\"Hello World\" Jersey Example Weld App");
            final Weld weld = new Weld();
            weld.initialize();
            ResourceConfig resourceConfig = App.createJaxRsApp();
            final HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)BASE_URI, (ResourceConfig)resourceConfig, (boolean)false);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    server.shutdownNow();
                    weld.shutdown();
                }
            }));
            server.start();
            System.out.println(String.format("Application started.\nTry out %s%s\nStop the application using CTRL+C", BASE_URI, ROOT_PATH));
            Thread.currentThread().join();
        }
        catch (IOException | InterruptedException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ResourceConfig createJaxRsApp() {
        return ResourceConfig.forApplicationClass(JaxRsApplication.class);
    }

    public static class JaxRsApplication
    extends Application {
        @Context
        UriInfo uInfo;
        static final Set<Class<?>> appClasses = new HashSet();

        public Set<Class<?>> getClasses() {
            return appClasses;
        }

        static {
            appClasses.add(HelloWorldResource.class);
            appClasses.add(AppScopedResource.class);
            appClasses.add(RequestScopedResource.class);
            appClasses.add(CustomInterceptor.class);
        }
    }
}

