/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.hello.spring.annotations;

import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.Produces;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.jersey.examples.hello.spring.annotations.EnglishGoodbyeService;
import org.glassfish.jersey.examples.hello.spring.annotations.GoodbyeService;
import org.glassfish.jersey.examples.hello.spring.annotations.GreetingService;
import org.glassfish.jersey.examples.hello.spring.annotations.NorwegianGoodbyeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Singleton
@Path(value="spring-resource")
@Service
public class SpringRequestResource {
    AtomicInteger counter = new AtomicInteger();
    @Autowired
    private GreetingService greetingService;
    @Autowired
    private List<GoodbyeService> goodbyeServicesList;
    @Autowired
    private Set<GoodbyeService> goodbyeServicesSet;
    @Autowired
    private List<GoodbyeService> goodbyeServicesIterable;

    @GET
    @Produces(value={"text/plain"})
    public String getHello() {
        return this.greetingService.greet("world " + this.counter.incrementAndGet());
    }

    private void checkIntegrity() {
        Iterator<GoodbyeService> it = this.goodbyeServicesIterable.iterator();
        int i = 0;
        while (it.hasNext()) {
            GoodbyeService s2;
            GoodbyeService s1 = it.next();
            if (s1 != (s2 = this.goodbyeServicesList.get(i))) {
                throw new ProcessingException("Instance of service s1 (" + String.valueOf(s1.getClass()) + ") is not equal to service s2(" + String.valueOf(s2.getClass()) + ")");
            }
            ++i;
        }
        if (this.goodbyeServicesList.size() != this.goodbyeServicesSet.size()) {
            throw new ProcessingException("Size of set and size of the list differs. list=" + this.goodbyeServicesList.size() + "; set=" + this.goodbyeServicesSet.size());
        }
    }

    private GoodbyeService getService(Class<?> serviceClass) {
        for (GoodbyeService service : this.goodbyeServicesList) {
            if (!serviceClass.isAssignableFrom(service.getClass())) continue;
            return service;
        }
        return null;
    }

    @Path(value="goodbye")
    @GET
    @Produces(value={"text/plain"})
    public String getGoodbye() {
        this.checkIntegrity();
        GoodbyeService goodbyeService = this.getService(EnglishGoodbyeService.class);
        return goodbyeService.goodbye("cruel world");
    }

    @Path(value="norwegian-goodbye")
    @GET
    @Produces(value={"text/plain"})
    public String getNorwegianGoodbye() {
        this.checkIntegrity();
        return this.getService(NorwegianGoodbyeService.class).goodbye("p\u00e5 badet");
    }
}

