/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.helloworld.jaxrs;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.glassfish.jersey.examples.helloworld.jaxrs.JaxRsApplication;

public class App {
    static HttpServer startServer() throws IOException {
        final HttpServer server = HttpServer.create(new InetSocketAddress(App.getBaseURI().getPort()), 0);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                server.stop(0);
            }
        }));
        HttpHandler handler = (HttpHandler)RuntimeDelegate.getInstance().createEndpoint((Application)new JaxRsApplication(), HttpHandler.class);
        server.createContext(App.getBaseURI().getPath(), handler);
        server.start();
        return server;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        System.out.println("\"Hello World\" Jersey Example Application");
        App.startServer();
        System.out.println("Application started.\nTry accessing " + App.getBaseURI() + "helloworld in the browser.\nCTRL + C to stop the application...\n");
        Thread.currentThread().join();
    }

    private static int getPort(int defaultPort) {
        String port = System.getProperty("jersey.config.test.container.port");
        if (null != port) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                System.out.println("Value of jersey.config.test.container.port property is not a valid positive integer [" + port + "]. Reverting to default [" + defaultPort + "].");
            }
        }
        return defaultPort;
    }

    public static URI getBaseURI() {
        return UriBuilder.fromUri((String)"http://localhost/").port(App.getPort(8080)).build(new Object[0]);
    }
}

