/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.helloworld.cdi2se;

import java.security.Principal;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.examples.helloworld.cdi2se.HelloBean;

@Singleton
@Path(value="helloworld")
public class HelloWorldResource {
    @Inject
    private HelloBean helloBean;

    @GET
    @Path(value="{name}")
    @Produces(value={"text/plain"})
    public String getHello(@PathParam(value="name") String name, @Context SecurityContext sc) {
        StringBuilder sb = new StringBuilder(this.helloBean.hello(name));
        Optional.ofNullable(sc.getUserPrincipal()).map(Principal::getName).ifPresent(p -> {
            sb.append("(");
            sb.append((String)p);
            sb.append(")");
        });
        return sb.toString();
    }
}

