/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.linking.representation;

import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;

public class JaxbLink {
    private URI uri;
    private Map<QName, Object> params;

    public JaxbLink() {
    }

    public JaxbLink(URI uri) {
        this.uri = uri;
    }

    public JaxbLink(URI uri, Map<QName, Object> params) {
        this.uri = uri;
        this.params = params;
    }

    @XmlAttribute(name="href")
    public URI getUri() {
        return this.uri;
    }

    @XmlAnyAttribute
    public Map<QName, Object> getParams() {
        if (this.params == null) {
            this.params = new HashMap<QName, Object>();
        }
        return this.params;
    }

    void setUri(URI uri) {
        this.uri = uri;
    }

    void setParams(Map<QName, Object> params) {
        this.params = params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JaxbLink)) {
            return false;
        }
        JaxbLink jaxbLink = (JaxbLink)o;
        if (this.uri != null ? !this.uri.equals(jaxbLink.uri) : jaxbLink.uri != null) {
            return false;
        }
        if (this.params == jaxbLink.params) {
            return true;
        }
        if (this.params == null) {
            return jaxbLink.params.isEmpty();
        }
        if (jaxbLink.params == null) {
            return this.params.isEmpty();
        }
        return this.params.equals(jaxbLink.params);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.params);
    }
}

