/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.linking.resources;

import java.net.URI;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.examples.linking.model.ItemsModel;
import org.glassfish.jersey.examples.linking.representation.ItemsRepresentation;
import org.glassfish.jersey.examples.linking.resources.ItemResource;

@Path(value="items")
@Produces(value={"application/xml", "application/json"})
public class ItemsResource {
    private ItemsModel itemsModel = ItemsModel.getInstance();

    @GET
    public ItemsRepresentation query(@Context UriInfo info, @QueryParam(value="offset") @DefaultValue(value="-1") int offset, @DefaultValue(value="-1") @QueryParam(value="limit") int limit) {
        if (offset == -1 || limit == -1) {
            offset = offset == -1 ? 0 : offset;
            limit = limit == -1 ? 10 : limit;
            throw new WebApplicationException(Response.seeOther((URI)info.getRequestUriBuilder().queryParam("offset", new Object[]{offset}).queryParam("limit", new Object[]{limit}).build(new Object[0])).build());
        }
        return new ItemsRepresentation(this.itemsModel, offset, limit);
    }

    @Path(value="{id}")
    public ItemResource get(@PathParam(value="id") String id) {
        return new ItemResource(this.itemsModel, id);
    }
}

