/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.clipboard;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import java.util.LinkedList;
import java.util.List;
import org.glassfish.jersey.examples.clipboard.ClipboardData;

@Path(value="clipboard")
public class ClipboardResource {
    static final List<Variant> supportedVariants = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.TEXT_PLAIN_TYPE}).add().build();
    private static final List<String> history = new LinkedList<String>();
    private static ClipboardData content = new ClipboardData("");
    @Context
    Request request;

    @GET
    public Response content() {
        if (content.isEmpty()) {
            return Response.noContent().build();
        }
        Variant variant = this.request.selectVariant(supportedVariants);
        if (variant == null) {
            return Response.notAcceptable(supportedVariants).build();
        }
        return Response.ok((Object)content, (MediaType)variant.getMediaType()).build();
    }

    @PUT
    @Consumes(value={"text/plain", "application/json"})
    public void setContent(ClipboardData newContent) {
        this.saveHistory();
        ClipboardResource.updateContent(newContent);
    }

    private static void updateContent(ClipboardData newContent) {
        content = newContent;
    }

    @POST
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"text/plain", "application/json"})
    public ClipboardData append(ClipboardData appendix) {
        this.saveHistory();
        return content.append(appendix);
    }

    @DELETE
    public void clear() {
        this.saveHistory();
        content.clear();
    }

    @GET
    @Path(value="history")
    @Produces(value={"text/plain", "application/json"})
    public List<String> getHistory() {
        return history;
    }

    @DELETE
    @Path(value="history")
    public void clearHistory() {
        history.clear();
    }

    private void saveHistory() {
        String currentContent = content.toString();
        if (!currentContent.isEmpty()) {
            history.add(currentContent);
        }
    }
}

