/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.jersey.innate.inject.InjectionIds;
import org.glassfish.jersey.innate.inject.InternalBinder;
import org.glassfish.jersey.innate.inject.ServiceFinderBinder;
import org.glassfish.jersey.innate.inject.SupplierClassBinding;
import org.glassfish.jersey.innate.inject.SupplierInstanceBinding;
import org.glassfish.jersey.innate.io.InputStreamWrapper;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.BackgroundSchedulerLiteral;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ResourceFinder;
import org.glassfish.jersey.server.ServerProperties;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.servlet.ServletPropertiesDelegate;
import org.glassfish.jersey.servlet.WebAppResourcesScanner;
import org.glassfish.jersey.servlet.WebConfig;
import org.glassfish.jersey.servlet.internal.PersistenceUnitBinder;
import org.glassfish.jersey.servlet.internal.ResponseWriter;
import org.glassfish.jersey.servlet.internal.ServletContainerProviderFactory;
import org.glassfish.jersey.servlet.internal.Utils;
import org.glassfish.jersey.servlet.internal.l10n.LocalizationMessages;
import org.glassfish.jersey.servlet.internal.spi.ExtendedServletContainerProvider;
import org.glassfish.jersey.servlet.internal.spi.RequestContextProvider;
import org.glassfish.jersey.servlet.internal.spi.RequestScopedInitializerProvider;
import org.glassfish.jersey.servlet.internal.spi.ServletContainerProvider;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegate;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegateProvider;
import org.glassfish.jersey.servlet.spi.FilterUrlMappingsProvider;
import org.glassfish.jersey.uri.UriComponent;

public class WebComponent {
    private static final Logger LOGGER = Logger.getLogger(WebComponent.class.getName());
    private static final Type REQUEST_TYPE = new GenericType<Ref<HttpServletRequest>>(){}.getType();
    private static final Type RESPONSE_TYPE = new GenericType<Ref<HttpServletResponse>>(){}.getType();
    private static final AsyncContextDelegate DEFAULT_ASYNC_DELEGATE = new AsyncContextDelegate(){

        @Override
        public void suspend() throws IllegalStateException {
            throw new UnsupportedOperationException(LocalizationMessages.ASYNC_PROCESSING_NOT_SUPPORTED());
        }

        @Override
        public void complete() {
        }
    };
    private final RequestScopedInitializerProvider requestScopedInitializer;
    private final boolean requestResponseBindingExternalized;
    private static final RequestScopedInitializerProvider DEFAULT_REQUEST_SCOPE_INITIALIZER_PROVIDER = context -> injectionManager -> {
        ((Ref)injectionManager.getInstance(REQUEST_TYPE)).set((Object)context.getHttpServletRequest());
        ((Ref)injectionManager.getInstance(RESPONSE_TYPE)).set((Object)context.getHttpServletResponse());
    };
    final ApplicationHandler appHandler;
    final ScheduledExecutorService backgroundTaskScheduler;
    final WebConfig webConfig;
    final boolean forwardOn404;
    final boolean configSetStatusOverSendError;
    private final AsyncContextDelegateProvider asyncExtensionDelegate;
    private final boolean queryParamsAsFormParams;

    private AsyncContextDelegateProvider getAsyncExtensionDelegate() {
        Iterator providers = Providers.getAllProviders((InjectionManager)this.appHandler.getInjectionManager(), AsyncContextDelegateProvider.class).iterator();
        if (providers.hasNext()) {
            return (AsyncContextDelegateProvider)providers.next();
        }
        return (request, response) -> DEFAULT_ASYNC_DELEGATE;
    }

    static boolean isJPA() {
        Class clz = (Class)AccessController.doPrivileged(ReflectionHelper.classForNamePA((String)"jakarta.persistence.PersistenceUnit"));
        return clz != null;
    }

    public WebComponent(WebConfig webConfig, ResourceConfig resourceConfig) throws ServletException {
        this.webConfig = webConfig;
        if (resourceConfig == null) {
            resourceConfig = WebComponent.createResourceConfig(webConfig);
        }
        ServletContainerProvider[] allServletContainerProviders = ServletContainerProviderFactory.getAllServletContainerProviders();
        this.configure(resourceConfig, allServletContainerProviders);
        boolean rrbExternalized = false;
        RequestScopedInitializerProvider rsiProvider = null;
        for (ServletContainerProvider servletContainerProvider : allServletContainerProviders) {
            if (!(servletContainerProvider instanceof ExtendedServletContainerProvider)) continue;
            ExtendedServletContainerProvider extendedProvider = (ExtendedServletContainerProvider)servletContainerProvider;
            if (extendedProvider.bindsServletRequestResponse()) {
                rrbExternalized = true;
            }
            if (rsiProvider != null) continue;
            rsiProvider = extendedProvider.getRequestScopedInitializerProvider();
        }
        this.requestScopedInitializer = rsiProvider != null ? rsiProvider : DEFAULT_REQUEST_SCOPE_INITIALIZER_PROVIDER;
        this.requestResponseBindingExternalized = rrbExternalized;
        WebComponentBinder webComponentBinder = new WebComponentBinder(resourceConfig.getProperties(), webConfig, this.requestResponseBindingExternalized);
        resourceConfig.register((Object)webComponentBinder);
        Object locator = webConfig.getServletContext().getAttribute("jersey.config.servlet.context.serviceLocator");
        this.appHandler = new ApplicationHandler((Application)resourceConfig, (Binder)webComponentBinder, locator);
        this.asyncExtensionDelegate = this.getAsyncExtensionDelegate();
        this.forwardOn404 = webConfig.getConfigType() == WebConfig.ConfigType.FilterConfig && resourceConfig.isProperty("jersey.config.servlet.filter.forwardOn404");
        this.queryParamsAsFormParams = !resourceConfig.isProperty("jersey.config.servlet.form.queryParams.disabled");
        this.configSetStatusOverSendError = (Boolean)ServerProperties.getValue((Map)resourceConfig.getProperties(), (String)"jersey.config.server.response.setStatusOverSendError", (Object)false, Boolean.class);
        this.backgroundTaskScheduler = (ScheduledExecutorService)this.appHandler.getInjectionManager().getInstance(ScheduledExecutorService.class, new Annotation[]{BackgroundSchedulerLiteral.INSTANCE});
    }

    public Value<Integer> service(URI baseUri, URI requestUri, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        final ResponseWriter responseWriter = this.serviceImpl(baseUri, requestUri, servletRequest, servletResponse);
        return Values.lazy((Value)new Value<Integer>(){

            public Integer get() {
                return responseWriter.responseContextResolved() ? responseWriter.getResponseStatus() : -1;
            }
        });
    }

    ResponseWriter serviceImpl(URI baseUri, URI requestUri, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        ResponseWriter responseWriter = new ResponseWriter(this.forwardOn404, this.configSetStatusOverSendError, servletResponse, this.asyncExtensionDelegate.createDelegate(servletRequest, servletResponse), this.backgroundTaskScheduler);
        try {
            ContainerRequest requestContext = new ContainerRequest(baseUri, requestUri, servletRequest.getMethod(), WebComponent.getSecurityContext(servletRequest), (PropertiesDelegate)new ServletPropertiesDelegate(servletRequest), (Configuration)this.appHandler.getConfiguration());
            this.initContainerRequest(requestContext, servletRequest, servletResponse, responseWriter);
            this.appHandler.handle(requestContext);
        }
        catch (HeaderValueException hve) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, LocalizationMessages.HEADER_VALUE_READ_FAILED(), hve);
            }
            Response.Status status = Response.Status.BAD_REQUEST;
            if (this.configSetStatusOverSendError) {
                servletResponse.reset();
                servletResponse.setStatus(status.getStatusCode());
            } else {
                servletResponse.sendError(status.getStatusCode(), status.getReasonPhrase());
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        return responseWriter;
    }

    private void initContainerRequest(ContainerRequest requestContext, final HttpServletRequest servletRequest, final HttpServletResponse servletResponse, ResponseWriter responseWriter) throws IOException {
        try {
            requestContext.setEntityStream((InputStream)new InputStreamWrapper(){
                private ServletInputStream wrappedStream;

                protected InputStream getWrapped() {
                    if (this.wrappedStream == null) {
                        try {
                            this.wrappedStream = servletRequest.getInputStream();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    return this.wrappedStream;
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        requestContext.setRequestScopedInitializer(this.requestScopedInitializer.get(new RequestContextProvider(){

            @Override
            public HttpServletRequest getHttpServletRequest() {
                return servletRequest;
            }

            @Override
            public HttpServletResponse getHttpServletResponse() {
                return servletResponse;
            }
        }));
        requestContext.setWriter((ContainerResponseWriter)responseWriter);
        this.addRequestHeaders(servletRequest, requestContext);
        this.filterFormParameters(servletRequest, requestContext);
    }

    private static SecurityContext getSecurityContext(final HttpServletRequest request) {
        return new SecurityContext(){

            public Principal getUserPrincipal() {
                return request.getUserPrincipal();
            }

            public boolean isUserInRole(String role) {
                return request.isUserInRole(role);
            }

            public boolean isSecure() {
                return request.isSecure();
            }

            public String getAuthenticationScheme() {
                return request.getAuthType();
            }
        };
    }

    private static ResourceConfig createResourceConfig(WebConfig config) throws ServletException {
        ServletContext servletContext = config.getServletContext();
        ResourceConfig resourceConfig = Utils.retrieve(config.getServletContext(), config.getName());
        if (resourceConfig != null) {
            return resourceConfig;
        }
        Map<String, Object> initParams = WebComponent.getInitParams(config);
        Map<String, Object> contextParams = Utils.getContextParams(servletContext);
        String jaxrsApplicationClassName = config.getInitParameter("jakarta.ws.rs.Application");
        if (jaxrsApplicationClassName == null) {
            resourceConfig = new ResourceConfig().addProperties(initParams).addProperties(contextParams);
            String webApp = config.getInitParameter("jersey.config.servlet.provider.webapp");
            if (webApp != null && !"false".equals(webApp)) {
                resourceConfig.registerFinder((ResourceFinder)new WebAppResourcesScanner(servletContext));
            }
            return resourceConfig;
        }
        try {
            Class jaxrsApplicationClass = (Class)AccessController.doPrivileged(ReflectionHelper.classForNameWithExceptionPEA((String)jaxrsApplicationClassName));
            if (Application.class.isAssignableFrom(jaxrsApplicationClass)) {
                return ResourceConfig.forApplicationClass((Class)jaxrsApplicationClass).addProperties(initParams).addProperties(contextParams);
            }
            throw new ServletException(LocalizationMessages.RESOURCE_CONFIG_PARENT_CLASS_INVALID(jaxrsApplicationClassName, Application.class));
        }
        catch (PrivilegedActionException e) {
            throw new ServletException(LocalizationMessages.RESOURCE_CONFIG_UNABLE_TO_LOAD(jaxrsApplicationClassName), e.getCause());
        }
        catch (ClassNotFoundException e) {
            throw new ServletException(LocalizationMessages.RESOURCE_CONFIG_UNABLE_TO_LOAD(jaxrsApplicationClassName), (Throwable)e);
        }
    }

    private void configure(ResourceConfig resourceConfig, ServletContainerProvider[] allServletContainerProviders) throws ServletException {
        for (ServletContainerProvider servletContainerProvider : allServletContainerProviders) {
            servletContainerProvider.configure(resourceConfig);
        }
    }

    private void addRequestHeaders(HttpServletRequest request, ContainerRequest requestContext) {
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                if (value == null) continue;
                requestContext.header(name, (Object)value);
            }
        }
    }

    private static Map<String, Object> getInitParams(WebConfig webConfig) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Enumeration names = webConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            props.put(name, webConfig.getInitParameter(name));
        }
        return props;
    }

    private void filterFormParameters(HttpServletRequest servletRequest, ContainerRequest containerRequest) {
        if (MediaTypes.typeEqual((MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE, (MediaType)containerRequest.getMediaType()) && !containerRequest.hasEntity()) {
            Form form = new Form();
            Enumeration parameterNames = servletRequest.getParameterNames();
            String queryString = servletRequest.getQueryString();
            List<String> queryParams = queryString != null ? this.getDecodedQueryParamList(queryString) : Collections.emptyList();
            boolean keepQueryParams = this.queryParamsAsFormParams || queryParams.isEmpty();
            MultivaluedMap formMap = form.asMap();
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                List<String> values = Arrays.asList(servletRequest.getParameterValues(name));
                List<String> filteredValues = keepQueryParams ? values : this.filterQueryParams(name, values, queryParams);
                if (filteredValues.isEmpty()) continue;
                formMap.put((Object)name, filteredValues);
            }
            if (!formMap.isEmpty()) {
                containerRequest.setProperty("jersey.config.server.representation.decoded.form", (Object)form);
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, LocalizationMessages.FORM_PARAM_CONSUMED(containerRequest.getRequestUri()));
                }
            }
        }
    }

    private List<String> getDecodedQueryParamList(String queryString) {
        ArrayList<String> params = new ArrayList<String>();
        for (String param : queryString.split("&")) {
            params.add(UriComponent.decode((String)param, (UriComponent.Type)UriComponent.Type.QUERY_PARAM));
        }
        return params;
    }

    private List<String> filterQueryParams(String name, List<String> values, Collection<String> params) {
        return values.stream().filter(s -> !params.remove(name + "=" + s) && !params.remove(name + "[]=" + s)).collect(Collectors.toList());
    }

    public ApplicationHandler getAppHandler() {
        return this.appHandler;
    }

    static final class WebComponentBinder
    extends InternalBinder {
        private final Map<String, Object> applicationProperties;
        private final WebConfig webConfig;
        private final boolean requestResponseBindingExternalized;

        WebComponentBinder(Map<String, Object> applicationProperties, WebConfig webComponent, boolean requestResponseBindingExternalized) {
            this.applicationProperties = applicationProperties;
            this.webConfig = webComponent;
            this.requestResponseBindingExternalized = requestResponseBindingExternalized;
        }

        protected void configure() {
            if (!this.requestResponseBindingExternalized) {
                ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(HttpServletRequestReferencingFactory.class).to(HttpServletRequest.class)).proxy(true)).proxyForSameScope(false)).in(RequestScoped.class)).id((long)InjectionIds.SERVLET_HTTP_SERVLET_REQUEST.id());
                ((SupplierInstanceBinding)((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to((GenericType)new GenericType<Ref<HttpServletRequest>>(){})).in(RequestScoped.class)).id((long)InjectionIds.SERVLET_HTTP_SERVLET_REQUEST_REF.id());
                ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(HttpServletResponseReferencingFactory.class).to(HttpServletResponse.class)).proxy(true)).proxyForSameScope(false)).in(RequestScoped.class)).id((long)InjectionIds.SERVLET_HTTP_SERVLET_RESPONSE.id());
                ((SupplierInstanceBinding)((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to((GenericType)new GenericType<Ref<HttpServletResponse>>(){})).in(RequestScoped.class)).id((long)InjectionIds.SERVLET_HTTP_SERVLET_RESPONSE_REF.id());
            }
            ((SupplierInstanceBinding)((SupplierInstanceBinding)this.bindFactory(this.webConfig::getServletContext).to(ServletContext.class)).in(Singleton.class)).id((long)InjectionIds.SERVLET_SERVLET_CONTEXT.id());
            ServletConfig servletConfig = this.webConfig.getServletConfig();
            if (this.webConfig.getConfigType() == WebConfig.ConfigType.ServletConfig) {
                ((SupplierInstanceBinding)((SupplierInstanceBinding)this.bindFactory(() -> servletConfig).to(ServletConfig.class)).in(Singleton.class)).id((long)InjectionIds.SERVLET_SERVLET_CONFIG.id());
                if (WebComponent.isJPA()) {
                    Enumeration initParams = servletConfig.getInitParameterNames();
                    while (initParams.hasMoreElements()) {
                        String initParamName = (String)initParams.nextElement();
                        if (!initParamName.startsWith("unit:")) continue;
                        this.install(new Binder[]{new PersistenceUnitBinder(servletConfig)});
                        break;
                    }
                }
            } else {
                ((SupplierInstanceBinding)((SupplierInstanceBinding)this.bindFactory(this.webConfig::getFilterConfig).to(FilterConfig.class)).in(Singleton.class)).id((long)InjectionIds.SERVLET_FILTER_CONFIG.id());
            }
            ((SupplierInstanceBinding)((SupplierInstanceBinding)this.bindFactory(() -> this.webConfig).to(WebConfig.class)).in(Singleton.class)).id((long)InjectionIds.SERVLET_WEB_CONFIG.id());
            this.install(new Binder[]{new ServiceFinderBinder(AsyncContextDelegateProvider.class, this.applicationProperties, RuntimeType.SERVER)});
            this.install(new Binder[]{new ServiceFinderBinder(FilterUrlMappingsProvider.class, this.applicationProperties, RuntimeType.SERVER)});
        }
    }

    private static class HttpServletResponseReferencingFactory
    extends ReferencingFactory<HttpServletResponse> {
        @Inject
        public HttpServletResponseReferencingFactory(Provider<Ref<HttpServletResponse>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class HttpServletRequestReferencingFactory
    extends ReferencingFactory<HttpServletRequest> {
        @Inject
        public HttpServletRequestReferencingFactory(Provider<Ref<HttpServletRequest>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

