/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.httpserver;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Application;
import java.net.URI;
import org.glassfish.jersey.Beta;
import org.glassfish.jersey.netty.httpserver.JerseyServerInitializer;
import org.glassfish.jersey.netty.httpserver.NettyHttpContainer;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerProvider;

@Beta
public class NettyHttpContainerProvider
implements ContainerProvider {
    public <T> T createContainer(Class<T> type, Application application) throws ProcessingException {
        if (NettyHttpContainer.class == type) {
            return type.cast(new NettyHttpContainer(application));
        }
        return null;
    }

    public static Channel createServer(URI baseUri, NettyHttpContainer container, SslContext sslContext, boolean block) throws ProcessingException {
        ServerBootstrap serverBootstrap = NettyHttpContainerProvider.createServerBootstrap(baseUri, container, sslContext);
        return NettyHttpContainerProvider.startServer(NettyHttpContainerProvider.getPort(baseUri), container, serverBootstrap, block);
    }

    static ServerBootstrap createServerBootstrap(URI baseUri, NettyHttpContainer container, SslContext sslContext) {
        JerseyServerInitializer jerseyServerInitializer = new JerseyServerInitializer(baseUri, sslContext, container, container.getConfiguration());
        return NettyHttpContainerProvider.createServerBootstrap(jerseyServerInitializer);
    }

    private static ServerBootstrap createServerBootstrap(JerseyServerInitializer jerseyServerInitializer) {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        b.option(ChannelOption.SO_BACKLOG, (Object)1024);
        ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)jerseyServerInitializer);
        return b;
    }

    static Channel startServer(int port, final NettyHttpContainer container, ServerBootstrap serverBootstrap, boolean block) throws ProcessingException {
        try {
            final EventLoopGroup bossGroup = serverBootstrap.config().group();
            final EventLoopGroup workerGroup = serverBootstrap.config().childGroup();
            Channel ch = serverBootstrap.bind(port).sync().channel();
            ch.closeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                public void operationComplete(Future<? super Void> future) throws Exception {
                    container.getApplicationHandler().onShutdown((Container)container);
                    bossGroup.shutdownGracefully();
                    workerGroup.shutdownGracefully();
                }
            });
            if (block) {
                ch.closeFuture().sync();
                return ch;
            }
            return ch;
        }
        catch (InterruptedException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    public static Channel createServer(URI baseUri, ResourceConfig configuration, SslContext sslContext, boolean block) throws ProcessingException {
        return NettyHttpContainerProvider.createServer(baseUri, new NettyHttpContainer((Application)configuration), sslContext, block);
    }

    public static Channel createServer(URI baseUri, ResourceConfig configuration, boolean block) throws ProcessingException {
        return NettyHttpContainerProvider.createServer(baseUri, configuration, null, block);
    }

    public static Channel createHttp2Server(URI baseUri, ResourceConfig configuration, SslContext sslContext) throws ProcessingException {
        NettyHttpContainer container = new NettyHttpContainer((Application)configuration);
        JerseyServerInitializer jerseyServerInitializer = new JerseyServerInitializer(baseUri, sslContext, container, configuration, true);
        ServerBootstrap serverBootstrap = NettyHttpContainerProvider.createServerBootstrap(jerseyServerInitializer);
        int port = NettyHttpContainerProvider.getPort(baseUri);
        return NettyHttpContainerProvider.startServer(port, container, serverBootstrap, false);
    }

    static int getPort(URI uri) {
        if (uri.getPort() == -1) {
            if ("http".equalsIgnoreCase(uri.getScheme())) {
                return 80;
            }
            if ("https".equalsIgnoreCase(uri.getScheme())) {
                return 443;
            }
            throw new IllegalArgumentException("URI scheme must be 'http' or 'https'.");
        }
        return uri.getPort();
    }
}

