/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.httpserver;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.netty.connector.internal.NettyInputStream;
import org.glassfish.jersey.netty.httpserver.NettyHttpContainer;
import org.glassfish.jersey.netty.httpserver.NettyResponseWriter;
import org.glassfish.jersey.netty.httpserver.NettySecurityContext;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.internal.ContainerUtils;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

class JerseyServerHandler
extends ChannelInboundHandlerAdapter {
    private final URI baseUri;
    private final NettyInputStream nettyInputStream = new NettyInputStream();
    private final NettyHttpContainer container;
    private final ResourceConfig resourceConfig;
    private static final long MAX_REQUEST_ENTITY_BYTES = Long.getLong("jersey.max.http.request.entitySizeMb", new Long(50000L)) * 1024L * 1024L;

    public JerseyServerHandler(URI baseUri, NettyHttpContainer container, ResourceConfig resourceConfig) {
        this.baseUri = baseUri;
        this.container = container;
        this.resourceConfig = resourceConfig;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            long contentLength;
            HttpRequest req = (HttpRequest)msg;
            this.nettyInputStream.clear();
            final ContainerRequest requestContext = this.createContainerRequest(ctx, req);
            requestContext.setWriter((ContainerResponseWriter)new NettyResponseWriter(ctx, req, this.container));
            long l = contentLength = req.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) ? HttpUtil.getContentLength((HttpMessage)req) : -1L;
            if (contentLength >= MAX_REQUEST_ENTITY_BYTES) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.REQUEST_ENTITY_TOO_LARGE).build());
            } else {
                boolean isJson;
                String contentType = req.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
                boolean bl = isJson = contentType != null ? contentType.toLowerCase().contains("application/json") : false;
                if (!isJson && contentLength != -1L || HttpUtil.isTransferEncodingChunked((HttpMessage)req) || isJson && contentLength >= 2L) {
                    requestContext.setEntityStream((InputStream)this.nettyInputStream);
                }
            }
            for (String name : req.headers().names()) {
                requestContext.headers(name, (Iterable)req.headers().getAll(name));
            }
            this.container.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    JerseyServerHandler.this.container.getApplicationHandler().handle(requestContext);
                }
            });
        }
        if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            ByteBuf content = httpContent.content();
            if (content.isReadable()) {
                this.nettyInputStream.publish(content);
            }
            if (msg instanceof LastHttpContent) {
                this.nettyInputStream.complete(null);
            }
        }
    }

    private ContainerRequest createContainerRequest(ChannelHandlerContext ctx, HttpRequest req) {
        String s = req.uri().startsWith("/") ? req.uri().substring(1) : req.uri();
        URI requestUri = URI.create(this.baseUri + ContainerUtils.encodeUnsafeCharacters((String)s));
        ContainerRequest requestContext = new ContainerRequest(this.baseUri, requestUri, req.method().name(), (SecurityContext)this.getSecurityContext(ctx), new PropertiesDelegate(){
            private final Map<String, Object> properties = new HashMap<String, Object>();

            public Object getProperty(String name) {
                return this.properties.get(name);
            }

            public Collection<String> getPropertyNames() {
                return this.properties.keySet();
            }

            public void setProperty(String name, Object object) {
                this.properties.put(name, object);
            }

            public void removeProperty(String name) {
                this.properties.remove(name);
            }
        }, (Configuration)this.resourceConfig);
        return requestContext;
    }

    private NettySecurityContext getSecurityContext(ChannelHandlerContext ctx) {
        return new NettySecurityContext(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close();
    }
}

