/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.concurrent;

import java.util.AbstractQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.enterprise.concurrent.ManagedExecutorService;
import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedExecutorServiceAdapter;
import org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl;
import org.glassfish.enterprise.concurrent.internal.ManagedFutureTask;
import org.glassfish.enterprise.concurrent.internal.ManagedThreadPoolExecutor;

public class ManagedExecutorServiceImpl
extends AbstractManagedExecutorService {
    protected final ThreadPoolExecutor threadPoolExecutor;
    protected final ManagedExecutorServiceAdapter adapter;

    public ManagedExecutorServiceImpl(String name, ManagedThreadFactoryImpl managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, int corePoolSize, int maxPoolSize, int keepAliveTime, TimeUnit keepAliveTimeUnit, ContextServiceImpl contextService, AbstractManagedExecutorService.RejectPolicy rejectPolicy, BlockingQueue<Runnable> queue) {
        super(name, managedThreadFactory, hungTaskThreshold, longRunningTasks, contextService, contextService != null ? contextService.getContextSetupProvider() : null, rejectPolicy);
        this.threadPoolExecutor = new ManagedThreadPoolExecutor(corePoolSize, maxPoolSize, (long)keepAliveTime, keepAliveTimeUnit, queue, (ThreadFactory)((Object)this.managedThreadFactory));
        this.adapter = new ManagedExecutorServiceAdapter(this);
    }

    public ManagedExecutorServiceImpl(String name, ManagedThreadFactoryImpl managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, int corePoolSize, int maxPoolSize, int keepAliveTime, TimeUnit keepAliveTimeUnit, int queueCapacity, ContextServiceImpl contextService, AbstractManagedExecutorService.RejectPolicy rejectPolicy) {
        super(name, managedThreadFactory, hungTaskThreshold, longRunningTasks, contextService, contextService != null ? contextService.getContextSetupProvider() : null, rejectPolicy);
        if (queueCapacity < 0) {
            throw new IllegalArgumentException();
        }
        AbstractQueue queue = queueCapacity == Integer.MAX_VALUE ? (corePoolSize == 0 ? new SynchronousQueue() : new LinkedBlockingQueue()) : (queueCapacity == 0 ? new SynchronousQueue() : new ArrayBlockingQueue(queueCapacity));
        this.threadPoolExecutor = new ManagedThreadPoolExecutor(corePoolSize, maxPoolSize, (long)keepAliveTime, keepAliveTimeUnit, (BlockingQueue<Runnable>)((Object)queue), (ThreadFactory)((Object)this.managedThreadFactory));
        this.adapter = new ManagedExecutorServiceAdapter(this);
    }

    @Override
    public void execute(Runnable command) {
        ManagedFutureTask<Object> task = this.getNewTaskFor(command, null);
        task.submitted();
        this.threadPoolExecutor.execute(task);
    }

    public ManagedExecutorServiceAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    protected ExecutorService getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    @Override
    public ManagedExecutorService getExecutorForTaskListener() {
        return this.adapter;
    }

    @Override
    protected <V> ManagedFutureTask<V> getNewTaskFor(Runnable r, V result) {
        return new ManagedFutureTask<V>(this, r, result);
    }

    protected ManagedFutureTask getNewTaskFor(Callable callable) {
        return new ManagedFutureTask(this, callable);
    }

    @Override
    public long getTaskCount() {
        return this.threadPoolExecutor.getTaskCount();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.threadPoolExecutor.getCompletedTaskCount();
    }
}

