/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.spring.bridge.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import javax.inject.Named;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.JustInTimeInjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.spring.bridge.internal.SpringServiceHK2Bean;
import org.springframework.beans.factory.BeanFactory;

@Singleton
public class SpringToHK2JITResolver
implements JustInTimeInjectionResolver {
    private final ServiceLocator locator;
    private final BeanFactory beanFactory;

    SpringToHK2JITResolver(ServiceLocator locator, BeanFactory beanFactory) {
        this.locator = locator;
        this.beanFactory = beanFactory;
    }

    private void addMe(Class<?> lookForMe, String name, Injectee injectee) {
        HashSet<Type> contracts = new HashSet<Type>();
        contracts.add(injectee.getRequiredType());
        HashSet<Annotation> qualifiers = new HashSet<Annotation>(injectee.getRequiredQualifiers());
        SpringServiceHK2Bean springHK2Bean = new SpringServiceHK2Bean(name, contracts, qualifiers, lookForMe, this.beanFactory);
        ServiceLocatorUtilities.addOneDescriptor((ServiceLocator)this.locator, springHK2Bean, (boolean)false);
    }

    public boolean justInTimeResolution(Injectee failedInjectionPoint) {
        Class<?> lookForMe = SpringToHK2JITResolver.getClassFromType(failedInjectionPoint.getRequiredType());
        String name = SpringToHK2JITResolver.getName(failedInjectionPoint);
        try {
            block5: {
                if (name == null) break block5;
                if (!this.beanFactory.containsBean(name)) break block6;
                if (this.beanFactory.isTypeMatch(name, lookForMe)) {
                    this.addMe(lookForMe, name, failedInjectionPoint);
                    return true;
                }
                break block7;
            }
            if (this.beanFactory.getBean(lookForMe) != null) {
                this.addMe(lookForMe, name, failedInjectionPoint);
                return true;
            }
        }
        finally {
            return false;
        }
        {
            block6: {
                block7: {
                }
            }
        }
    }

    private static String getName(Injectee injectee) {
        for (Annotation anno : injectee.getRequiredQualifiers()) {
            if (!Named.class.equals(anno.annotationType())) continue;
            Named named = (Named)anno;
            return named.value();
        }
        return null;
    }

    private static Class<?> getClassFromType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getRawType();
        }
        return null;
    }
}

