/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.maven;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.shared.osgi.DefaultMaven2OsgiConverter;

public class Version {
    private static final int DIGITS_INDEX = 1;
    public static final Pattern STANDARD_PATTERN = Pattern.compile("^((?:\\d+\\.)*\\d+)([-_])?([a-zA-Z]*)([-_])?(\\d*)(?:([-_])?(.*?))?$");
    String orig;
    int major = 0;
    int minor = 0;
    int incremental = 0;
    String qualifier = "";

    public Version(String v) {
        this.orig = v;
        List<String> digits = this.parseDigits(v);
        this.major = Version.getDigit(digits, 0);
        this.minor = Version.getDigit(digits, 1);
        this.incremental = Version.getDigit(digits, 2);
        if (this.orig.contains("-")) {
            this.qualifier = this.orig.substring(this.orig.indexOf(45) + 1);
        }
    }

    private static int getDigit(List<String> digits, int idx) {
        if (digits.size() >= idx + 1 && digits.get(idx) != null && !digits.get(idx).isEmpty()) {
            return Integer.parseInt(digits.get(idx));
        }
        return 0;
    }

    private List<String> parseDigits(String vStr) {
        Matcher m = STANDARD_PATTERN.matcher(vStr);
        if (m.matches()) {
            return Arrays.asList(m.group(1).split("\\."));
        }
        return Collections.emptyList();
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getIncrementalVersion() {
        return this.incremental;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    private static String formatString4Osgi(String s) {
        return s.replaceAll("-", "_").replaceAll("\\.", "_");
    }

    public String convertToOsgi(COMPONENT comToDrop) {
        DefaultMaven2OsgiConverter converter = new DefaultMaven2OsgiConverter();
        if (comToDrop != null) {
            switch (comToDrop) {
                case major: {
                    return converter.getVersion("0.0.0");
                }
                case minor: {
                    return converter.getVersion(String.valueOf(this.getMajorVersion()));
                }
                case micro: {
                    return converter.getVersion(String.format("%s.%s", this.getMajorVersion(), this.getMinorVersion()));
                }
                case qualifier: {
                    return converter.getVersion(String.format("%s.%s.%s", this.getMajorVersion(), this.getMinorVersion(), this.getIncrementalVersion()));
                }
            }
        }
        String version = String.format("%s.%s.%s", this.getMajorVersion(), this.getMinorVersion(), this.getIncrementalVersion());
        if (!this.getQualifier().isEmpty()) {
            version = String.format("%s.%s", version, Version.formatString4Osgi(this.getQualifier()));
        }
        return converter.getVersion(version);
    }

    public static enum COMPONENT {
        major,
        minor,
        micro,
        qualifier;

    }
}

