/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.ModuleDefinition;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.jvnet.hk2.osgiadapter.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

class ModuleDefinitionCacheSingleton {
    private static ModuleDefinitionCacheSingleton _instance;
    private Map<URI, ModuleDefinition> cachedData = new HashMap<URI, ModuleDefinition>();
    private boolean cacheInvalidated = false;

    private ModuleDefinitionCacheSingleton() {
        try {
            this.loadCachedData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized ModuleDefinitionCacheSingleton getInstance() {
        if (_instance == null) {
            _instance = new ModuleDefinitionCacheSingleton();
        }
        return _instance;
    }

    public synchronized void cacheModuleDefinition(URI uri, ModuleDefinition md) {
        if (!this.cachedData.containsKey(uri)) {
            this.cacheInvalidated = true;
        }
        this.cachedData.put(uri, md);
    }

    public synchronized void remove(URI uri) {
        if (this.cachedData.remove(uri) != null) {
            this.cacheInvalidated = true;
        }
    }

    private void loadCachedData() throws Exception {
        String cacheLocation = this.getProperty("com.sun.enterprise.hk2.cacheDir");
        if (cacheLocation == null) {
            return;
        }
        File io = new File(cacheLocation, "inhabitants");
        if (!io.exists()) {
            return;
        }
        if (Logger.logger.isLoggable(Level.FINE)) {
            Logger.logger.logp(Level.INFO, this.getClass().getSimpleName(), "loadCachedData", "HK2 cache file = {0}", new Object[]{io});
        }
        ObjectInputStream stream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(io), this.getBufferSize()));
        this.cachedData = (Map)stream.readObject();
        stream.close();
    }

    public synchronized void saveCache() throws IOException {
        if (!this.cacheInvalidated) {
            return;
        }
        String cacheLocation = this.getProperty("com.sun.enterprise.hk2.cacheDir");
        if (cacheLocation == null) {
            return;
        }
        File io = new File(cacheLocation, "inhabitants");
        if (Logger.logger.isLoggable(Level.FINE)) {
            Logger.logger.logp(Level.INFO, this.getClass().getSimpleName(), "saveCache", "HK2 cache file = {0}", new Object[]{io});
        }
        if (io.exists()) {
            io.delete();
        }
        io.createNewFile();
        HashMap<URI, ModuleDefinition> data = new HashMap<URI, ModuleDefinition>();
        for (ModuleDefinition m : this.cachedData.values()) {
            data.put(m.getLocations()[0], m);
        }
        ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(io), this.getBufferSize()));
        os.writeObject(data);
        os.close();
        this.cacheInvalidated = false;
    }

    private int getBufferSize() {
        int bufsize = 1024;
        return bufsize;
    }

    public synchronized ModuleDefinition get(URI uri) {
        ModuleDefinition md = this.cachedData.get(uri);
        return md;
    }

    public void invalidate() {
        this.cacheInvalidated = true;
    }

    public boolean isCacheInvalidated() {
        return this.cacheInvalidated;
    }

    private String getProperty(String property) {
        BundleContext bctx = null;
        try {
            bctx = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        }
        catch (Exception e) {
            // empty catch block
        }
        String value = bctx != null ? bctx.getProperty(property) : null;
        return value != null ? value : System.getProperty(property);
    }
}

