/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import com.sun.enterprise.module.common_impl.TracingUtilities;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.osgiadapter.BundleEventType;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OSGiDirectoryBasedRepository;
import org.jvnet.hk2.osgiadapter.OSGiFactoryImpl;
import org.jvnet.hk2.osgiadapter.OSGiObrModulesRegistryImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class HK2Main
extends Main
implements BundleActivator,
SynchronousBundleListener {
    public final String DEFAULT_NAME = "_HABITAT_DEFAULT";
    private BundleContext ctx;
    private ServiceRegistration mrReg;
    private Map<ServiceLocator, HabitatInfo> habitatInfos = new HashMap<ServiceLocator, HabitatInfo>();

    public ServiceLocator createServiceLocator(StartupContext context) throws BootException {
        HabitatInfo habitatInfo = new HabitatInfo();
        habitatInfo.serviceLocator = super.createServiceLocator(context);
        this.createHK2ServiceTracker(habitatInfo);
        habitatInfo.habitatRegistration = this.ctx.registerService(ServiceLocator.class.getName(), (Object)habitatInfo.serviceLocator, (Dictionary)context.getArguments());
        this.habitatInfos.put(habitatInfo.serviceLocator, habitatInfo);
        return habitatInfo.serviceLocator;
    }

    private void destroyHabitat(ServiceLocator serviceLocator) {
        HabitatInfo habitatInfo = this.habitatInfos.get(serviceLocator);
        if (habitatInfo == null) {
            return;
        }
        habitatInfo.habitatRegistration.unregister();
        this.stopHK2ServiceTracker(habitatInfo);
        habitatInfo = null;
        this.habitatInfos.remove(serviceLocator);
    }

    private void createHK2ServiceTracker(HabitatInfo habitatInfo) {
        habitatInfo.osgiServiceTracker = new ServiceTracker(this.ctx, (Filter)new NonHK2ServiceFilter(), (ServiceTrackerCustomizer)new HK2ServiceTrackerCustomizer(habitatInfo.serviceLocator));
        habitatInfo.osgiServiceTracker.open(true);
    }

    private void stopHK2ServiceTracker(HabitatInfo habitatInfo) {
        if (habitatInfo.osgiServiceTracker != null) {
            habitatInfo.osgiServiceTracker.close();
            habitatInfo.osgiServiceTracker = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        this.ctx = context;
        Logger.logger.entering("HK2Main", "start", new Object[]{context});
        OSGiFactoryImpl.initialize(this.ctx);
        ModulesRegistry mr = this.createModulesRegistry();
        if (TracingUtilities.isEnabled()) {
            this.registerBundleDumper(mr);
        }
        this.ctx.registerService(Main.class.getName(), (Object)this, null);
    }

    private void registerBundleDumper(final ModulesRegistry mr) {
        this.ctx.addBundleListener((BundleListener)new SynchronousBundleListener(){

            public void bundleChanged(final BundleEvent event) {
                switch (event.getType()) {
                    case 32: {
                        TracingUtilities.traceResolution((ModulesRegistry)mr, (long)event.getBundle().getBundleId(), (String)event.getBundle().getSymbolicName(), (TracingUtilities.Loader)new TracingUtilities.Loader(){

                            public Class loadClass(String type) throws ClassNotFoundException {
                                return event.getBundle().loadClass(type);
                            }
                        });
                        break;
                    }
                    case 2: {
                        TracingUtilities.traceStarted((ModulesRegistry)mr, (long)event.getBundle().getBundleId(), (String)event.getBundle().getSymbolicName(), (TracingUtilities.Loader)new TracingUtilities.Loader(){

                            public Class loadClass(String type) throws ClassNotFoundException {
                                return event.getBundle().loadClass(type);
                            }
                        });
                    }
                }
            }
        });
    }

    protected ModulesRegistry createModulesRegistry() throws Exception {
        String osgiRepositoryUris;
        assert (this.mrReg == null);
        ModulesRegistry mr = AbstractFactory.getInstance().createModulesRegistry();
        String hk2RepositoryUris = this.ctx.getProperty("com.sun.enterprise.hk2.repositories");
        if (hk2RepositoryUris != null) {
            for (String s : hk2RepositoryUris.split("\\s")) {
                URI repoURI = URI.create(s);
                File repoDir = new File(repoURI);
                OSGiDirectoryBasedRepository repo = new OSGiDirectoryBasedRepository(repoDir.getAbsolutePath(), repoDir);
                repo.initialize();
                mr.addRepository((Repository)repo);
            }
        }
        if ((osgiRepositoryUris = this.ctx.getProperty("com.sun.enterprise.hk2.obrRepositories")) != null && mr instanceof OSGiObrModulesRegistryImpl) {
            OSGiObrModulesRegistryImpl mr1 = (OSGiObrModulesRegistryImpl)mr;
            for (String s : osgiRepositoryUris.split("\\s")) {
                mr1.addObr(URI.create(s));
            }
        }
        mr.dumpState(System.out);
        this.mrReg = this.ctx.registerService(ModulesRegistry.class.getName(), (Object)mr, null);
        return mr;
    }

    protected void defineParentClassLoader() throws BootException {
    }

    public void stop(BundleContext context) throws Exception {
        for (HabitatInfo habitatInfo : this.habitatInfos.values()) {
            ModuleStartup startupService = (ModuleStartup)habitatInfo.serviceLocator.getService(ModuleStartup.class, "_HABITAT_DEFAULT", new Annotation[0]);
            if (startupService != null) {
                try {
                    Logger.logger.info("Stopping " + startupService);
                    startupService.stop();
                }
                catch (Exception e) {
                    Logger.logger.log(Level.WARNING, "HK2Main:stop():Exception while stopping ModuleStartup service.", e);
                }
            }
            this.destroyHabitat(habitatInfo.serviceLocator);
        }
        ModulesRegistry mr = (ModulesRegistry)this.ctx.getService(this.mrReg.getReference());
        if (mr != null) {
            mr.shutdown();
            mr = null;
        }
    }

    public void bundleChanged(BundleEvent event) {
        Logger.logger.logp(Level.FINE, "HK2Main", "bundleChanged", "source= {0}, type= {1}", new Object[]{event.getSource(), BundleEventType.valueOf(event.getType())});
    }

    private class HK2ServiceTrackerCustomizer
    implements ServiceTrackerCustomizer {
        private final ServiceLocator serviceLocator;

        private HK2ServiceTrackerCustomizer(ServiceLocator serviceLocator) {
            this.serviceLocator = serviceLocator;
        }

        public Object addingService(ServiceReference reference) {
            Object object = HK2Main.this.ctx.getService(reference);
            if (object == null) {
                Logger.logger.logp(Level.INFO, "HK2Main$HK2ServiceTrackerCustomizer", "addingService", "Skipping registration of inhabitant for service reference {0} as the service object could not be obtained.", new Object[]{reference});
                return null;
            }
            DynamicConfigurationService dcs = (DynamicConfigurationService)this.serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
            DynamicConfiguration config = dcs.createDynamicConfiguration();
            String[] contractNames = (String[])reference.getProperty("objectclass");
            if (contractNames != null && contractNames.length > 0) {
                for (String contractName : contractNames) {
                    String name = (String)reference.getProperty("component.name");
                    if (name == null) {
                        name = (String)reference.getProperty("org.springframework.osgi.bean.name");
                    }
                    AbstractActiveDescriptor descriptor = BuilderHelper.createConstantDescriptor((Object)object);
                    try {
                        descriptor.addContractType(object.getClass().getClassLoader().loadClass(contractName));
                        descriptor.setName(name);
                        config.addActiveDescriptor((ActiveDescriptor)descriptor);
                        Logger.logger.logp(Level.FINE, "HK2Main$HK2ServiceTrackerCustomizer", "addingService", "registering service = {0}, contract = {1}, name = {2}", new Object[]{object, contractName, name});
                    }
                    catch (ClassNotFoundException e) {
                        Logger.logger.log(Level.SEVERE, "Cannot resolve contract " + contractName, e);
                    }
                }
                config.commit();
            } else {
                config.bind((Descriptor)BuilderHelper.createConstantDescriptor((Object)object));
                config.commit();
                Logger.logger.logp(Level.FINE, "HK2Main$HK2ServiceTrackerCustomizer", "addingService", "registering service = {0}", object);
            }
            return object;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, final Object service) {
            String[] contractNames = (String[])reference.getProperty("objectclass");
            DynamicConfigurationService dcs = (DynamicConfigurationService)this.serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
            DynamicConfiguration config = dcs.createDynamicConfiguration();
            if (contractNames != null && contractNames.length > 0) {
                config.addUnbindFilter((org.glassfish.hk2.api.Filter)BuilderHelper.createNameAndContractFilter((String)contractNames[0], (String)("" + service)));
                config.commit();
                Logger.logger.logp(Level.FINE, "HK2Main$HK2ServiceTrackerCustomizer", "removingService", "removing service = {0}, contract = {1}", new Object[]{service, contractNames[0]});
            } else {
                org.glassfish.hk2.api.Filter filter = new org.glassfish.hk2.api.Filter(){

                    public boolean matches(Descriptor d) {
                        return d.getImplementation().equals(service.getClass().getCanonicalName());
                    }
                };
                config.addUnbindFilter(filter);
                config.commit();
            }
        }
    }

    private class NonHK2ServiceFilter
    implements Filter {
        private NonHK2ServiceFilter() {
        }

        public boolean match(ServiceReference serviceReference) {
            return !HK2Main.this.ctx.getBundle().equals(serviceReference.getBundle());
        }

        public boolean match(Dictionary dictionary) {
            throw new RuntimeException("Unexpected method called");
        }

        public boolean matchCase(Dictionary dictionary) {
            throw new RuntimeException("Unexpected method called");
        }

        public String toString() {
            return "(objectClass=*)";
        }
    }

    private class HabitatInfo {
        private ServiceLocator serviceLocator;
        private ServiceRegistration habitatRegistration;
        private ServiceTracker osgiServiceTracker;
        private ServiceRegistration moduleStartupRegistration;

        private HabitatInfo() {
        }
    }
}

