/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.RepositoryChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.bundlerepository.Resource;
import org.jvnet.hk2.osgiadapter.OSGiModuleDefinition;
import org.osgi.framework.Version;

public class OSGiObrBasedRepository
implements Repository {
    private org.apache.felix.bundlerepository.Repository obr;

    public OSGiObrBasedRepository(org.apache.felix.bundlerepository.Repository obr) {
        this.obr = obr;
    }

    public String getName() {
        return this.obr.getName();
    }

    public URI getLocation() {
        return URI.create(this.obr.getURI());
    }

    public ModuleDefinition find(String name, String version) {
        List<ModuleDefinition> mds = this.findAll(name, version);
        return mds.isEmpty() ? null : mds.get(0);
    }

    public List<ModuleDefinition> findAll() {
        return this.findAll(null, null);
    }

    private ModuleDefinition makeModuleDef(File jar) throws IOException {
        return new OSGiModuleDefinition(jar);
    }

    public List<ModuleDefinition> findAll(String name) {
        return this.findAll(name, null);
    }

    private List<ModuleDefinition> findAll(String name, String version) {
        ArrayList<ModuleDefinition> mds = new ArrayList<ModuleDefinition>();
        for (Resource resource : this.obr.getResources()) {
            if (name == null) continue;
            String rsn = resource.getSymbolicName();
            Version rv = resource.getVersion();
            boolean versionMatching = version == null || version.equals(rv);
            boolean nameMatching = name.equals(rsn);
            if (!nameMatching || !versionMatching) continue;
            try {
                URI uri = URI.create(resource.getURI());
                mds.add(this.makeModuleDef(new File(uri)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return mds;
    }

    public void initialize() throws IOException {
    }

    public void shutdown() throws IOException {
    }

    public List<URI> getJarLocations() {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (Resource resource : this.obr.getResources()) {
            URI e = URI.create(resource.getURI());
            uris.add(e);
        }
        return uris;
    }

    public boolean addListener(RepositoryChangeListener listener) {
        return false;
    }

    public boolean removeListener(RepositoryChangeListener listener) {
        return false;
    }
}

