/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.Repository;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.osgiadapter.OSGiDirectoryBasedRepository;
import org.jvnet.hk2.osgiadapter.OSGiModulesRegistryImpl;
import org.jvnet.hk2.osgiadapter.OSGiObrModuleImpl;
import org.jvnet.hk2.osgiadapter.ObrHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;

public class OSGiObrModulesRegistryImpl
extends OSGiModulesRegistryImpl {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getPackage().getName());
    private final ObrHandler obrHandler;

    OSGiObrModulesRegistryImpl(BundleContext bctx) {
        super(bctx);
        this.obrHandler = new ObrHandler(bctx);
    }

    public void addObr(URI obrUri) throws Exception {
        this.obrHandler.addRepository(obrUri);
    }

    public void addRepository(Repository repository, int weight) {
        if (repository instanceof OSGiDirectoryBasedRepository) {
            try {
                this.obrHandler.addRepository((OSGiDirectoryBasedRepository)repository);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        super.addRepository(repository, weight);
    }

    public void addRepository(Repository repository) {
        this.addRepository(repository, 1);
    }

    @Override
    protected Module newModule(ModuleDefinition moduleDef) {
        try {
            return new OSGiObrModuleImpl(this, moduleDef);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Module loadFromRepository(String name, String version) {
        Bundle bundle = this.getObrHandler().deploy(name, version);
        return this.getModule(bundle);
    }

    @Override
    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 1: {
                Module module = this.getModule(event.getBundle());
                if (!(module instanceof OSGiObrModuleImpl)) break;
                ((OSGiObrModuleImpl)OSGiObrModuleImpl.class.cast(module)).setBundle(event.getBundle());
                return;
            }
        }
        super.bundleChanged(event);
    }

    @Override
    public void shutdown() {
        this.getObrHandler().close();
        List<Bundle> bundlesToUninstall = this.getBundlesToUninstall();
        System.out.println("OSGiObrModulesRegistryImpl.shutdown: bundlesToUninstall = " + Arrays.toString(this.getBundleIds(bundlesToUninstall).toArray()));
        this.logger.logp(Level.INFO, "OSGiObrModulesRegistryImpl", "shutdown", "bundlesToUninstall = {0}", new Object[]{Arrays.toString(this.getBundleIds(bundlesToUninstall).toArray())});
        for (Bundle bundle : bundlesToUninstall) {
            try {
                bundle.uninstall();
            }
            catch (BundleException e) {
                this.logger.logp(Level.WARNING, "OSGiObrModulesRegistryImpl", "shutdown", "Exception while uninstalling bundle " + bundle.getBundleId(), e);
            }
        }
        super.shutdown();
    }

    private List<Bundle> getBundlesToUninstall() {
        ArrayList<Bundle> bundlesToUninstall = new ArrayList<Bundle>();
        for (Bundle bundle : this.bctx.getBundles()) {
            if (!bundle.getLocation().startsWith("obr:")) continue;
            bundlesToUninstall.add(bundle);
        }
        Collections.sort(bundlesToUninstall, new Comparator<Bundle>(){

            @Override
            public int compare(Bundle o1, Bundle o2) {
                return (int)(o2.getBundleId() - o1.getBundleId());
            }
        });
        return bundlesToUninstall;
    }

    private List<Long> getBundleIds(List<Bundle> bundlesToUninstall) {
        ArrayList<Long> ids = new ArrayList<Long>(bundlesToUninstall.size());
        for (Bundle bundle : bundlesToUninstall) {
            ids.add(bundle.getBundleId());
        }
        return ids;
    }

    ObrHandler getObrHandler() {
        return this.obrHandler;
    }
}

