/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.ModuleDefinition;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import org.apache.felix.bundlerepository.DataModelHelper;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OSGiDirectoryBasedRepository;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.util.tracker.ServiceTracker;

class ObrHandler
extends ServiceTracker {
    public ObrHandler(BundleContext bctx) {
        super(bctx, RepositoryAdmin.class.getName(), null);
        this.open();
    }

    public Object addingService(ServiceReference reference) {
        if (this.getTrackingCount() == 1) {
            Logger.logger.logp(Level.INFO, "ObrHandler", "addingService", "We already have a repository admin service, so ignoring {0}", new Object[]{reference});
            return null;
        }
        return super.addingService(reference);
    }

    public void remove(ServiceReference reference) {
        super.remove(reference);
    }

    public RepositoryAdmin getRepositoryAdmin() {
        assert (this.getTrackingCount() < 2);
        try {
            return (RepositoryAdmin)this.waitForService(10000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public synchronized void addRepository(URI obrUri) throws Exception {
        if (this.isDirectory(obrUri)) {
            this.setupRepository(new File(obrUri), this.isSynchronous());
        } else {
            this.getRepositoryAdmin().addRepository(obrUri.toURL());
        }
    }

    private boolean isDirectory(URI obrUri) {
        try {
            new File(obrUri);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public synchronized void addRepository(OSGiDirectoryBasedRepository hk2Repo) throws Exception {
        File dir = new File(hk2Repo.getLocation());
        this.setupRepository(dir, this.isSynchronous());
    }

    public void setupRepository(final File repoDir, boolean synchronous) throws Exception {
        if (synchronous) {
            this._setupRepository(repoDir);
        } else {
            Executors.newSingleThreadExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        ObrHandler.this._setupRepository(repoDir);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    private boolean isSynchronous() {
        return Boolean.TRUE.toString().equalsIgnoreCase(this.context.getProperty("com.sun.enterprise.hk2.initializeRepoSynchronously"));
    }

    private synchronized void _setupRepository(File repoDir) throws Exception {
        File repoXml = this.getRepositoryXmlFile(repoDir);
        if (repoXml.exists()) {
            this.updateRepository(repoXml, repoDir);
        } else {
            this.createRepository(repoXml, repoDir);
        }
        URL repoUrl = repoXml.toURI().toURL();
        Logger.logger.logp(Level.INFO, "ObrHandler", "setupRepository", "Adding repository = {0}", new Object[]{repoUrl});
        long t = System.currentTimeMillis();
        this.getRepositoryAdmin().addRepository(repoUrl);
        Logger.logger.logp(Level.INFO, "ObrHandler", "setupRepository", "Thread #{0}: Adding repo took {1} ms", new Object[]{Thread.currentThread().getId(), System.currentTimeMillis() - t});
    }

    private File getRepositoryXmlFile(File repoDir) {
        return new File(this.context.getDataFile(""), repoDir.getName() + "repository.xml");
    }

    private void createRepository(File repoXml, File repoDir) throws IOException {
        DataModelHelper dmh = this.getRepositoryAdmin().getHelper();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (File jar : this.findAllJars(repoDir)) {
            Resource r = dmh.createResource(jar.toURI().toURL());
            resources.add(r);
        }
        Repository repository = dmh.repository(resources.toArray(new Resource[resources.size()]));
        FileWriter writer = new FileWriter(repoXml);
        dmh.writeRepository(repository, (Writer)writer);
        writer.flush();
        Logger.logger.logp(Level.INFO, "ObrHandler", "createRepository", "Created {0} containing {1} resources.", new Object[]{repoXml, resources.size()});
    }

    private void updateRepository(File repoXml, File repoDir) throws IOException {
        boolean obsoleteRepo = false;
        long lastModifiedTime = repoXml.lastModified();
        boolean bl = obsoleteRepo = repoDir.lastModified() > lastModifiedTime;
        if (!obsoleteRepo) {
            for (File jar : this.findAllJars(repoDir)) {
                if (jar.lastModified() <= lastModifiedTime) continue;
                Logger.logger.logp(Level.INFO, "ObrHandler", "updateRepository", "{0} is newer than repository.xml", new Object[]{jar});
                obsoleteRepo = true;
                break;
            }
        }
        if (obsoleteRepo) {
            if (!repoXml.delete()) {
                throw new IOException("Failed to delete " + repoXml);
            }
            Logger.logger.logp(Level.INFO, "ObrHandler", "updateRepository", "Recreating {0}", new Object[]{repoXml});
            this.createRepository(repoXml, repoDir);
        }
    }

    private List<File> findAllJars(File repo) {
        final ArrayList<File> files = new ArrayList<File>();
        repo.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    pathname.listFiles(this);
                } else if (pathname.getName().endsWith("jar")) {
                    files.add(pathname);
                }
                return true;
            }
        });
        return files;
    }

    synchronized Bundle deploy(Resource resource) {
        Resolver resolver = this.getRepositoryAdmin().resolver();
        resolver.add(resource);
        if (!resolver.resolve()) {
            this.printResolverOutput(resolver);
            Object[] reqs = resolver.getUnsatisfiedRequirements();
            Logger.logger.logp(Level.WARNING, "ObrHandler", "deploy", "Unable to satisfy the requirements: {0}", new Object[]{Arrays.toString(reqs)});
            return null;
        }
        this.printResolverOutput(resolver);
        resolver.deploy(1);
        return this.getBundle(resource);
    }

    synchronized Bundle deploy(String name, String version) {
        Resource resource = this.findResource(name, version);
        if (resource == null) {
            Logger.logger.logp(Level.INFO, "ObrHandler", "deploy", "No resource matching name = {0} and version = {1} ", new Object[]{name, version});
            return null;
        }
        if (resource.isLocal()) {
            return this.getBundle(resource);
        }
        return this.deploy(resource);
    }

    synchronized Bundle deploy(ModuleDefinition md) {
        return this.deploy(md.getName(), md.getVersion());
    }

    private Bundle getBundle(Resource resource) {
        for (Bundle b : this.context.getBundles()) {
            boolean nameMatching;
            String bsn = b.getSymbolicName();
            Version bv = b.getVersion();
            String rsn = resource.getSymbolicName();
            Version rv = resource.getVersion();
            boolean versionMatching = rv == bv || rv != null && rv.equals((Object)bv);
            boolean bl = nameMatching = bsn == rsn || bsn != null && bsn.equals(rsn);
            if (!nameMatching || !versionMatching) continue;
            return b;
        }
        return null;
    }

    private Resource findResource(String name, String version) {
        RepositoryAdmin repositoryAdmin = this.getRepositoryAdmin();
        if (repositoryAdmin == null) {
            Logger.logger.logp(Level.WARNING, "ObrHandler", "findResource", "OBR is not yet available, so can't find resource with name = {0} and version = {1} from repository", new Object[]{name, version});
            return null;
        }
        String s1 = "(symbolicname=" + name + ")";
        String s2 = "(version=" + version + ")";
        String query = version != null ? "(&" + s1 + s2 + ")" : s1;
        try {
            Object[] resources = this.getRepositoryAdmin().discoverResources(query);
            Logger.logger.logp(Level.INFO, "ObrHandler", "findResource", "Using the first one from the list of {0} discovered bundles shown below: {1}", new Object[]{resources.length, Arrays.toString(resources)});
            return resources.length > 0 ? resources[0] : null;
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void printResolverOutput(Resolver resolver) {
        Resource[] addedResources = resolver.getAddedResources();
        Resource[] requiredResources = resolver.getRequiredResources();
        Resource[] optionalResources = resolver.getOptionalResources();
        Reason[] unsatisfiedRequirements = resolver.getUnsatisfiedRequirements();
        StringBuffer sb = new StringBuffer("Added resources: [");
        for (Resource resource : addedResources) {
            sb.append("\n").append(resource.getSymbolicName()).append(", ").append(resource.getVersion()).append(", ").append(resource.getURI());
        }
        sb.append("]\nRequired Resources: [");
        for (Resource resource : requiredResources) {
            sb.append("\n").append(resource.getURI());
        }
        sb.append("]\nUnsatisfied requirements: [");
        for (Resource resource : unsatisfiedRequirements) {
            sb.append("\n").append(resource.getRequirement());
        }
        sb.append("]");
        Logger.logger.logp(Level.INFO, "ObrHandler", "printResolverOutput", "OBR resolver state: {0}", new Object[]{sb});
    }
}

