/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.InhabitantsDescriptor;
import com.sun.enterprise.module.LifecyclePolicy;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleChangeListener;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.ResolveError;
import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InhabitantsParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OSGiModulesRegistryImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.RequiredBundle;

public class OSGiModuleImpl
implements Module {
    private volatile Bundle bundle;
    private ModuleDefinition md;
    private OSGiModulesRegistryImpl registry;
    private boolean isTransientlyActive = false;
    private LifecyclePolicy lifecyclePolicy;
    private static final Enumeration<URL> EMPTY_URLS = new Enumeration<URL>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public URL nextElement() {
            throw new NoSuchElementException();
        }
    };

    public OSGiModuleImpl(OSGiModulesRegistryImpl registry, Bundle bundle, ModuleDefinition md) {
        this.registry = registry;
        this.bundle = bundle;
        this.md = md;
    }

    public ModuleDefinition getModuleDefinition() {
        return this.md;
    }

    public String getName() {
        return this.md.getName();
    }

    public ModulesRegistry getRegistry() {
        return this.registry;
    }

    public ModuleState getState() {
        return OSGiModuleImpl.mapBundleStateToModuleState(this.bundle);
    }

    static ModuleState mapBundleStateToModuleState(Bundle bundle) {
        ModuleState state;
        switch (bundle.getState()) {
            case 1: 
            case 2: {
                state = ModuleState.NEW;
                break;
            }
            case 4: {
                state = ModuleState.RESOLVED;
                break;
            }
            case 8: {
                state = ModuleState.PREPARING;
                break;
            }
            case 32: {
                state = ModuleState.READY;
                break;
            }
            default: {
                throw new RuntimeException("Does not know how to handle bundle with state [" + bundle.getState() + "]");
            }
        }
        return state;
    }

    public synchronized void resolve() throws ResolveError {
        this.start();
    }

    public synchronized void start() throws ResolveError {
        int state = this.bundle.getState();
        if ((0x38 & state) != 0) {
            if (Logger.logger.isLoggable(Level.FINER)) {
                Logger.logger.logp(Level.FINER, "OSGiModuleImpl", "start", "Ignoring start of bundle {0} as it is in {1} state", new Object[]{this.bundle, this.toString(this.bundle.getState())});
            }
            return;
        }
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws BundleException {
                            OSGiModuleImpl.this.bundle.start(1);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (BundleException)((Object)e.getException());
                }
            } else {
                this.bundle.start(1);
            }
            this.isTransientlyActive = true;
            if (Logger.logger.isLoggable(Level.FINE)) {
                Logger.logger.logp(Level.FINE, "OSGiModuleImpl", "start", "Started bundle {0}", this.bundle);
            }
        }
        catch (BundleException e) {
            throw new ResolveError("Failed to start " + this, (Throwable)e);
        }
        if (this.md.getLifecyclePolicyClassName() != null) {
            try {
                Class lifecyclePolicyClass = this.bundle.loadClass(this.md.getLifecyclePolicyClassName());
                this.lifecyclePolicy = (LifecyclePolicy)lifecyclePolicyClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new ResolveError("ClassNotFound : " + e.getMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ResolveError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ResolveError((Throwable)e);
            }
        }
        if (this.lifecyclePolicy != null) {
            this.lifecyclePolicy.start((Module)this);
        }
    }

    private String toString(int state) {
        String value;
        switch (state) {
            case 8: {
                value = "STARTING";
                break;
            }
            case 16: {
                value = "STOPPING";
                break;
            }
            case 2: {
                value = "INSTALLED";
                break;
            }
            case 1: {
                value = "UNINSTALLED";
                break;
            }
            case 4: {
                value = "RESOLVED";
                break;
            }
            case 32: {
                value = "ACTIVE";
                break;
            }
            default: {
                value = "UNKNOWN STATE [" + state + "]";
                Logger.logger.warning("No mapping exist for bundle state " + state);
            }
        }
        return value;
    }

    public synchronized boolean stop() {
        this.detach();
        return true;
    }

    public void detach() {
        if (this.bundle.getState() != 32) {
            if (Logger.logger.isLoggable(Level.FINER)) {
                Logger.logger.logp(Level.FINER, "OSGiModuleImpl", "detach", "Ignoring stop of bundle {0} as it is in {1} state", new Object[]{this.bundle, this.toString(this.bundle.getState())});
            }
            return;
        }
        if (this.lifecyclePolicy != null) {
            this.lifecyclePolicy.stop((Module)this);
            this.lifecyclePolicy = null;
        }
        try {
            this.bundle.stop();
            if (Logger.logger.isLoggable(Level.FINE)) {
                Logger.logger.logp(Level.FINE, "OSGiModuleImpl", "detach", "Stopped bundle = {0}", new Object[]{this.bundle});
            }
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
    }

    public void uninstall() {
        try {
            this.bundle.uninstall();
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
        this.registry.remove(this);
        this.registry = null;
    }

    public void refresh() {
        URI location = this.md.getLocations()[0];
        File f = new File(location);
        if (f.lastModified() > this.bundle.getLastModified()) {
            try {
                this.bundle.update();
                this.registry.getPackageAdmin().refreshPackages(new Bundle[]{this.bundle});
            }
            catch (BundleException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ModuleMetadata getMetadata() {
        return this.md.getMetadata();
    }

    public <T> Iterable<Class<? extends T>> getProvidersClass(Class<T> serviceClass) {
        return this.getProvidersClass(serviceClass.getName());
    }

    public Iterable<Class> getProvidersClass(String name) {
        ArrayList<Class> r = new ArrayList<Class>();
        for (String provider : this.getMetadata().getEntry((String)name).providerNames) {
            try {
                r.add(this.getClassLoader().loadClass(provider));
            }
            catch (ClassNotFoundException e) {
                Logger.logger.log(Level.SEVERE, "Failed to load " + provider + " from " + this.getName(), e);
            }
        }
        return r;
    }

    public boolean hasProvider(Class serviceClass) {
        String name = serviceClass.getName();
        return this.getMetadata().getEntry(name).hasProvider();
    }

    public void addListener(ModuleChangeListener listener) {
        this.registry.addModuleChangeListener(listener, this);
    }

    public void removeListener(ModuleChangeListener listener) {
        this.registry.removeModuleChangeListener(listener);
    }

    public void dumpState(PrintStream writer) {
        writer.print(this.toString());
    }

    void parseInhabitants(String name, InhabitantsParser parser) throws IOException {
        Holder<ClassLoader> holder = new Holder<ClassLoader>(){

            public ClassLoader get() {
                ClassLoader ret = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new ClassLoader(){

                            @Override
                            public synchronized Class<?> loadClass(final String name) throws ClassNotFoundException {
                                if (Logger.logger.isLoggable(Level.FINE)) {
                                    Logger.logger.logp(Level.FINE, "OSGiModuleImpl", "loadClass", "Loading {0} from bundle: {1}", new Object[]{name, OSGiModuleImpl.this.bundle});
                                }
                                OSGiModuleImpl.this.start();
                                try {
                                    Class aClass = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                                        public Object run() {
                                            try {
                                                return OSGiModuleImpl.this.bundle.loadClass(name);
                                            }
                                            catch (Throwable e) {
                                                Logger.logger.logp(Level.SEVERE, "OSGiModuleImpl", "loadClass", "Exception in module " + OSGiModuleImpl.this.bundle.toString() + " : " + e.toString());
                                                throw new RuntimeException(e);
                                            }
                                        }
                                    });
                                    if (Logger.logger.isLoggable(Level.FINE)) {
                                        Logger.logger.logp(Level.FINE, "OSGiModuleImpl", "loadClass", name + ".class.getClassLoader() = {0}", aClass.getClassLoader());
                                    }
                                    return aClass;
                                }
                                catch (RuntimeException e) {
                                    Logger.logger.logp(Level.SEVERE, "OSGiModuleImpl", "loadClass", "Exception in module " + OSGiModuleImpl.this.bundle.toString() + " : " + e.toString());
                                    throw new ClassNotFoundException(e.getCause().getMessage(), e.getCause());
                                }
                            }
                        };
                    }
                });
                return ret;
            }
        };
        for (InhabitantsDescriptor d : this.md.getMetadata().getHabitats(name)) {
            parser.parse(d.createScanner(), (Holder)holder);
        }
    }

    public ClassLoader getClassLoader() {
        return new ClassLoader(Bundle.class.getClassLoader()){

            @Override
            protected synchronized Class<?> loadClass(final String name, boolean resolve) throws ClassNotFoundException {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                        @Override
                        public Class run() throws ClassNotFoundException {
                            return OSGiModuleImpl.this.bundle.loadClass(name);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (ClassNotFoundException)e.getException();
                }
            }

            @Override
            public URL getResource(String name) {
                URL result = OSGiModuleImpl.this.bundle.getResource(name);
                if (result != null) {
                    return result;
                }
                return null;
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                Enumeration resources = OSGiModuleImpl.this.bundle.getResources(name);
                if (resources == null) {
                    resources = EMPTY_URLS;
                }
                return resources;
            }

            public String toString() {
                return "Class Loader for Bundle [" + OSGiModuleImpl.this.bundle.toString() + " ]";
            }
        };
    }

    public void addImport(Module module) {
        throw new UnsupportedOperationException("This method can't be implemented in OSGi environment");
    }

    public Module addImport(ModuleDependency dependency) {
        throw new UnsupportedOperationException("This method can't be implemented in OSGi environment");
    }

    public boolean isSticky() {
        return true;
    }

    public void setSticky(boolean sticky) {
    }

    public List<Module> getImports() {
        ArrayList<Module> result = new ArrayList<Module>();
        RequiredBundle[] requiredBundles = this.registry.getPackageAdmin().getRequiredBundles(this.bundle.getSymbolicName());
        if (requiredBundles != null) {
            for (RequiredBundle rb : requiredBundles) {
                Module m = this.registry.getModule(rb.getBundle());
                if (m == null) continue;
                result.add(m);
            }
        }
        return result;
    }

    public boolean isShared() {
        return true;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public boolean isTransientlyActive() {
        return this.isTransientlyActive;
    }

    public String toString() {
        return "OSGiModuleImpl:: Bundle = [" + this.bundle + "], State = [" + this.getState() + "]";
    }

    public int hashCode() {
        return this.bundle.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OSGiModuleImpl) {
            return this.bundle.equals(((OSGiModuleImpl)OSGiModuleImpl.class.cast((Object)obj)).bundle);
        }
        return false;
    }

    protected void setBundle(Bundle bundle) {
        if (this.bundle != null && this.bundle != bundle) {
            throw new RuntimeException("setBundle called with bundle [" + bundle + "] where as module [" + this + "] is already associated with bundle [" + this.bundle + "]");
        }
        this.bundle = bundle;
        Logger.logger.logp(Level.INFO, "OSGiModuleImpl", "setBundle", "module [{0}] is now associated with bundle [{1}]", new Object[]{this, bundle});
    }
}

