/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.examples.operations.application.internal;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.examples.operations.application.BankingService;
import org.glassfish.examples.operations.application.DepositorService;
import org.glassfish.examples.operations.application.TransferService;
import org.glassfish.examples.operations.application.WithdrawalService;
import org.glassfish.examples.operations.application.internal.DepositScopeImpl;
import org.glassfish.examples.operations.application.internal.WithdrawalScopeImpl;
import org.glassfish.examples.operations.scopes.DepositScope;
import org.glassfish.examples.operations.scopes.WithdrawalScope;
import org.glassfish.hk2.extras.operation.OperationHandle;
import org.glassfish.hk2.extras.operation.OperationManager;

@Singleton
public class BankingServiceImpl
implements BankingService {
    @Inject
    private OperationManager manager;
    @Inject
    private TransferService transferAgent;
    @Inject
    private DepositorService depositorAgent;
    @Inject
    private WithdrawalService withdrawerAgent;
    private final Map<String, OperationHandle<DepositScope>> depositors = new HashMap<String, OperationHandle<DepositScope>>();
    private final Map<String, OperationHandle<WithdrawalScope>> withdrawers = new HashMap<String, OperationHandle<WithdrawalScope>>();

    private synchronized OperationHandle<DepositScope> getDepositBankHandle(String bank) {
        OperationHandle depositor = this.depositors.get(bank);
        if (depositor == null) {
            depositor = this.manager.createOperation((Annotation)DepositScopeImpl.INSTANCE);
            this.depositors.put(bank, (OperationHandle<DepositScope>)depositor);
        }
        return depositor;
    }

    private synchronized OperationHandle<WithdrawalScope> getWithdrawerBankHandle(String bank) {
        OperationHandle withdrawer = this.withdrawers.get(bank);
        if (withdrawer == null) {
            withdrawer = this.manager.createOperation((Annotation)WithdrawalScopeImpl.INSTANCE);
            this.withdrawers.put(bank, (OperationHandle<WithdrawalScope>)withdrawer);
        }
        return withdrawer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int transferFunds(String withdrawlBank, long withdrawlAccount, String depositorBank, long depositAccount, int funds) {
        OperationHandle<DepositScope> depositor = this.getDepositBankHandle(depositorBank);
        OperationHandle<WithdrawalScope> withdrawer = this.getWithdrawerBankHandle(withdrawlBank);
        depositor.resume();
        withdrawer.resume();
        try {
            int n = this.transferAgent.doTransfer(depositAccount, withdrawlAccount, funds);
            return n;
        }
        finally {
            withdrawer.suspend();
            depositor.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDepositedBalance(String bank, long account) {
        OperationHandle<DepositScope> depositor = this.getDepositBankHandle(bank);
        depositor.resume();
        try {
            int n = this.depositorAgent.getBalance(account);
            return n;
        }
        finally {
            depositor.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWithdrawalBalance(String bank, long account) {
        OperationHandle<WithdrawalScope> withdrawer = this.getWithdrawerBankHandle(bank);
        withdrawer.resume();
        try {
            int n = this.withdrawerAgent.getBalance(account);
            return n;
        }
        finally {
            withdrawer.suspend();
        }
    }
}

