/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.utilities.general.IndentingXMLStreamWriter;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.Logger;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.internal.AliasType;
import org.glassfish.hk2.xml.internal.ChildDataModel;
import org.glassfish.hk2.xml.internal.ChildDescriptor;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.Format;
import org.glassfish.hk2.xml.internal.ModelImpl;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.internal.QNameUtilities;
import org.glassfish.hk2.xml.internal.ReferenceKey;
import org.glassfish.hk2.xml.internal.UnresolvedReference;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.XmlServiceImpl;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;
import org.glassfish.hk2.xml.spi.Model;

public class XmlStreamImpl {
    private static final boolean DEBUG_PARSING = XmlServiceImpl.DEBUG_PARSING;
    private static final QName ANY_ATTRIBUTE_QNAME = QNameUtilities.createQName("##default", "##XmlAnyAttribute");

    public static <T> T parseRoot(XmlServiceImpl xmlService, Model rootModel, XMLStreamReader reader, Unmarshaller.Listener listener) throws Exception {
        Class<?> rootProxyClass = rootModel.getProxyAsClass();
        ClassReflectionHelper classReflectionHelper = xmlService.getClassReflectionHelper();
        BaseHK2JAXBBean hk2Root = Utilities.createBean(rootProxyClass);
        hk2Root._setClassReflectionHelper(classReflectionHelper);
        if (DEBUG_PARSING) {
            Logger.getLogger().debug("XmlServiceDebug Created root bean with model " + hk2Root._getModel());
        }
        HashMap<ReferenceKey, BaseHK2JAXBBean> referenceMap = new HashMap<ReferenceKey, BaseHK2JAXBBean>();
        LinkedList<UnresolvedReference> unresolved = new LinkedList<UnresolvedReference>();
        while (reader.hasNext()) {
            int event = reader.next();
            if (DEBUG_PARSING) {
                Logger.getLogger().debug("XmlServiceDebug got xml event (A) " + XmlStreamImpl.eventToString(event));
            }
            switch (event) {
                case 1: {
                    HashMap<String, String> rootNamespace = new HashMap<String, String>();
                    String defaultNamespace = null;
                    int namespaceCount = reader.getNamespaceCount();
                    for (int nLcv = 0; nLcv < namespaceCount; ++nLcv) {
                        String namespacePrefix = reader.getNamespacePrefix(nLcv);
                        String namespaceURI = reader.getNamespaceURI(nLcv);
                        if (namespacePrefix == null) {
                            defaultNamespace = namespaceURI;
                            continue;
                        }
                        rootNamespace.put(namespacePrefix, namespaceURI);
                    }
                    String elementTagNamespace = QNameUtilities.getNamespace(reader.getName(), defaultNamespace);
                    String elementTag = reader.getName().getLocalPart();
                    if (DEBUG_PARSING) {
                        Logger.getLogger().debug("XmlServiceDebug starting document tag " + elementTag);
                    }
                    XmlStreamImpl.handleElement(hk2Root, null, reader, classReflectionHelper, listener, referenceMap, unresolved, elementTagNamespace, elementTag, rootNamespace, defaultNamespace);
                    break;
                }
                case 8: {
                    Utilities.fillInUnfinishedReferences(referenceMap, unresolved);
                    if (DEBUG_PARSING) {
                        Logger.getLogger().debug("XmlServiceDebug finished reading document");
                    }
                    return (T)hk2Root;
                }
            }
        }
        throw new IllegalStateException("Unexpected end of XMLReaderStream");
    }

    private static <T> void handleElement(BaseHK2JAXBBean target, BaseHK2JAXBBean parent, XMLStreamReader reader, ClassReflectionHelper classReflectionHelper, Unmarshaller.Listener listener, Map<ReferenceKey, BaseHK2JAXBBean> referenceMap, List<UnresolvedReference> unresolved, String outerElementNamespace, String outerElementTag, Map<String, String> namespaceMap, String defaultNamespace) throws Exception {
        listener.beforeUnmarshal((Object)target, (Object)parent);
        HashMap<QName, List<BaseHK2JAXBBean>> listChildren = new HashMap<QName, List<BaseHK2JAXBBean>>();
        HashMap<QName, List<BaseHK2JAXBBean>> arrayChildren = new HashMap<QName, List<BaseHK2JAXBBean>>();
        HashMap<QName, LinkedList<Object>> listNonChild = new HashMap<QName, LinkedList<Object>>();
        HashMap<QName, ArrayInformation> arrayNonChild = new HashMap<QName, ArrayInformation>();
        ModelImpl targetModel = target._getModel();
        Map<QName, ChildDataModel> nonChildProperties = targetModel.getNonChildProperties();
        Map<QName, ParentedModel> childProperties = targetModel.getChildrenByName();
        Set<String> allWrappers = targetModel.getAllXmlWrappers();
        LinkedHashMap<QName, String> xmlAnyAttributeData = new LinkedHashMap<QName, String>();
        int numAttributes = reader.getAttributeCount();
        for (int lcv = 0; lcv < numAttributes; ++lcv) {
            ReferenceKey rk;
            BaseHK2JAXBBean reference;
            ChildDataModel childDataModel;
            String attributeNamespace = QNameUtilities.fixNamespace(reader.getAttributeNamespace(lcv));
            String attributeName = reader.getAttributeLocalName(lcv);
            String attributeValue = reader.getAttributeValue(lcv);
            QName attributeQName = QNameUtilities.createQName(attributeNamespace, attributeName, defaultNamespace);
            if (DEBUG_PARSING) {
                Logger.getLogger().debug("XmlServiceDebug handling attribute " + attributeQName + " with value " + attributeValue);
            }
            if ((childDataModel = nonChildProperties.get(attributeQName)) == null) {
                xmlAnyAttributeData.put(attributeQName, attributeValue);
                continue;
            }
            if (!Format.ATTRIBUTE.equals((Object)childDataModel.getFormat())) continue;
            Class<?> childType = targetModel.getNonChildType(attributeNamespace, attributeName);
            if (!childDataModel.isReference()) {
                Object convertedValue = Utilities.getDefaultValue(attributeValue, childType, namespaceMap);
                target._setProperty(attributeNamespace, attributeName, convertedValue);
                continue;
            }
            if (DEBUG_PARSING) {
                Logger.getLogger().debug("XmlServiceDebug attribute " + attributeName + " is a reference");
            }
            if ((reference = referenceMap.get(rk = new ReferenceKey(childDataModel.getChildType(), attributeValue))) != null) {
                target._setProperty(attributeNamespace, attributeName, reference);
                continue;
            }
            unresolved.add(new UnresolvedReference(childDataModel.getChildType(), attributeValue, attributeNamespace, attributeName, target));
        }
        ChildDataModel childDataModel = nonChildProperties.get(ANY_ATTRIBUTE_QNAME);
        if (childDataModel != null) {
            target._setProperty(ANY_ATTRIBUTE_QNAME, xmlAnyAttributeData);
        }
        while (reader.hasNext()) {
            int event = reader.next();
            if (DEBUG_PARSING) {
                Logger.getLogger().debug("XmlServiceDebug got xml event (B) " + XmlStreamImpl.eventToString(event));
            }
            switch (event) {
                case 1: {
                    ChildDataModel cdm;
                    HashMap<String, String> effectiveNamespaceMap = null;
                    effectiveNamespaceMap = new HashMap<String, String>(namespaceMap);
                    int namespaceCount = reader.getNamespaceCount();
                    for (int nLcv = 0; nLcv < namespaceCount; ++nLcv) {
                        String namespacePrefix = reader.getNamespacePrefix(nLcv);
                        String namespaceURI = reader.getNamespaceURI(nLcv);
                        if (namespacePrefix == null) {
                            defaultNamespace = namespaceURI;
                            continue;
                        }
                        effectiveNamespaceMap.put(reader.getNamespacePrefix(nLcv), reader.getNamespaceURI(nLcv));
                    }
                    String elementTagNamespace = QNameUtilities.getNamespace(reader.getName(), defaultNamespace);
                    String elementTag = reader.getName().getLocalPart();
                    QName elementTagQName = QNameUtilities.createQName(elementTagNamespace, elementTag, defaultNamespace);
                    if (DEBUG_PARSING) {
                        Logger.getLogger().debug("XmlServiceDebug starting parse of element " + elementTag);
                    }
                    if ((cdm = nonChildProperties.get(elementTagQName)) != null && Format.ELEMENT.equals((Object)cdm.getFormat())) {
                        String elementValue = XmlStreamImpl.advanceNonChildElement(reader, elementTag);
                        Class<?> childType = cdm.getChildTypeAsClass();
                        if (!cdm.isReference()) {
                            Object convertedValue;
                            if (List.class.equals(childType)) {
                                Class<?> listType = cdm.getChildListTypeAsClass();
                                convertedValue = Utilities.getDefaultValue(elementValue, listType, effectiveNamespaceMap);
                                LinkedList<Object> listObjects = (LinkedList<Object>)listNonChild.get(elementTagQName);
                                if (listObjects == null) {
                                    listObjects = new LinkedList<Object>();
                                    listNonChild.put(elementTagQName, listObjects);
                                }
                                listObjects.add(convertedValue);
                                break;
                            }
                            if (childType.isArray() && !Byte.TYPE.equals(childType.getComponentType())) {
                                Class<?> aType = childType.getComponentType();
                                convertedValue = Utilities.getDefaultValue(elementValue, aType, effectiveNamespaceMap);
                                ArrayInformation ai = (ArrayInformation)arrayNonChild.get(elementTagQName);
                                if (ai == null) {
                                    ai = new ArrayInformation(aType);
                                    arrayNonChild.put(elementTagQName, ai);
                                }
                                ai.add(convertedValue);
                                break;
                            }
                            Object convertedValue2 = Utilities.getDefaultValue(elementValue, childType, effectiveNamespaceMap);
                            target._setProperty(elementTagNamespace, elementTag, convertedValue2);
                            break;
                        }
                        ReferenceKey referenceKey = new ReferenceKey(cdm.getChildType(), elementValue);
                        BaseHK2JAXBBean reference = referenceMap.get(referenceKey);
                        if (reference != null) {
                            target._setProperty(elementTagNamespace, elementTag, reference);
                            break;
                        }
                        unresolved.add(new UnresolvedReference(cdm.getChildType(), elementValue, elementTagNamespace, elementTag, target));
                        break;
                    }
                    ParentedModel informedChild = childProperties.get(elementTagQName);
                    if (informedChild != null) {
                        List<BaseHK2JAXBBean> cList;
                        ModelImpl grandChild = informedChild.getChildModel();
                        BaseHK2JAXBBean hk2Root = Utilities.createBean(grandChild.getProxyAsClass());
                        hk2Root._setClassReflectionHelper(classReflectionHelper);
                        if (DEBUG_PARSING) {
                            Logger.getLogger().debug("XmlServiceBean created child bean of " + outerElementNamespace + "," + outerElementTag + " with model " + hk2Root._getModel());
                        }
                        XmlStreamImpl.handleElement(hk2Root, target, reader, classReflectionHelper, listener, referenceMap, unresolved, outerElementTag, elementTag, effectiveNamespaceMap, defaultNamespace);
                        Object realThing = hk2Root;
                        if (informedChild.getAdapter() != null) {
                            XmlAdapter adapter = (XmlAdapter)ReflectionHelper.cast(informedChild.getAdapterObject());
                            realThing = adapter.unmarshal((Object)hk2Root);
                        }
                        if (informedChild.getChildType().equals((Object)ChildType.DIRECT)) {
                            target._setProperty(elementTagNamespace, elementTag, realThing);
                            break;
                        }
                        if (informedChild.getChildType().equals((Object)ChildType.LIST)) {
                            cList = (ArrayList<BaseHK2JAXBBean>)listChildren.get(elementTagQName);
                            if (cList == null) {
                                cList = new ArrayList<BaseHK2JAXBBean>();
                                listChildren.put(elementTagQName, cList);
                            }
                            cList.add(hk2Root);
                            break;
                        }
                        if (!informedChild.getChildType().equals((Object)ChildType.ARRAY)) break;
                        cList = (List)arrayChildren.get(elementTagQName);
                        if (cList == null) {
                            cList = new LinkedList();
                            arrayChildren.put(elementTagQName, cList);
                        }
                        cList.add(hk2Root);
                        break;
                    }
                    if (allWrappers.contains(elementTag)) {
                        XmlStreamImpl.skipWrapperElement(target, parent, reader, classReflectionHelper, listener, referenceMap, unresolved, elementTagNamespace, elementTag, effectiveNamespaceMap, defaultNamespace, elementTag, listChildren, arrayChildren);
                        break;
                    }
                    if (DEBUG_PARSING) {
                        Logger.getLogger().debug("XmlServiceBean found unknown element in " + outerElementTag + " named " + elementTag + " skipping");
                    }
                    XmlStreamImpl.skip(reader, elementTag);
                    break;
                }
                case 4: {
                    ChildDataModel valueModel = targetModel.getValueData();
                    if (valueModel == null) break;
                    Iterator text = reader.getText();
                    Class<?> childType = valueModel.getChildTypeAsClass();
                    String propNamespace = targetModel.getValuePropertyNamespace();
                    String propName = targetModel.getValueProperty();
                    Object convertedValue = Utilities.getDefaultValue(text, childType, namespaceMap);
                    target._setProperty(propNamespace, propName, convertedValue);
                    break;
                }
                case 2: {
                    QName childTag;
                    for (Map.Entry entry : listChildren.entrySet()) {
                        String namespace = QNameUtilities.getNamespace((QName)entry.getKey(), defaultNamespace);
                        String key = ((QName)entry.getKey()).getLocalPart();
                        target._setProperty(namespace, key, entry.getValue());
                    }
                    for (Map.Entry entry : arrayChildren.entrySet()) {
                        childTag = (QName)entry.getKey();
                        String childTagNamespace = QNameUtilities.getNamespace(childTag, defaultNamespace);
                        String childTagKey = childTag.getLocalPart();
                        ParentedModel pn = targetModel.getChild(childTagNamespace, childTagKey);
                        Class<?> childType = pn.getChildModel().getOriginalInterfaceAsClass();
                        List individuals = (List)entry.getValue();
                        Object actualArray = Array.newInstance(childType, individuals.size());
                        int index = 0;
                        for (BaseHK2JAXBBean individual : individuals) {
                            Array.set(actualArray, index++, individual);
                        }
                        target._setProperty(childTag, actualArray);
                    }
                    for (Map.Entry entry : listNonChild.entrySet()) {
                        childTag = (QName)entry.getKey();
                        List value = (List)entry.getValue();
                        target._setProperty(childTag, (Object)value);
                    }
                    for (Map.Entry entry : arrayNonChild.entrySet()) {
                        childTag = (QName)entry.getKey();
                        ArrayInformation ai = (ArrayInformation)entry.getValue();
                        Object actualArray = Array.newInstance(ai.getAType(), ai.getValues().size());
                        int lcv = 0;
                        for (Object value : ai.getValues()) {
                            Array.set(actualArray, lcv++, value);
                        }
                        target._setProperty(childTag, actualArray);
                    }
                    listener.afterUnmarshal((Object)target, (Object)parent);
                    QName keyProp = target._getKeyPropertyName();
                    if (keyProp != null) {
                        String keyVal = (String)target._getProperty(keyProp);
                        String myType = target._getModel().getOriginalInterface();
                        if (keyVal != null && myType != null) {
                            referenceMap.put(new ReferenceKey(myType, keyVal), target);
                        }
                    }
                    if (DEBUG_PARSING) {
                        Logger.getLogger().debug("XmlServiceDebug ending parse of element " + outerElementTag);
                    }
                    return;
                }
                case 5: {
                    break;
                }
            }
        }
    }

    private static String advanceNonChildElement(XMLStreamReader reader, String outerTag) throws Exception {
        String retVal = null;
        while (reader.hasNext()) {
            int nextEvent = reader.next();
            if (DEBUG_PARSING) {
                Logger.getLogger().debug("XmlServiceDebug got xml event (C) " + XmlStreamImpl.eventToString(nextEvent));
            }
            switch (nextEvent) {
                case 4: {
                    String text = reader.getText();
                    retVal = text.trim();
                    if (!DEBUG_PARSING) break;
                    Logger.getLogger().debug("XmlServiceDebug characters of tag " + outerTag + " is " + retVal);
                    break;
                }
                case 2: {
                    if (DEBUG_PARSING) {
                        Logger.getLogger().debug("XmlServiceDebug ending parse of non-child element " + outerTag);
                    }
                    return retVal;
                }
            }
        }
        return retVal;
    }

    private static <T> void skipWrapperElement(BaseHK2JAXBBean target, BaseHK2JAXBBean parent, XMLStreamReader reader, ClassReflectionHelper classReflectionHelper, Unmarshaller.Listener listener, Map<ReferenceKey, BaseHK2JAXBBean> referenceMap, List<UnresolvedReference> unresolved, String outerElementTagNamespace, String outerElementTag, Map<String, String> namespaceMap, String defaultNamespace, String xmlWrapper, Map<QName, List<BaseHK2JAXBBean>> listChildren, Map<QName, List<BaseHK2JAXBBean>> arrayChildren) throws Exception {
        ModelImpl targetModel = target._getModel();
        Map<QName, ParentedModel> childProperties = targetModel.getChildrenByName();
        block4: while (reader.hasNext()) {
            int event = reader.next();
            if (DEBUG_PARSING) {
                String name = null;
                if (reader.hasName()) {
                    name = reader.getName().getLocalPart();
                }
                Logger.getLogger().debug("XmlServiceDebug got xml event (E) " + XmlStreamImpl.eventToString(event) + " with name " + name);
            }
            switch (event) {
                case 1: {
                    List<BaseHK2JAXBBean> cList;
                    String elementTag;
                    HashMap<String, String> effectiveNamespaceMap = new HashMap<String, String>(namespaceMap);
                    int namespaceCount = reader.getNamespaceCount();
                    for (int nLcv = 0; nLcv < namespaceCount; ++nLcv) {
                        String namespacePrefix = reader.getNamespacePrefix(nLcv);
                        String namespaceURI = reader.getNamespaceURI(nLcv);
                        if (namespacePrefix == null) {
                            defaultNamespace = namespaceURI;
                            continue;
                        }
                        effectiveNamespaceMap.put(namespacePrefix, namespaceURI);
                    }
                    String elementTagNamespace = QNameUtilities.getNamespace(reader.getName(), defaultNamespace);
                    QName elementTagQName = QNameUtilities.createQName(elementTagNamespace, elementTag = reader.getName().getLocalPart(), defaultNamespace);
                    ParentedModel informedChild = childProperties.get(elementTagQName);
                    if (informedChild == null || !GeneralUtilities.safeEquals((Object)xmlWrapper, (Object)informedChild.getXmlWrapperTag())) break;
                    ModelImpl grandChild = informedChild.getChildModel();
                    BaseHK2JAXBBean hk2Root = Utilities.createBean(grandChild.getProxyAsClass());
                    hk2Root._setClassReflectionHelper(classReflectionHelper);
                    if (DEBUG_PARSING) {
                        Logger.getLogger().debug("XmlServiceBean created child bean of " + outerElementTagNamespace + "," + outerElementTag + " with model " + hk2Root._getModel());
                    }
                    XmlStreamImpl.handleElement(hk2Root, target, reader, classReflectionHelper, listener, referenceMap, unresolved, elementTagNamespace, elementTag, effectiveNamespaceMap, defaultNamespace);
                    if (informedChild.getChildType().equals((Object)ChildType.DIRECT)) {
                        target._setProperty(elementTagNamespace, elementTag, hk2Root);
                        break;
                    }
                    if (informedChild.getChildType().equals((Object)ChildType.LIST)) {
                        cList = listChildren.get(elementTagQName);
                        if (cList == null) {
                            cList = new ArrayList<BaseHK2JAXBBean>();
                            listChildren.put(elementTagQName, cList);
                        }
                        cList.add(hk2Root);
                        break;
                    }
                    if (!informedChild.getChildType().equals((Object)ChildType.ARRAY)) continue block4;
                    cList = arrayChildren.get(elementTagQName);
                    if (cList == null) {
                        cList = new LinkedList<BaseHK2JAXBBean>();
                        arrayChildren.put(elementTagQName, cList);
                    }
                    cList.add(hk2Root);
                    break;
                }
                case 2: {
                    reader.getName().getLocalPart();
                    return;
                }
            }
        }
    }

    private static void skip(XMLStreamReader reader, String skipOverTag) throws Exception {
        while (reader.hasNext()) {
            String elementTag;
            int event = reader.next();
            if (DEBUG_PARSING) {
                String name = null;
                if (reader.hasName()) {
                    name = reader.getName().getLocalPart();
                }
                Logger.getLogger().debug("XmlServiceDebug got xml event (D) " + XmlStreamImpl.eventToString(event) + " with name " + name);
            }
            if (2 != event || !skipOverTag.equals(elementTag = reader.getName().getLocalPart())) continue;
            return;
        }
    }

    private static String eventToString(int event) {
        switch (event) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 6: {
                return "SPACE";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA";
            }
            case 13: {
                return "NAMESPACE";
            }
            case 14: {
                return "NOTATION_DECLARATION";
            }
            case 15: {
                return "ENTITY_DECLARATION";
            }
        }
        return "UNKNOWN EVENT: " + event;
    }

    public static <T> void marshall(OutputStream outputStream, XmlRootHandle<T> root) throws IOException {
        try {
            XmlStreamImpl.marshallXmlStream(outputStream, root);
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void marshallXmlStream(OutputStream outputStream, XmlRootHandle<T> root) throws XMLStreamException {
        XMLStreamWriter rawWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream);
        IndentingXMLStreamWriter indenter = new IndentingXMLStreamWriter(rawWriter);
        try {
            indenter.writeStartDocument();
            XmlHk2ConfigurationBean bean = (XmlHk2ConfigurationBean)root.getRoot();
            if (bean != null) {
                XmlStreamImpl.marshallElement((XMLStreamWriter)indenter, bean, null);
            }
            indenter.writeEndDocument();
        }
        finally {
            rawWriter.close();
        }
    }

    private static void marshallElement(XMLStreamWriter indenter, XmlHk2ConfigurationBean bean, ParentedModel parented) throws XMLStreamException {
        String xmlTag;
        ModelImpl model = bean._getModel();
        Map<String, Object> beanLikeMap = bean._getBeanLikeMap();
        if (parented == null) {
            QName rootName = model.getRootName();
            xmlTag = rootName.getLocalPart();
        } else {
            xmlTag = parented.getChildXmlTag();
        }
        indenter.writeStartElement(xmlTag);
        Map<QName, ChildDataModel> attributeModels = model.getAllAttributeChildren();
        for (Map.Entry<QName, ChildDataModel> entry : attributeModels.entrySet()) {
            String valueAsString;
            QName attributeQName = entry.getKey();
            ChildDataModel childDataModel = entry.getValue();
            String attributeTagKey = attributeQName.getLocalPart();
            Object value = beanLikeMap.get(attributeTagKey);
            if (value == null) continue;
            if (!childDataModel.isReference()) {
                valueAsString = value.toString();
            } else {
                XmlHk2ConfigurationBean reference = (XmlHk2ConfigurationBean)value;
                valueAsString = reference._getKeyValue();
            }
            if (GeneralUtilities.safeEquals((Object)valueAsString, (Object)childDataModel.getDefaultAsString())) continue;
            indenter.writeAttribute(attributeTagKey, valueAsString);
        }
        Map<QName, ChildDescriptor> elementDescriptors = model.getAllElementChildren();
        for (Map.Entry<QName, ChildDescriptor> entry : elementDescriptors.entrySet()) {
            QName elementQName = entry.getKey();
            ChildDescriptor descriptor = entry.getValue();
            String elementTagKey = elementQName.getLocalPart();
            Object value = beanLikeMap.get(elementTagKey);
            if (value == null) continue;
            ParentedModel parentedChild = descriptor.getParentedModel();
            if (parentedChild != null) {
                if (AliasType.HAS_ALIASES.equals((Object)parentedChild.getAliasType())) continue;
                if (ChildType.LIST.equals((Object)parentedChild.getChildType())) {
                    List asList = (List)value;
                    if (asList.isEmpty()) continue;
                    for (XmlHk2ConfigurationBean child : asList) {
                        XmlStreamImpl.marshallElement(indenter, child, parentedChild);
                    }
                    continue;
                }
                if (ChildType.ARRAY.equals((Object)parentedChild.getChildType())) {
                    int length = Array.getLength(value);
                    if (length <= 0) continue;
                    for (int lcv = 0; lcv < length; ++lcv) {
                        XmlHk2ConfigurationBean child = (XmlHk2ConfigurationBean)Array.get(value, lcv);
                        XmlStreamImpl.marshallElement(indenter, child, parentedChild);
                    }
                    continue;
                }
                XmlStreamImpl.marshallElement(indenter, (XmlHk2ConfigurationBean)value, parentedChild);
                continue;
            }
            ChildDataModel childDataModel = descriptor.getChildDataModel();
            if (!childDataModel.isReference()) {
                if (!value.getClass().isArray()) {
                    String valueAsString = value.toString();
                    indenter.writeStartElement(elementTagKey);
                    indenter.writeCharacters(valueAsString);
                    indenter.writeEndElement();
                    continue;
                }
                int length = Array.getLength(value);
                for (int lcv = 0; lcv < length; ++lcv) {
                    Object indexedValue = Array.get(value, lcv);
                    String valueAsString = indexedValue.toString();
                    indenter.writeStartElement(elementTagKey);
                    indenter.writeCharacters(valueAsString);
                    indenter.writeEndElement();
                }
                continue;
            }
            XmlHk2ConfigurationBean reference = (XmlHk2ConfigurationBean)value;
            String keyValue = reference._getKeyValue();
            indenter.writeStartElement(elementTagKey);
            indenter.writeCharacters(keyValue);
            indenter.writeEndElement();
        }
        indenter.writeEndElement();
    }

    private static class ArrayInformation {
        private final Class<?> aType;
        private final List<Object> values = new LinkedList<Object>();

        private ArrayInformation(Class<?> aType) {
            this.aType = aType;
        }

        private void add(Object addMe) {
            this.values.add(addMe);
        }

        private Class<?> getAType() {
            return this.aType;
        }

        private List<Object> getValues() {
            return this.values;
        }
    }
}

