/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.xml.internal.ChildDataModel;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.Model;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.XmlServiceImpl;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;

public class XmlStreamImpl {
    public static <T> T parseRoot(XmlServiceImpl xmlService, Model rootModel, XMLStreamReader reader, Unmarshaller.Listener listener) throws Exception {
        Class<?> rootProxyClass = rootModel.getProxyAsClass();
        ClassReflectionHelper classReflectionHelper = xmlService.getClassReflectionHelper();
        BaseHK2JAXBBean hk2Root = Utilities.createBean(rootProxyClass);
        hk2Root._setClassReflectionHelper(classReflectionHelper);
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    XmlStreamImpl.handleElement(hk2Root, null, reader, classReflectionHelper, listener);
                    break;
                }
                case 8: {
                    return (T)hk2Root;
                }
            }
        }
        throw new IllegalStateException("Unexpected end of XMLReaderStream");
    }

    private static <T> void handleElement(BaseHK2JAXBBean target, BaseHK2JAXBBean parent, XMLStreamReader reader, ClassReflectionHelper classReflectionHelper, Unmarshaller.Listener listener) throws Exception {
        Object convertedValue;
        Class<?> childType;
        listener.beforeUnmarshal((Object)target, (Object)parent);
        HashMap<String, ArrayList<BaseHK2JAXBBean>> listChildren = new HashMap<String, ArrayList<BaseHK2JAXBBean>>();
        HashMap<String, ArrayList<BaseHK2JAXBBean>> arrayChildren = new HashMap<String, ArrayList<BaseHK2JAXBBean>>();
        Model targetModel = target._getModel();
        Map<String, ChildDataModel> nonChildProperties = targetModel.getNonChildProperties();
        Map<String, ParentedModel> childProperties = targetModel.getChildrenByName();
        int numAttributes = reader.getAttributeCount();
        for (int lcv = 0; lcv < numAttributes; ++lcv) {
            String attributeName = reader.getAttributeLocalName(lcv);
            String attributeValue = reader.getAttributeValue(lcv);
            ChildDataModel childDataModel = nonChildProperties.get(attributeName);
            if (childDataModel == null) continue;
            childType = targetModel.getNonChildType(attributeName);
            convertedValue = Utilities.getDefaultValue(attributeValue, childType);
            target._setProperty(attributeName, convertedValue);
        }
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    List<BaseHK2JAXBBean> cList;
                    String elementTag = reader.getName().getLocalPart();
                    ChildDataModel cdm = nonChildProperties.get(elementTag);
                    if (cdm != null) {
                        String elementValue = XmlStreamImpl.advanceNonChildElement(reader);
                        childType = cdm.getChildTypeAsClass();
                        convertedValue = Utilities.getDefaultValue(elementValue, childType);
                        target._setProperty(elementTag, convertedValue);
                        break;
                    }
                    ParentedModel informedChild = childProperties.get(elementTag);
                    if (informedChild == null) break;
                    Model grandChild = informedChild.getChildModel();
                    BaseHK2JAXBBean hk2Root = Utilities.createBean(grandChild.getProxyAsClass());
                    hk2Root._setClassReflectionHelper(classReflectionHelper);
                    XmlStreamImpl.handleElement(hk2Root, target, reader, classReflectionHelper, listener);
                    if (informedChild.getChildType().equals((Object)ChildType.DIRECT)) {
                        target._setProperty(elementTag, hk2Root);
                        break;
                    }
                    if (informedChild.getChildType().equals((Object)ChildType.LIST)) {
                        cList = (ArrayList<BaseHK2JAXBBean>)listChildren.get(elementTag);
                        if (cList == null) {
                            cList = new ArrayList<BaseHK2JAXBBean>();
                            listChildren.put(elementTag, (ArrayList<BaseHK2JAXBBean>)cList);
                        }
                        cList.add(hk2Root);
                        break;
                    }
                    if (!informedChild.getChildType().equals((Object)ChildType.ARRAY)) break;
                    cList = (List)arrayChildren.get(elementTag);
                    if (cList == null) {
                        cList = new LinkedList();
                        arrayChildren.put(elementTag, (ArrayList<BaseHK2JAXBBean>)cList);
                    }
                    cList.add(hk2Root);
                    break;
                }
                case 4: {
                    break;
                }
                case 2: {
                    for (Map.Entry entry : listChildren.entrySet()) {
                        target._setProperty((String)entry.getKey(), entry.getValue());
                    }
                    for (Map.Entry entry : arrayChildren.entrySet()) {
                        String childTag = (String)entry.getKey();
                        ParentedModel pn = targetModel.getChild(childTag);
                        Class<?> childType2 = pn.getChildModel().getOriginalInterfaceAsClass();
                        List individuals = (List)entry.getValue();
                        Object actualArray = Array.newInstance(childType2, individuals.size());
                        int index = 0;
                        for (BaseHK2JAXBBean individual : individuals) {
                            Array.set(actualArray, index++, individual);
                        }
                        target._setProperty(childTag, actualArray);
                    }
                    listener.afterUnmarshal((Object)target, (Object)parent);
                    return;
                }
                case 5: {
                    break;
                }
            }
        }
    }

    private static String advanceNonChildElement(XMLStreamReader reader) throws Exception {
        String retVal = null;
        while (reader.hasNext()) {
            int nextEvent = reader.next();
            switch (nextEvent) {
                case 4: {
                    String text = reader.getText();
                    retVal = text.trim();
                    break;
                }
                case 2: {
                    return retVal;
                }
            }
        }
        return retVal;
    }
}

