/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.beans.Introspector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.glassfish.hk2.api.AnnotationLiteral;
import org.glassfish.hk2.api.Customize;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.utilities.reflection.Logger;
import org.glassfish.hk2.xml.api.annotations.Hk2XmlPreGenerate;
import org.glassfish.hk2.xml.api.annotations.PluralOf;
import org.glassfish.hk2.xml.api.annotations.XmlIdentifier;
import org.glassfish.hk2.xml.internal.ChildDataModel;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.MethodInformation;
import org.glassfish.hk2.xml.internal.MethodType;
import org.glassfish.hk2.xml.internal.Model;
import org.glassfish.hk2.xml.internal.NameInformation;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.XmlElementData;
import org.glassfish.hk2.xml.internal.alt.AltAnnotation;
import org.glassfish.hk2.xml.internal.alt.AltClass;
import org.glassfish.hk2.xml.internal.alt.AltEnum;
import org.glassfish.hk2.xml.internal.alt.AltMethod;
import org.glassfish.hk2.xml.internal.alt.clazz.AnnotationAltAnnotationImpl;
import org.glassfish.hk2.xml.internal.alt.clazz.ClassAltClassImpl;
import org.glassfish.hk2.xml.jaxb.internal.XmlElementImpl;
import org.glassfish.hk2.xml.jaxb.internal.XmlRootElementImpl;
import org.jvnet.hk2.annotations.Contract;

public class Generator {
    private static final boolean DEBUG_METHODS = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.parseBoolean(System.getProperty("org.jvnet.hk2.properties.xmlservice.jaxb.methods", "false"));
        }
    });
    private static final String JAXB_DEFAULT_STRING = "##default";
    public static final String JAXB_DEFAULT_DEFAULT = "\u0000";
    private static final String NO_CHILD_PACKAGE = "java.";
    public static final String STATIC_GET_MODEL_METHOD_NAME = "__getModel";
    private static final String QUOTE = "\"";
    private static final Set<String> NO_COPY_ANNOTATIONS = new HashSet<String>(Arrays.asList(Contract.class.getName(), XmlTransient.class.getName(), Hk2XmlPreGenerate.class.getName(), "org.jvnet.hk2.config.Configured"));

    public static CtClass generate(AltClass convertMe, CtClass superClazz, ClassPool defaultClassPool) throws Throwable {
        CtClass originalCtClass;
        String modelOriginalInterface = convertMe.getName();
        String modelTranslatedClass = Utilities.getProxyNameFromInterfaceName(modelOriginalInterface);
        if (DEBUG_METHODS) {
            Logger.getLogger().debug("Converting " + convertMe.getName() + " to " + modelTranslatedClass);
        }
        CtClass targetCtClass = defaultClassPool.makeClass(modelTranslatedClass);
        ClassFile targetClassFile = targetCtClass.getClassFile();
        targetClassFile.setVersionToJava5();
        ConstPool targetConstPool = targetClassFile.getConstPool();
        Model compiledModel = new Model(modelOriginalInterface, modelTranslatedClass);
        AnnotationsAttribute ctAnnotations = null;
        for (AltAnnotation convertMeAnnotation : convertMe.getAnnotations()) {
            if (NO_COPY_ANNOTATIONS.contains(convertMeAnnotation.annotationType())) continue;
            if (ctAnnotations == null) {
                ctAnnotations = new AnnotationsAttribute(targetConstPool, "RuntimeVisibleAnnotations");
            }
            if (XmlRootElement.class.getName().equals(convertMeAnnotation.annotationType())) {
                String modelRootName = Generator.convertXmlRootElementName(convertMeAnnotation, convertMe);
                compiledModel.setRootName(modelRootName);
                XmlRootElementImpl replacement = new XmlRootElementImpl(convertMeAnnotation.getStringValue("namespace"), modelRootName);
                Generator.createAnnotationCopy(targetConstPool, (java.lang.annotation.Annotation)((Object)replacement), ctAnnotations);
                continue;
            }
            Generator.createAnnotationCopy(targetConstPool, convertMeAnnotation, ctAnnotations);
        }
        if (ctAnnotations != null) {
            targetClassFile.addAttribute(ctAnnotations);
        }
        if ((originalCtClass = defaultClassPool.getOrNull(convertMe.getName())) == null) {
            originalCtClass = defaultClassPool.makeInterface(convertMe.getName());
        }
        targetCtClass.setSuperclass(superClazz);
        targetCtClass.addInterface(originalCtClass);
        NameInformation xmlNameMap = Generator.getXmlNameMap(convertMe);
        HashSet<String> alreadyAddedNaked = new HashSet<String>();
        List<AltMethod> allMethods = convertMe.getMethods();
        if (DEBUG_METHODS) {
            Logger.getLogger().debug("Analyzing " + allMethods.size() + " methods of " + convertMe.getName());
        }
        HashSet<String> setters = new HashSet<String>();
        HashMap<String, MethodInformation> getters = new HashMap<String, MethodInformation>();
        for (AltMethod altMethod : allMethods) {
            CtMethod addMeCtMethod;
            List<AltClass> paramTypes;
            boolean isVoid;
            MethodInformation mi = Generator.getMethodInformation(altMethod, xmlNameMap);
            if (mi.isKey()) {
                compiledModel.setKeyProperty(mi.getRepresentedProperty());
            }
            if (!MethodType.CUSTOM.equals((Object)mi.getMethodType())) {
                Generator.createInterfaceForAltClassIfNeeded(mi.getGetterSetterType(), defaultClassPool);
            } else {
                AltMethod original = mi.getOriginalMethod();
                AltClass originalReturn = original.getReturnType();
                if (!ClassAltClassImpl.VOID.equals(originalReturn)) {
                    Generator.createInterfaceForAltClassIfNeeded(originalReturn, defaultClassPool);
                }
                for (AltClass parameter : original.getParameterTypes()) {
                    Generator.createInterfaceForAltClassIfNeeded(parameter, defaultClassPool);
                }
            }
            if (DEBUG_METHODS) {
                Logger.getLogger().debug("Analyzing method " + mi + " of " + convertMe.getSimpleName());
            }
            String name = altMethod.getName();
            StringBuffer sb = new StringBuffer("public ");
            AltClass originalRetType = altMethod.getReturnType();
            if (originalRetType == null || Void.TYPE.getName().equals(originalRetType.getName())) {
                sb.append("void ");
                isVoid = true;
            } else {
                sb.append(Generator.getCompilableClass(originalRetType) + " ");
                isVoid = false;
            }
            sb.append(name + "(");
            AltClass childType = null;
            boolean getterOrSetter = false;
            if (MethodType.SETTER.equals((Object)mi.getMethodType())) {
                getterOrSetter = true;
                setters.add(mi.getRepresentedProperty());
                childType = mi.getBaseChildType();
                sb.append(Generator.getCompilableClass(mi.getGetterSetterType()) + " arg0) { super._setProperty(\"" + mi.getRepresentedProperty() + "\", arg0); }");
            } else if (MethodType.GETTER.equals((Object)mi.getMethodType())) {
                getterOrSetter = true;
                getters.put(mi.getRepresentedProperty(), mi);
                childType = mi.getBaseChildType();
                String cast = "";
                String superMethodName = "_getProperty";
                if (Integer.TYPE.getName().equals(mi.getGetterSetterType().getName())) {
                    superMethodName = superMethodName + "I";
                } else if (Long.TYPE.getName().equals(mi.getGetterSetterType().getName())) {
                    superMethodName = superMethodName + "J";
                } else if (Boolean.TYPE.getName().equals(mi.getGetterSetterType().getName())) {
                    superMethodName = superMethodName + "Z";
                } else if (Byte.TYPE.getName().equals(mi.getGetterSetterType().getName())) {
                    superMethodName = superMethodName + "B";
                } else if (Character.TYPE.getName().equals(mi.getGetterSetterType().getName())) {
                    superMethodName = superMethodName + "C";
                } else if (Short.TYPE.getName().equals(mi.getGetterSetterType().getName())) {
                    superMethodName = superMethodName + "S";
                } else if (Float.TYPE.getName().equals(mi.getGetterSetterType().getName())) {
                    superMethodName = superMethodName + "F";
                } else if (Double.TYPE.getName().equals(mi.getGetterSetterType().getName())) {
                    superMethodName = superMethodName + "D";
                } else {
                    cast = "(" + Generator.getCompilableClass(mi.getGetterSetterType()) + ") ";
                }
                sb.append(") { return " + cast + "super." + superMethodName + "(\"" + mi.getRepresentedProperty() + "\"); }");
            } else if (MethodType.LOOKUP.equals((Object)mi.getMethodType())) {
                sb.append("java.lang.String arg0) { return (" + Generator.getCompilableClass(originalRetType) + ") super._lookupChild(\"" + mi.getRepresentedProperty() + "\", arg0); }");
            } else if (MethodType.ADD.equals((Object)mi.getMethodType())) {
                List<AltClass> paramTypes2;
                String returnClause = "";
                if (!isVoid) {
                    Generator.createInterfaceForAltClassIfNeeded(originalRetType, defaultClassPool);
                    returnClause = "return (" + Generator.getCompilableClass(originalRetType) + ") ";
                }
                if ((paramTypes2 = altMethod.getParameterTypes()).size() == 0) {
                    sb.append(") { " + returnClause + "super._doAdd(\"" + mi.getRepresentedProperty() + "\", null, null, -1); }");
                } else if (paramTypes2.size() == 1) {
                    Generator.createInterfaceForAltClassIfNeeded(paramTypes2.get(0), defaultClassPool);
                    sb.append(paramTypes2.get(0).getName() + " arg0) { " + returnClause + "super._doAdd(\"" + mi.getRepresentedProperty() + "\",");
                    if (paramTypes2.get(0).isInterface()) {
                        sb.append("arg0, null, -1); }");
                    } else if (String.class.getName().equals(paramTypes2.get(0).getName())) {
                        sb.append("null, arg0, -1); }");
                    } else {
                        sb.append("null, null, arg0); }");
                    }
                } else {
                    sb.append(paramTypes2.get(0).getName() + " arg0, int arg1) { " + returnClause + "super._doAdd(\"" + mi.getRepresentedProperty() + "\",");
                    if (paramTypes2.get(0).isInterface()) {
                        Generator.createInterfaceForAltClassIfNeeded(paramTypes2.get(0), defaultClassPool);
                        sb.append("arg0, null, arg1); }");
                    } else {
                        sb.append("null, arg0, arg1); }");
                    }
                }
            } else if (MethodType.REMOVE.equals((Object)mi.getMethodType())) {
                paramTypes = altMethod.getParameterTypes();
                String cast = "";
                String function = "super._doRemoveZ(\"";
                if (!Boolean.TYPE.getName().equals(originalRetType.getName())) {
                    cast = "(" + Generator.getCompilableClass(originalRetType) + ") ";
                    function = "super._doRemove(\"";
                }
                if (paramTypes.size() == 0) {
                    sb.append(") { return " + cast + function + mi.getRepresentedProperty() + "\", null, -1); }");
                } else if (String.class.getName().equals(paramTypes.get(0).getName())) {
                    sb.append("java.lang.String arg0) { return " + cast + function + mi.getRepresentedProperty() + "\", arg0, -1); }");
                } else {
                    sb.append("int arg0) { return " + cast + function + mi.getRepresentedProperty() + "\", null, arg0); }");
                }
            } else if (MethodType.CUSTOM.equals((Object)mi.getMethodType())) {
                paramTypes = altMethod.getParameterTypes();
                StringBuffer classSets = new StringBuffer();
                StringBuffer valSets = new StringBuffer();
                int lcv = 0;
                for (AltClass paramType : paramTypes) {
                    Generator.createInterfaceForAltClassIfNeeded(paramType, defaultClassPool);
                    if (lcv == 0) {
                        sb.append(Generator.getCompilableClass(paramType) + " arg" + lcv);
                    } else {
                        sb.append(", " + Generator.getCompilableClass(paramType) + " arg" + lcv);
                    }
                    classSets.append("mParams[" + lcv + "] = " + Generator.getCompilableClass(paramType) + ".class;\n");
                    valSets.append("mVars[" + lcv + "] = ");
                    if (Integer.TYPE.getName().equals(paramType.getName())) {
                        valSets.append("new java.lang.Integer(arg" + lcv + ");\n");
                    } else if (Long.TYPE.getName().equals(paramType.getName())) {
                        valSets.append("new java.lang.Long(arg" + lcv + ");\n");
                    } else if (Boolean.TYPE.getName().equals(paramType.getName())) {
                        valSets.append("new java.lang.Boolean(arg" + lcv + ");\n");
                    } else if (Byte.TYPE.getName().equals(paramType.getName())) {
                        valSets.append("new java.lang.Byte(arg" + lcv + ");\n");
                    } else if (Character.TYPE.getName().equals(paramType.getName())) {
                        valSets.append("new java.lang.Character(arg" + lcv + ");\n");
                    } else if (Short.TYPE.getName().equals(paramType.getName())) {
                        valSets.append("new java.lang.Short(arg" + lcv + ");\n");
                    } else if (Float.TYPE.getName().equals(paramType.getName())) {
                        valSets.append("new java.lang.Float(arg" + lcv + ");\n");
                    } else if (Double.TYPE.getName().equals(paramType.getName())) {
                        valSets.append("new java.lang.Double(arg" + lcv + ");\n");
                    } else {
                        valSets.append("arg" + lcv + ";\n");
                    }
                    ++lcv;
                }
                sb.append(") { Class[] mParams = new Class[" + paramTypes.size() + "];\n");
                sb.append("Object[] mVars = new Object[" + paramTypes.size() + "];\n");
                sb.append(classSets.toString());
                sb.append(valSets.toString());
                String cast = "";
                String superMethodName = "_invokeCustomizedMethod";
                if (Integer.TYPE.getName().equals(originalRetType.getName())) {
                    superMethodName = superMethodName + "I";
                } else if (Long.TYPE.getName().equals(originalRetType.getName())) {
                    superMethodName = superMethodName + "J";
                } else if (Boolean.TYPE.getName().equals(originalRetType.getName())) {
                    superMethodName = superMethodName + "Z";
                } else if (Byte.TYPE.getName().equals(originalRetType.getName())) {
                    superMethodName = superMethodName + "B";
                } else if (Character.TYPE.getName().equals(originalRetType.getName())) {
                    superMethodName = superMethodName + "C";
                } else if (Short.TYPE.getName().equals(originalRetType.getName())) {
                    superMethodName = superMethodName + "S";
                } else if (Float.TYPE.getName().equals(originalRetType.getName())) {
                    superMethodName = superMethodName + "F";
                } else if (Double.TYPE.getName().equals(originalRetType.getName())) {
                    superMethodName = superMethodName + "D";
                } else if (!isVoid) {
                    cast = "(" + Generator.getCompilableClass(originalRetType) + ") ";
                }
                if (!isVoid) {
                    sb.append("return " + cast);
                }
                sb.append("super." + superMethodName + "(\"" + name + "\", mParams, mVars);}");
            }
            if (DEBUG_METHODS) {
                Logger.getLogger().debug("Adding method for " + convertMe.getSimpleName() + " with implementation " + sb);
            }
            try {
                addMeCtMethod = CtNewMethod.make((String)sb.toString(), (CtClass)targetCtClass);
            }
            catch (CannotCompileException cce) {
                MultiException me = new MultiException((Throwable)cce);
                me.addError((Throwable)((Object)new AssertionError((Object)("Cannot compile method with source " + sb.toString()))));
                throw me;
            }
            if (altMethod.isVarArgs()) {
                addMeCtMethod.setModifiers(addMeCtMethod.getModifiers() | 0x80);
            }
            MethodInfo methodInfo = addMeCtMethod.getMethodInfo();
            ConstPool methodConstPool = methodInfo.getConstPool();
            ctAnnotations = null;
            for (AltAnnotation convertMeAnnotation : altMethod.getAnnotations()) {
                if (ctAnnotations == null) {
                    ctAnnotations = new AnnotationsAttribute(methodConstPool, "RuntimeVisibleAnnotations");
                }
                if (childType != null && XmlElement.class.getName().equals(convertMeAnnotation.annotationType())) {
                    String translatedClassName = Utilities.getProxyNameFromInterfaceName(childType.getName());
                    XmlElementImpl anno = new XmlElementImpl(convertMeAnnotation.getStringValue("name"), convertMeAnnotation.getBooleanValue("nillable"), convertMeAnnotation.getBooleanValue("required"), convertMeAnnotation.getStringValue("namespace"), convertMeAnnotation.getStringValue("defaultValue"), translatedClassName);
                    Generator.createAnnotationCopy(methodConstPool, (java.lang.annotation.Annotation)((Object)anno), ctAnnotations);
                    continue;
                }
                Generator.createAnnotationCopy(methodConstPool, convertMeAnnotation, ctAnnotations);
            }
            if (getterOrSetter) {
                if (childType != null) {
                    compiledModel.addChild(childType.getName(), mi.getRepresentedProperty(), Generator.getChildType(mi.isList(), mi.isArray()), mi.getDefaultValue());
                } else {
                    compiledModel.addNonChild(mi.getRepresentedProperty(), mi.getDefaultValue(), mi.getGetterSetterType().getName());
                }
            }
            if (getterOrSetter && childType != null && xmlNameMap.hasNoXmlElement(mi.getRepresentedProperty()) && !alreadyAddedNaked.contains(mi.getRepresentedProperty())) {
                alreadyAddedNaked.add(mi.getRepresentedProperty());
                if (ctAnnotations == null) {
                    ctAnnotations = new AnnotationsAttribute(methodConstPool, "RuntimeVisibleAnnotations");
                }
                String translatedClassName = Utilities.getProxyNameFromInterfaceName(childType.getName());
                XmlElementImpl convertMeAnnotation = new XmlElementImpl(JAXB_DEFAULT_STRING, false, false, JAXB_DEFAULT_STRING, JAXB_DEFAULT_DEFAULT, translatedClassName);
                Generator.createAnnotationCopy(methodConstPool, (java.lang.annotation.Annotation)((Object)convertMeAnnotation), ctAnnotations);
            }
            if (ctAnnotations != null) {
                methodInfo.addAttribute((AttributeInfo)ctAnnotations);
            }
            targetCtClass.addMethod(addMeCtMethod);
        }
        for (Map.Entry entry : getters.entrySet()) {
            String getterProperty = (String)entry.getKey();
            MethodInformation mi = (MethodInformation)entry.getValue();
            if (setters.contains(getterProperty)) continue;
            String getterName = mi.getOriginalMethod().getName();
            String setterName = Utilities.convertToSetter(getterName);
            StringBuffer sb = new StringBuffer("private void " + setterName + "(");
            sb.append(Generator.getCompilableClass(mi.getGetterSetterType()) + " arg0) { super._setProperty(\"" + mi.getRepresentedProperty() + "\", arg0); }");
            CtMethod addMeCtMethod = CtNewMethod.make((String)sb.toString(), (CtClass)targetCtClass);
            targetCtClass.addMethod(addMeCtMethod);
        }
        Generator.generateStaticModelFieldAndAbstractMethodImpl(targetCtClass, compiledModel, defaultClassPool);
        return targetCtClass;
    }

    static ChildType getChildType(boolean isList, boolean isArray) {
        if (isList) {
            return ChildType.LIST;
        }
        if (isArray) {
            return ChildType.ARRAY;
        }
        return ChildType.DIRECT;
    }

    private static void generateStaticModelFieldAndAbstractMethodImpl(CtClass targetCtClass, Model model, ClassPool defaultClassPool) throws CannotCompileException, NotFoundException {
        StringBuffer sb = new StringBuffer();
        sb.append("private static final org.glassfish.hk2.xml.internal.Model INIT_MODEL() {\n");
        sb.append("org.glassfish.hk2.xml.internal.Model retVal = new org.glassfish.hk2.xml.internal.Model(\"");
        sb.append(model.getOriginalInterface() + "\",\"" + model.getTranslatedClass() + "\");\n");
        if (model.getRootName() != null) {
            sb.append("retVal.setRootName(\"" + model.getRootName() + "\");\n");
        }
        if (model.getKeyProperty() != null) {
            sb.append("retVal.setKeyProperty(\"" + model.getKeyProperty() + "\");\n");
        }
        Map<String, ParentedModel> childrenByName = model.getChildrenByName();
        for (Map.Entry<String, ParentedModel> entry : childrenByName.entrySet()) {
            sb.append("retVal.addChild(" + Generator.asParameter(entry.getValue().getChildInterface()) + "," + Generator.asParameter(entry.getValue().getChildXmlTag()) + "," + Generator.asParameter(entry.getValue().getChildType()) + "," + Generator.asParameter(entry.getValue().getGivenDefault()) + ");\n");
        }
        Map<String, ChildDataModel> nonChildProperties = model.getNonChildProperties();
        for (Map.Entry<String, ChildDataModel> entry : nonChildProperties.entrySet()) {
            sb.append("retVal.addNonChild(" + Generator.asParameter(entry.getKey()) + "," + Generator.asParameter(entry.getValue().getDefaultAsString()) + "," + Generator.asParameter(entry.getValue().getChildType()) + ");\n");
        }
        sb.append("return retVal; }");
        if (DEBUG_METHODS) {
            Logger.getLogger().debug("Adding static model generator for " + targetCtClass.getSimpleName() + " with implementation " + sb);
        }
        targetCtClass.addMethod(CtNewMethod.make((String)sb.toString(), (CtClass)targetCtClass));
        CtClass modelCt = defaultClassPool.get(Model.class.getName());
        CtField sField = new CtField(modelCt, "MODEL", targetCtClass);
        sField.setModifiers(26);
        targetCtClass.addField(sField, CtField.Initializer.byCall((CtClass)targetCtClass, (String)"INIT_MODEL"));
        CtMethod aMethod = CtNewMethod.make((String)"public org.glassfish.hk2.xml.internal.Model _getModel() { return MODEL; }", (CtClass)targetCtClass);
        targetCtClass.addMethod(aMethod);
        CtMethod sMethod = CtNewMethod.make((String)"public static final org.glassfish.hk2.xml.internal.Model __getModel() { return MODEL; }", (CtClass)targetCtClass);
        targetCtClass.addMethod(sMethod);
    }

    private static String asParameter(String me) {
        if (me == null) {
            return "null";
        }
        if (JAXB_DEFAULT_DEFAULT.equals(me)) {
            return "null";
        }
        return QUOTE + me + QUOTE;
    }

    private static String asParameter(ChildType ct) {
        switch (ct) {
            case DIRECT: {
                return ChildType.class.getName() + ".DIRECT";
            }
            case LIST: {
                return ChildType.class.getName() + ".LIST";
            }
            case ARRAY: {
                return ChildType.class.getName() + ".ARRAY";
            }
        }
        throw new AssertionError((Object)("unknown ChildType " + (Object)((Object)ct)));
    }

    private static void createAnnotationCopy(ConstPool parent, java.lang.annotation.Annotation javaAnnotation, AnnotationsAttribute retVal) throws Throwable {
        Generator.createAnnotationCopy(parent, new AnnotationAltAnnotationImpl(javaAnnotation, null), retVal);
    }

    private static void createAnnotationCopy(ConstPool parent, AltAnnotation javaAnnotation, AnnotationsAttribute retVal) throws Throwable {
        Annotation annotation = new Annotation(javaAnnotation.annotationType(), parent);
        Map<String, Object> annotationValues = javaAnnotation.getAnnotationValues();
        for (Map.Entry<String, Object> entry : annotationValues.entrySet()) {
            String valueName = entry.getKey();
            Object value = entry.getValue();
            Class<?> javaAnnotationType = value.getClass();
            if (String.class.equals(javaAnnotationType)) {
                annotation.addMemberValue(valueName, (MemberValue)new StringMemberValue((String)value, parent));
                continue;
            }
            if (Boolean.class.equals(javaAnnotationType)) {
                boolean bvalue = (Boolean)value;
                annotation.addMemberValue(valueName, (MemberValue)new BooleanMemberValue(bvalue, parent));
                continue;
            }
            if (AltClass.class.isAssignableFrom(javaAnnotationType)) {
                AltClass altJavaAnnotationType = (AltClass)value;
                String sValue = javaAnnotation.annotationType().equals(XmlElement.class.getName()) && javaAnnotation.getStringValue("getTypeByName") != null ? javaAnnotation.getStringValue("getTypeByName") : altJavaAnnotationType.getName();
                annotation.addMemberValue(valueName, (MemberValue)new ClassMemberValue(sValue, parent));
                continue;
            }
            if (Integer.class.equals(javaAnnotationType)) {
                int ivalue = (Integer)value;
                annotation.addMemberValue(valueName, (MemberValue)new IntegerMemberValue(parent, ivalue));
                continue;
            }
            if (Long.class.equals(javaAnnotationType)) {
                long lvalue = (Long)value;
                annotation.addMemberValue(valueName, (MemberValue)new LongMemberValue(lvalue, parent));
                continue;
            }
            if (Double.class.equals(javaAnnotationType)) {
                double dvalue = (Double)value;
                annotation.addMemberValue(valueName, (MemberValue)new DoubleMemberValue(dvalue, parent));
                continue;
            }
            if (Byte.class.equals(javaAnnotationType)) {
                byte bvalue = (Byte)value;
                annotation.addMemberValue(valueName, (MemberValue)new ByteMemberValue(bvalue, parent));
                continue;
            }
            if (Character.class.equals(javaAnnotationType)) {
                char cvalue = ((Character)value).charValue();
                annotation.addMemberValue(valueName, (MemberValue)new CharMemberValue(cvalue, parent));
                continue;
            }
            if (Short.class.equals(javaAnnotationType)) {
                short svalue = (Short)value;
                annotation.addMemberValue(valueName, (MemberValue)new ShortMemberValue(svalue, parent));
                continue;
            }
            if (Float.class.equals(javaAnnotationType)) {
                float fvalue = ((Float)value).floatValue();
                annotation.addMemberValue(valueName, (MemberValue)new FloatMemberValue(fvalue, parent));
                continue;
            }
            if (AltEnum.class.isAssignableFrom(javaAnnotationType)) {
                AltEnum evalue = (AltEnum)value;
                EnumMemberValue jaEnum = new EnumMemberValue(parent);
                jaEnum.setType(evalue.getDeclaringClass());
                jaEnum.setValue(evalue.getName());
                annotation.addMemberValue(valueName, (MemberValue)jaEnum);
                continue;
            }
            if (javaAnnotationType.isArray()) {
                int lcv;
                MemberValue[] arrayValue;
                Object[] iVals;
                Class<?> typeOfArray = javaAnnotationType.getComponentType();
                if (Integer.TYPE.equals(typeOfArray)) {
                    iVals = (int[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new IntegerMemberValue(parent, iVals[lcv]);
                    }
                } else if (String.class.equals(typeOfArray)) {
                    iVals = (String[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new StringMemberValue((String)iVals[lcv], parent);
                    }
                } else if (Long.TYPE.equals(typeOfArray)) {
                    iVals = (long[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new LongMemberValue((long)iVals[lcv], parent);
                    }
                } else if (Boolean.TYPE.equals(typeOfArray)) {
                    iVals = (boolean[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new BooleanMemberValue(iVals[lcv], parent);
                    }
                } else if (Float.TYPE.equals(typeOfArray)) {
                    iVals = (float[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new FloatMemberValue((float)iVals[lcv], parent);
                    }
                } else if (Double.TYPE.equals(typeOfArray)) {
                    iVals = (double[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new DoubleMemberValue((double)iVals[lcv], parent);
                    }
                } else if (Byte.TYPE.equals(typeOfArray)) {
                    iVals = (byte[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new ByteMemberValue(iVals[lcv], parent);
                    }
                } else if (Character.TYPE.equals(typeOfArray)) {
                    iVals = (char[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new CharMemberValue(iVals[lcv], parent);
                    }
                } else if (Short.TYPE.equals(typeOfArray)) {
                    iVals = (short[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new ShortMemberValue(iVals[lcv], parent);
                    }
                } else if (AltEnum.class.isAssignableFrom(typeOfArray)) {
                    iVals = (AltEnum[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        EnumMemberValue jaEnum = new EnumMemberValue(parent);
                        jaEnum.setType(iVals[lcv].getDeclaringClass());
                        jaEnum.setValue(iVals[lcv].getName());
                        arrayValue[lcv] = jaEnum;
                    }
                } else if (AltClass.class.isAssignableFrom(typeOfArray)) {
                    iVals = (AltClass[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        int arrayElementClass = iVals[lcv];
                        arrayValue[lcv] = new ClassMemberValue(arrayElementClass.getName(), parent);
                    }
                } else {
                    throw new AssertionError((Object)("Array type " + typeOfArray.getName() + " is not yet implemented for " + valueName));
                }
                ArrayMemberValue arrayMemberValue = new ArrayMemberValue(parent);
                arrayMemberValue.setValue(arrayValue);
                annotation.addMemberValue(valueName, (MemberValue)arrayMemberValue);
                continue;
            }
            throw new AssertionError((Object)("Annotation type " + javaAnnotationType.getName() + " is not yet implemented for " + valueName));
        }
        retVal.addAnnotation(annotation);
    }

    private static String getMethodName(MethodType methodType, String unDecapitalizedVariable, AltAnnotation instructions) {
        String retVal;
        switch (methodType) {
            case ADD: {
                retVal = instructions.getStringValue("add");
                break;
            }
            case REMOVE: {
                retVal = instructions.getStringValue("remove");
                break;
            }
            case LOOKUP: {
                retVal = instructions.getStringValue("lookup");
                break;
            }
            default: {
                throw new AssertionError((Object)"Only ADD, REMOVE and LOOKUP supported");
            }
        }
        if (!"*".equals(retVal)) {
            return retVal;
        }
        String pluralOf = instructions.getStringValue("value");
        if (!"*".equals(pluralOf)) {
            switch (methodType) {
                case ADD: {
                    return "add" + pluralOf;
                }
                case REMOVE: {
                    return "remove" + pluralOf;
                }
                case LOOKUP: {
                    return "lookup" + pluralOf;
                }
            }
            throw new AssertionError((Object)"Only add, remove and lookup supported");
        }
        if (unDecapitalizedVariable.endsWith("s")) {
            unDecapitalizedVariable = unDecapitalizedVariable.substring(0, unDecapitalizedVariable.length() - 1);
        }
        switch (methodType) {
            case ADD: {
                return "add" + unDecapitalizedVariable;
            }
            case REMOVE: {
                return "remove" + unDecapitalizedVariable;
            }
            case LOOKUP: {
                return "lookup" + unDecapitalizedVariable;
            }
        }
        throw new AssertionError((Object)"Only add, remove and lookup supported");
    }

    static NameInformation getXmlNameMap(AltClass convertMe) {
        HashMap<String, XmlElementData> xmlNameMap = new HashMap<String, XmlElementData>();
        HashSet<String> unmappedNames = new HashSet<String>();
        HashMap<String, String> addMethodToVariableMap = new HashMap<String, String>();
        HashMap<String, String> removeMethodToVariableMap = new HashMap<String, String>();
        HashMap<String, String> lookupMethodToVariableMap = new HashMap<String, String>();
        for (AltMethod originalMethod : convertMe.getMethods()) {
            String setterVariable = Generator.isSetter(originalMethod);
            if (setterVariable == null && (setterVariable = Generator.isGetter(originalMethod)) == null) continue;
            AltAnnotation pluralOf = null;
            AltAnnotation xmlElement = originalMethod.getAnnotation(XmlElement.class.getName());
            if (xmlElement != null) {
                pluralOf = originalMethod.getAnnotation(PluralOf.class.getName());
                String defaultValue = xmlElement.getStringValue("defaultValue");
                if (JAXB_DEFAULT_STRING.equals(xmlElement.getStringValue("name"))) {
                    xmlNameMap.put(setterVariable, new XmlElementData(setterVariable, defaultValue));
                } else {
                    xmlNameMap.put(setterVariable, new XmlElementData(xmlElement.getStringValue("name"), defaultValue));
                }
            } else {
                AltAnnotation xmlAttribute = originalMethod.getAnnotation(XmlAttribute.class.getName());
                if (xmlAttribute != null) {
                    if (JAXB_DEFAULT_STRING.equals(xmlAttribute.getStringValue("name"))) {
                        xmlNameMap.put(setterVariable, new XmlElementData(setterVariable, JAXB_DEFAULT_DEFAULT));
                    } else {
                        xmlNameMap.put(setterVariable, new XmlElementData(xmlAttribute.getStringValue("name"), JAXB_DEFAULT_DEFAULT));
                    }
                } else {
                    unmappedNames.add(setterVariable);
                }
            }
            if (pluralOf == null) {
                pluralOf = new AnnotationAltAnnotationImpl(new PluralOfDefault(), null);
            }
            String unDecapitalizedVariable = originalMethod.getName().substring(3);
            addMethodToVariableMap.put(Generator.getMethodName(MethodType.ADD, unDecapitalizedVariable, pluralOf), setterVariable);
            removeMethodToVariableMap.put(Generator.getMethodName(MethodType.REMOVE, unDecapitalizedVariable, pluralOf), setterVariable);
            lookupMethodToVariableMap.put(Generator.getMethodName(MethodType.LOOKUP, unDecapitalizedVariable, pluralOf), setterVariable);
        }
        HashSet<String> noXmlElementNames = new HashSet<String>();
        for (String unmappedName : unmappedNames) {
            if (xmlNameMap.containsKey(unmappedName)) continue;
            noXmlElementNames.add(unmappedName);
        }
        return new NameInformation(xmlNameMap, noXmlElementNames, addMethodToVariableMap, removeMethodToVariableMap, lookupMethodToVariableMap);
    }

    static MethodInformation getMethodInformation(AltMethod m, NameInformation xmlNameMap) {
        AltClass arrayType;
        AltClass typeChildType;
        MethodType methodType;
        boolean isCustom = Generator.isSpecifiedCustom(m);
        String setterVariable = null;
        String getterVariable = null;
        String lookupVariable = null;
        String addVariable = null;
        String removeVariable = null;
        if (!isCustom && (setterVariable = Generator.isSetter(m)) == null && (getterVariable = Generator.isGetter(m)) == null && (lookupVariable = Generator.isLookup(m, xmlNameMap)) == null && (addVariable = Generator.isAdd(m, xmlNameMap)) == null) {
            removeVariable = Generator.isRemove(m, xmlNameMap);
        }
        AltClass baseChildType = null;
        AltClass gsType = null;
        String variable = null;
        boolean isList = false;
        boolean isArray = false;
        if (getterVariable != null) {
            AltClass returnType;
            methodType = MethodType.GETTER;
            variable = getterVariable;
            gsType = returnType = m.getReturnType();
            if (List.class.getName().equals(returnType.getName())) {
                isList = true;
                typeChildType = m.getFirstTypeArgument();
                baseChildType = typeChildType;
                if (baseChildType == null) {
                    throw new RuntimeException("Cannot find child type of method " + m);
                }
            } else if (returnType.isArray()) {
                arrayType = returnType.getComponentType();
                if (arrayType.isInterface()) {
                    isArray = true;
                    baseChildType = arrayType;
                }
            } else if (returnType.isInterface() && !returnType.getName().startsWith(NO_CHILD_PACKAGE)) {
                baseChildType = returnType;
            }
        } else if (setterVariable != null) {
            AltClass setterType;
            methodType = MethodType.SETTER;
            variable = setterVariable;
            gsType = setterType = m.getParameterTypes().get(0);
            if (List.class.getName().equals(setterType.getName())) {
                isList = true;
                typeChildType = m.getFirstTypeArgumentOfParameter(0);
                baseChildType = typeChildType;
                if (baseChildType == null) {
                    throw new RuntimeException("Cannot find child type of method " + m);
                }
            } else if (setterType.isArray()) {
                arrayType = setterType.getComponentType();
                if (arrayType.isInterface()) {
                    isArray = true;
                    baseChildType = arrayType;
                }
            } else if (setterType.isInterface() && !setterType.getName().startsWith(NO_CHILD_PACKAGE)) {
                baseChildType = setterType;
            }
        } else if (lookupVariable != null) {
            AltClass lookupType;
            methodType = MethodType.LOOKUP;
            variable = lookupVariable;
            gsType = lookupType = m.getReturnType();
        } else if (addVariable != null) {
            methodType = MethodType.ADD;
            variable = addVariable;
        } else if (removeVariable != null) {
            methodType = MethodType.REMOVE;
            variable = removeVariable;
        } else {
            methodType = MethodType.CUSTOM;
        }
        String representedProperty = xmlNameMap.getNameMap(variable);
        if (representedProperty == null) {
            representedProperty = variable;
        }
        String defaultValue = xmlNameMap.getDefaultNameMap(variable);
        boolean key = false;
        if (m.getAnnotation(XmlID.class.getName()) != null || m.getAnnotation(XmlIdentifier.class.getName()) != null) {
            key = true;
        }
        return new MethodInformation(m, methodType, variable, representedProperty, defaultValue, baseChildType, gsType, key, isList, isArray);
    }

    private static String convertXmlRootElementName(AltAnnotation root, AltClass clazz) {
        String rootName = root.getStringValue("name");
        if (!JAXB_DEFAULT_STRING.equals(rootName)) {
            return rootName;
        }
        String simpleName = clazz.getSimpleName();
        char[] asChars = simpleName.toCharArray();
        StringBuffer sb = new StringBuffer();
        boolean firstChar = true;
        boolean lastCharWasCapital = false;
        for (char asChar : asChars) {
            if (firstChar) {
                firstChar = false;
                if (Character.isUpperCase(asChar)) {
                    lastCharWasCapital = true;
                    sb.append(Character.toLowerCase(asChar));
                    continue;
                }
                lastCharWasCapital = false;
                sb.append(asChar);
                continue;
            }
            if (Character.isUpperCase(asChar)) {
                if (!lastCharWasCapital) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(asChar));
                lastCharWasCapital = true;
                continue;
            }
            sb.append(asChar);
            lastCharWasCapital = false;
        }
        return sb.toString();
    }

    static String isGetter(AltMethod method) {
        String name = method.getName();
        if (name.startsWith("get")) {
            if (name.length() <= "get".length()) {
                return null;
            }
            if (method.getParameterTypes().size() != 0) {
                return null;
            }
            if (Void.TYPE.getName().equals(method.getReturnType().getName())) {
                return null;
            }
            String variableName = name.substring("get".length());
            return Introspector.decapitalize(variableName);
        }
        if (name.startsWith("is")) {
            if (name.length() <= "is".length()) {
                return null;
            }
            if (method.getParameterTypes().size() != 0) {
                return null;
            }
            if (Boolean.TYPE.getName().equals(method.getReturnType().getName()) || Boolean.class.getName().equals(method.getReturnType().getName())) {
                String variableName = name.substring("is".length());
                return Introspector.decapitalize(variableName);
            }
            return null;
        }
        return null;
    }

    private static boolean isSpecifiedCustom(AltMethod method) {
        AltAnnotation customAnnotation = method.getAnnotation(Customize.class.getName());
        return customAnnotation != null;
    }

    private static String isSetter(AltMethod method) {
        String name = method.getName();
        if (name.startsWith("set")) {
            if (name.length() <= "set".length()) {
                return null;
            }
            if (method.getParameterTypes().size() != 1) {
                return null;
            }
            if (Void.TYPE.getName().equals(method.getReturnType().getName())) {
                String variableName = name.substring("set".length());
                return Introspector.decapitalize(variableName);
            }
            return null;
        }
        return null;
    }

    private static String isLookup(AltMethod method, NameInformation nameInformation) {
        String name = method.getName();
        String retVal = nameInformation.getLookupVariableName(name);
        if (retVal == null) {
            return null;
        }
        List<AltClass> parameterTypes = method.getParameterTypes();
        if (parameterTypes.size() != 1) {
            return null;
        }
        if (!String.class.getName().equals(parameterTypes.get(0).getName())) {
            return null;
        }
        if (method.getReturnType() == null || Void.TYPE.getName().equals(method.getReturnType().getName())) {
            return null;
        }
        return retVal;
    }

    private static String isAdd(AltMethod method, NameInformation nameInformation) {
        String name = method.getName();
        String retVal = nameInformation.getAddVariableName(name);
        if (retVal == null) {
            return null;
        }
        if (!Void.TYPE.getName().equals(method.getReturnType().getName()) && !method.getReturnType().isInterface()) {
            return null;
        }
        List<AltClass> parameterTypes = method.getParameterTypes();
        if (parameterTypes.size() > 2) {
            return null;
        }
        if (parameterTypes.size() == 0) {
            return retVal;
        }
        AltClass param0 = parameterTypes.get(0);
        AltClass param1 = null;
        if (parameterTypes.size() == 2) {
            param1 = parameterTypes.get(1);
        }
        if (String.class.getName().equals(param0.getName()) || Integer.TYPE.getName().equals(param0.getName()) || param0.isInterface()) {
            if (parameterTypes.size() == 1) {
                return retVal;
            }
            if (Integer.TYPE.getName().equals(param0.getName())) {
                return null;
            }
            if (String.class.getName().equals(param0.getName()) ? Integer.TYPE.getName().equals(param1.getName()) : Integer.TYPE.getName().equals(param1.getName())) {
                return retVal;
            }
        }
        return null;
    }

    private static String isRemove(AltMethod method, NameInformation nameInformation) {
        String name = method.getName();
        String retVal = nameInformation.getRemoveVariableName(name);
        if (retVal == null) {
            return null;
        }
        if (method.getReturnType() == null || Void.TYPE.getName().equals(method.getReturnType().getName())) {
            return null;
        }
        AltClass returnType = method.getReturnType();
        if (!Boolean.TYPE.getName().equals(returnType.getName()) && !returnType.isInterface()) {
            return null;
        }
        List<AltClass> parameterTypes = method.getParameterTypes();
        if (parameterTypes.size() > 1) {
            return null;
        }
        if (parameterTypes.size() == 0) {
            return retVal;
        }
        AltClass param0 = parameterTypes.get(0);
        if (String.class.getName().equals(param0.getName()) || Integer.TYPE.getName().equals(param0.getName())) {
            return retVal;
        }
        return null;
    }

    private static String getCompilableClass(AltClass clazz) {
        int depth = 0;
        while (clazz.isArray()) {
            ++depth;
            clazz = clazz.getComponentType();
        }
        StringBuffer sb = new StringBuffer(clazz.getName());
        for (int lcv = 0; lcv < depth; ++lcv) {
            sb.append("[]");
        }
        return sb.toString();
    }

    private static AltClass getUltimateNonArrayClass(AltClass clazz) {
        if (clazz == null) {
            return null;
        }
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    private static void createInterfaceForAltClassIfNeeded(AltClass toFix, ClassPool defaultClassPool) {
        if (toFix == null) {
            return;
        }
        String fixerClass = (toFix = Generator.getUltimateNonArrayClass(toFix)).getName();
        if (defaultClassPool.getOrNull(fixerClass) == null) {
            defaultClassPool.makeInterface(fixerClass);
        }
    }

    private static final class PluralOfDefault
    extends AnnotationLiteral<PluralOf>
    implements PluralOf {
        private static final long serialVersionUID = 4358923840720264176L;

        private PluralOfDefault() {
        }

        @Override
        public String value() {
            return "*";
        }

        @Override
        public String add() {
            return "*";
        }

        @Override
        public String remove() {
            return "*";
        }

        @Override
        public String lookup() {
            return "*";
        }
    }
}

