/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.Model;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.XmlServiceImpl;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;
import org.glassfish.hk2.xml.spi.PreGenerationRequirement;
import org.glassfish.hk2.xml.spi.XmlServiceParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Singleton
@Visibility(value=DescriptorVisibility.LOCAL)
public class DomXmlParser
implements XmlServiceParser {
    @Inject
    private Provider<XmlServiceImpl> xmlService;
    private final DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();

    private DomXmlParser() throws ParserConfigurationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T parseRoot(Class<T> clazz, URI location, Unmarshaller.Listener listener) throws Exception {
        Document document;
        ClassReflectionHelper classReflectionHelper = ((XmlServiceImpl)this.xmlService.get()).getClassReflectionHelper();
        BaseHK2JAXBBean hk2Root = Utilities.createBean(clazz);
        hk2Root._setClassReflectionHelper(classReflectionHelper);
        InputStream urlStream = location.toURL().openStream();
        try {
            document = this.documentBuilder.parse(urlStream);
        }
        finally {
            urlStream.close();
        }
        Element docElement = document.getDocumentElement();
        this.handleElement(hk2Root, null, docElement, classReflectionHelper, listener);
        return (T)hk2Root;
    }

    private void handleNode(Node childNode, Model model, BaseHK2JAXBBean target, Unmarshaller.Listener listener, ClassReflectionHelper classReflectionHelper, Map<String, List<BaseHK2JAXBBean>> listChildren, Map<String, List<BaseHK2JAXBBean>> arrayChildren) {
        if (childNode instanceof Element) {
            Element childElement = (Element)childNode;
            String tagName = childElement.getTagName();
            if (model.getNonChildProperties().keySet().contains(tagName)) {
                Class<?> childType = model.getNonChildType(tagName);
                NodeList childNodeChildren = childElement.getChildNodes();
                String valueString = null;
                for (int lcv1 = 0; lcv1 < childNodeChildren.getLength(); ++lcv1) {
                    Node childNodeChild = childNodeChildren.item(lcv1);
                    if (!(childNodeChild instanceof Text)) continue;
                    Text childText = (Text)childNodeChild;
                    valueString = childText.getTextContent().trim();
                    break;
                }
                Object convertedValue = Utilities.getDefaultValue(valueString, childType);
                target._setProperty(tagName, convertedValue);
            } else if (model.getKeyedChildren().contains(tagName) || model.getUnKeyedChildren().contains(tagName)) {
                ParentedModel informedChild = model.getChild(tagName);
                Model grandChild = informedChild.getChildModel();
                BaseHK2JAXBBean hk2Root = Utilities.createBean(grandChild.getProxyAsClass());
                hk2Root._setClassReflectionHelper(classReflectionHelper);
                this.handleElement(hk2Root, target, childElement, classReflectionHelper, listener);
                if (informedChild.getChildType().equals((Object)ChildType.DIRECT)) {
                    target._setProperty(tagName, hk2Root);
                } else if (informedChild.getChildType().equals((Object)ChildType.LIST)) {
                    List<BaseHK2JAXBBean> cList = listChildren.get(tagName);
                    if (cList == null) {
                        cList = new ArrayList<BaseHK2JAXBBean>();
                        listChildren.put(tagName, cList);
                    }
                    cList.add(hk2Root);
                } else if (informedChild.getChildType().equals((Object)ChildType.ARRAY)) {
                    List<BaseHK2JAXBBean> cList = arrayChildren.get(tagName);
                    if (cList == null) {
                        cList = new LinkedList<BaseHK2JAXBBean>();
                        arrayChildren.put(tagName, cList);
                    }
                    cList.add(hk2Root);
                }
            }
        } else if (childNode instanceof Attr) {
            Attr childAttr = (Attr)childNode;
            String tagName = childAttr.getName();
            if (model.getNonChildProperties().keySet().contains(tagName)) {
                Class<?> childType = model.getNonChildType(tagName);
                String sValue = childAttr.getValue();
                Object convertedValue = Utilities.getDefaultValue(sValue, childType);
                target._setProperty(tagName, convertedValue);
            }
        }
    }

    private <T> void handleElement(BaseHK2JAXBBean target, BaseHK2JAXBBean parent, Element element, ClassReflectionHelper classReflectionHelper, Unmarshaller.Listener listener) {
        listener.beforeUnmarshal((Object)target, (Object)parent);
        HashMap<String, List<BaseHK2JAXBBean>> listChildren = new HashMap<String, List<BaseHK2JAXBBean>>();
        HashMap<String, List<BaseHK2JAXBBean>> arrayChildren = new HashMap<String, List<BaseHK2JAXBBean>>();
        Model model = target._getModel();
        NamedNodeMap attributeMap = element.getAttributes();
        for (int lcv = 0; lcv < attributeMap.getLength(); ++lcv) {
            Node childNode = attributeMap.item(lcv);
            this.handleNode(childNode, model, target, listener, classReflectionHelper, listChildren, arrayChildren);
        }
        NodeList beanChildren = element.getChildNodes();
        int length = beanChildren.getLength();
        for (int lcv = 0; lcv < length; ++lcv) {
            Node childNode = beanChildren.item(lcv);
            this.handleNode(childNode, model, target, listener, classReflectionHelper, listChildren, arrayChildren);
        }
        for (Map.Entry entry : listChildren.entrySet()) {
            target._setProperty((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : arrayChildren.entrySet()) {
            String childTag = (String)entry.getKey();
            ParentedModel pn = model.getChild(childTag);
            Class<?> childType = pn.getChildModel().getOriginalInterfaceAsClass();
            List individuals = (List)entry.getValue();
            Object actualArray = Array.newInstance(childType, individuals.size());
            int index = 0;
            for (BaseHK2JAXBBean individual : individuals) {
                Array.set(actualArray, index++, individual);
            }
            target._setProperty(childTag, actualArray);
        }
        listener.afterUnmarshal((Object)target, (Object)parent);
    }

    @Override
    public PreGenerationRequirement getPreGenerationRequirement() {
        return PreGenerationRequirement.LAZY_PREGENERATION;
    }
}

