/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.net.URI;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.Logger;
import org.glassfish.hk2.utilities.reflection.internal.ClassReflectionHelperImpl;
import org.glassfish.hk2.xml.api.XmlHubCommitMessage;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.internal.DynamicChangeInfo;
import org.glassfish.hk2.xml.internal.Hk2JAXBUnmarshallerListener;
import org.glassfish.hk2.xml.internal.JAUtilities;
import org.glassfish.hk2.xml.internal.UnparentedNode;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.XmlRootHandleImpl;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;
import org.glassfish.hk2.xml.spi.XmlServiceParser;

@Singleton
public class XmlServiceImpl
implements XmlService {
    private final JAUtilities jaUtilities = new JAUtilities();
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private DynamicConfigurationService dynamicConfigurationService;
    @Inject
    private Hub hub;
    @Inject
    private Provider<XmlServiceParser> parser;
    private final ClassReflectionHelper classReflectionHelper = new ClassReflectionHelperImpl();

    @Override
    public <T> XmlRootHandle<T> unmarshall(URI uri, Class<T> jaxbAnnotatedClassOrInterface) {
        return this.unmarshall(uri, jaxbAnnotatedClassOrInterface, true, true);
    }

    @Override
    public <T> XmlRootHandle<T> unmarshall(URI uri, Class<T> jaxbAnnotatedInterface, boolean advertiseInRegistry, boolean advertiseInHub) {
        if (uri == null || jaxbAnnotatedInterface == null) {
            throw new IllegalArgumentException();
        }
        if (!jaxbAnnotatedInterface.isInterface()) {
            throw new IllegalArgumentException("Only an interface can be given to unmarshall: " + jaxbAnnotatedInterface.getName());
        }
        try {
            UnparentedNode parent = this.jaUtilities.convertRootAndLeaves(jaxbAnnotatedInterface);
            return this.unmarshallClass(uri, parent, advertiseInRegistry, advertiseInHub);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable e) {
            throw new MultiException(e);
        }
    }

    private <T> XmlRootHandle<T> unmarshallClass(URI uri, UnparentedNode node, boolean advertise, boolean advertiseInHub) throws Exception {
        long elapsedUpToJAXB = 0L;
        if (JAUtilities.DEBUG_GENERATION_TIMING) {
            elapsedUpToJAXB = System.currentTimeMillis();
        }
        XmlServiceParser localParser = (XmlServiceParser)this.parser.get();
        Hk2JAXBUnmarshallerListener listener = new Hk2JAXBUnmarshallerListener(this.jaUtilities, this.classReflectionHelper);
        long jaxbUnmarshallElapsedTime = 0L;
        if (JAUtilities.DEBUG_GENERATION_TIMING) {
            jaxbUnmarshallElapsedTime = System.currentTimeMillis();
            elapsedUpToJAXB = jaxbUnmarshallElapsedTime - elapsedUpToJAXB;
            Logger.getLogger().debug("Time in up to JAXB parsing " + uri + " is " + elapsedUpToJAXB + " milliseconds");
        }
        Object root = localParser.parseRoot(node.getTranslatedClass(), uri, listener);
        long elapsedJAXBToAdvertisement = 0L;
        if (JAUtilities.DEBUG_GENERATION_TIMING) {
            elapsedJAXBToAdvertisement = System.currentTimeMillis();
            jaxbUnmarshallElapsedTime = elapsedJAXBToAdvertisement - jaxbUnmarshallElapsedTime;
            Logger.getLogger().debug("Time in JAXB parsing " + uri + " is " + jaxbUnmarshallElapsedTime + " milliseconds");
        }
        DynamicChangeInfo changeControl = new DynamicChangeInfo(this.jaUtilities, advertiseInHub ? this.hub : null, this, advertise ? this.dynamicConfigurationService : null, this.serviceLocator);
        for (BaseHK2JAXBBean base : listener.getAllBeans()) {
            String instanceName = Utilities.createInstanceName(base);
            base._setInstanceName(instanceName);
            base._setDynamicChangeInfo(changeControl);
        }
        long elapsedPreAdvertisement = 0L;
        if (JAUtilities.DEBUG_GENERATION_TIMING) {
            elapsedPreAdvertisement = System.currentTimeMillis();
            elapsedJAXBToAdvertisement = elapsedPreAdvertisement - elapsedJAXBToAdvertisement;
            Logger.getLogger().debug("Time from JAXB to PreAdvertisement " + uri + " is " + elapsedJAXBToAdvertisement + " milliseconds");
        }
        DynamicConfiguration config = advertise ? this.dynamicConfigurationService.createDynamicConfiguration() : null;
        WriteableBeanDatabase wdb = advertiseInHub ? this.hub.getWriteableDatabaseCopy() : null;
        for (BaseHK2JAXBBean bean : listener.getAllBeans()) {
            Utilities.advertise(wdb, config, bean);
        }
        long elapsedHK2Advertisement = 0L;
        if (JAUtilities.DEBUG_GENERATION_TIMING) {
            elapsedHK2Advertisement = System.currentTimeMillis();
            elapsedPreAdvertisement = elapsedHK2Advertisement - elapsedPreAdvertisement;
            Logger.getLogger().debug("Time from JAXB to PreAdvertisement " + uri + " is " + elapsedPreAdvertisement + " milliseconds");
        }
        if (config != null) {
            config.commit();
        }
        long elapsedHubAdvertisement = 0L;
        if (JAUtilities.DEBUG_GENERATION_TIMING) {
            elapsedHubAdvertisement = System.currentTimeMillis();
            elapsedHK2Advertisement = elapsedHubAdvertisement - elapsedHK2Advertisement;
            Logger.getLogger().debug("Time to advertise " + uri + " in HK2 is " + elapsedHK2Advertisement + " milliseconds");
        }
        if (wdb != null) {
            wdb.commit((Object)new XmlHubCommitMessage(){});
        }
        if (JAUtilities.DEBUG_GENERATION_TIMING) {
            elapsedHubAdvertisement = System.currentTimeMillis() - elapsedHubAdvertisement;
            Logger.getLogger().debug("Time to advertise " + uri + " in Hub is " + elapsedHubAdvertisement + " milliseconds");
        }
        return new XmlRootHandleImpl(this, this.hub, root, node, uri, advertise, advertiseInHub, changeControl);
    }

    @Override
    public <T> XmlRootHandle<T> createEmptyHandle(Class<T> jaxbAnnotatedInterface, boolean advertiseInRegistry, boolean advertiseInHub) {
        if (!jaxbAnnotatedInterface.isInterface()) {
            throw new IllegalArgumentException("Only an interface can be given to unmarshall: " + jaxbAnnotatedInterface.getName());
        }
        try {
            UnparentedNode node = this.jaUtilities.convertRootAndLeaves(jaxbAnnotatedInterface);
            return new XmlRootHandleImpl<Object>(this, this.hub, null, node, null, advertiseInRegistry, advertiseInHub, new DynamicChangeInfo(this.jaUtilities, this.hub, this, advertiseInRegistry ? this.dynamicConfigurationService : null, this.serviceLocator));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MultiException((Throwable)e);
        }
    }

    @Override
    public <T> XmlRootHandle<T> createEmptyHandle(Class<T> jaxbAnnotationInterface) {
        return this.createEmptyHandle(jaxbAnnotationInterface, true, true);
    }

    @Override
    public <T> T createBean(Class<T> beanInterface) {
        BaseHK2JAXBBean retVal;
        if (!beanInterface.isInterface()) {
            throw new IllegalArgumentException("Only an interface can be given to unmarshall: " + beanInterface.getName());
        }
        UnparentedNode node = this.jaUtilities.convertRootAndLeaves(beanInterface);
        BaseHK2JAXBBean base = retVal = Utilities.createBean(node.getTranslatedClass());
        base._setModel(node, this.classReflectionHelper);
        base._setActive();
        return (T)retVal;
    }

    public ClassReflectionHelper getClassReflectionHelper() {
        return this.classReflectionHelper;
    }

    DynamicConfigurationService getDynamicConfigurationService() {
        return this.dynamicConfigurationService;
    }

    public JAUtilities getJAUtilities() {
        return this.jaUtilities;
    }
}

