/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities.cache.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import org.glassfish.hk2.utilities.cache.CacheEntry;
import org.glassfish.hk2.utilities.cache.LRUCache;
import org.glassfish.hk2.utilities.reflection.Logger;

public class LRUCacheImpl<K, V>
extends LRUCache<K, V> {
    private static final String CACHING_PROPERTY = "org.jvnet.hk2.properties.caching";
    private static final String REPORT_INTERVAL_PROPERTY = "org.jvnet.hk2.properties.caching.reportInterval";
    private static final boolean CACHING = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.parseBoolean(System.getProperty(LRUCacheImpl.CACHING_PROPERTY, "true"));
        }
    });
    private final int maxCacheSize;
    private final HashMap<K, CacheEntryImpl> entries = new HashMap();
    private CacheEntryImpl first;
    private CacheEntryImpl last;
    private final long cacheHitRateReportingInterval;
    private long hits;
    private long queries;

    private LRUCacheImpl(int maxCacheSize, long userInterval) {
        if (maxCacheSize <= 2) {
            throw new IllegalArgumentException();
        }
        this.maxCacheSize = maxCacheSize;
        this.cacheHitRateReportingInterval = userInterval < 0L ? 0L : userInterval;
    }

    public LRUCacheImpl(int maxCacheSize) {
        this(maxCacheSize, AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return Long.parseLong(System.getProperty(LRUCacheImpl.REPORT_INTERVAL_PROPERTY, "0"));
            }
        }));
    }

    private synchronized void removeEntryFromRemove(CacheEntryImpl removeMe) {
        if (this.removeEntry(removeMe, true)) {
            this.entries.remove(removeMe.getKey());
        }
    }

    private synchronized boolean removeEntry(CacheEntryImpl removeMe, boolean trulyRemove) {
        if (removeMe.isRemoved()) {
            return false;
        }
        if (trulyRemove) {
            removeMe.remove();
        }
        CacheEntryImpl previous = removeMe.getPrevious();
        CacheEntryImpl next = removeMe.getNext();
        if (previous == null) {
            this.first = next;
        } else {
            previous.setNext(next);
        }
        if (next == null) {
            this.last = previous;
        } else {
            next.setPrevious(previous);
        }
        removeMe.setNext(null);
        removeMe.setPrevious(null);
        return true;
    }

    private void addToFront(CacheEntryImpl addMe) {
        addMe.setNext(this.first);
        if (this.first != null) {
            this.first.setPrevious(addMe);
        }
        this.first = addMe;
        if (this.last == null) {
            this.last = addMe;
        }
    }

    @Override
    public synchronized V get(K key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (this.cacheHitRateReportingInterval > 0L && this.queries > 0L && this.queries % this.cacheHitRateReportingInterval == 0L) {
            double rate = (double)this.hits / (double)this.queries;
            Logger.getLogger().debug("LRUCacheHitRate is Rate=" + rate + " hits=" + this.hits + " queries=" + this.queries + " entries=" + this.entries.size());
        }
        ++this.queries;
        CacheEntryImpl entry = this.entries.get(key);
        if (entry == null) {
            return null;
        }
        ++this.hits;
        this.removeEntry(entry, false);
        this.addToFront(entry);
        return (V)entry.getValue();
    }

    @Override
    public synchronized CacheEntry put(K key, V value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException();
        }
        if (!CACHING) {
            return new CacheEntry(){

                @Override
                public void removeFromCache() {
                }
            };
        }
        CacheEntryImpl addMe = new CacheEntryImpl(value);
        addMe.setKey(key);
        CacheEntryImpl cei = this.entries.put(key, addMe);
        if (cei != null) {
            this.removeEntry(cei, true);
        }
        this.addToFront(addMe);
        if (this.entries.size() > this.maxCacheSize) {
            Object removeMe = this.last.getKey();
            this.entries.remove(removeMe);
            this.removeEntry(this.last, true);
        }
        return addMe;
    }

    @Override
    public synchronized void releaseCache() {
        this.entries.clear();
        this.first = null;
        this.last = null;
        this.hits = 0L;
        this.queries = 0L;
    }

    @Override
    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public String toString() {
        return "LRUCacheImpl(maxCacheSize=" + this.maxCacheSize + "," + System.identityHashCode(this) + ")";
    }

    static {
        if (!CACHING) {
            Logger.getLogger().debug("HK2 Caching has been disabled");
        }
    }

    private class CacheEntryImpl
    implements CacheEntry {
        private K key;
        private final V value;
        private boolean removed = false;
        private CacheEntryImpl next;
        private CacheEntryImpl previous;

        private CacheEntryImpl(V value) {
            this.value = value;
        }

        private V getValue() {
            return this.value;
        }

        private boolean isRemoved() {
            return this.removed;
        }

        private void remove() {
            this.removed = true;
        }

        private CacheEntryImpl getNext() {
            return this.next;
        }

        private CacheEntryImpl getPrevious() {
            return this.previous;
        }

        private void setNext(CacheEntryImpl next) {
            this.next = next;
        }

        private void setPrevious(CacheEntryImpl previous) {
            this.previous = previous;
        }

        private void setKey(K key) {
            this.key = key;
        }

        private K getKey() {
            return this.key;
        }

        @Override
        public void removeFromCache() {
            LRUCacheImpl.this.removeEntryFromRemove(this);
        }

        public String toString() {
            return "CacheEntry(" + this.key + "=" + this.value + "," + this.removed + "," + System.identityHashCode(this) + ")";
        }
    }
}

