/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities.reflection;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;

public class ReflectionHelper {
    private static final HashSet<Character> ESCAPE_CHARACTERS = new HashSet();
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'{', '}', '[', ']', ':', ';', '=', ',', '\\'};
    private static final HashMap<Character, Character> REPLACE_CHARACTERS = new HashMap();

    public static Class<?> getRawClass(Type type) {
        Type rawType;
        if (type == null) {
            return null;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            if (!(componentType instanceof ParameterizedType)) {
                return null;
            }
            Class<?> rawComponentClass = ReflectionHelper.getRawClass(componentType);
            String forNameName = "[L" + rawComponentClass.getName() + ";";
            try {
                return Class.forName(forNameName);
            }
            catch (Throwable th) {
                return null;
            }
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    private static String getNamedName(Named named, Class<?> implClass) {
        String name = named.value();
        if (name != null && !name.equals("")) {
            return name;
        }
        String cn = implClass.getName();
        int index = cn.lastIndexOf(".");
        if (index < 0) {
            return cn;
        }
        return cn.substring(index + 1);
    }

    public static String getName(Class<?> implClass) {
        String namedName;
        Named named = implClass.getAnnotation(Named.class);
        String string = namedName = named != null ? ReflectionHelper.getNamedName(named, implClass) : null;
        if (namedName != null) {
            return namedName;
        }
        return null;
    }

    private static void addAllGenericInterfaces(Type[] types, Set<Type> closures) {
        for (Type type : types) {
            closures.add(type);
            Class<?> rawClass = ReflectionHelper.getRawClass(type);
            if (rawClass == null) continue;
            ReflectionHelper.addAllGenericInterfaces(rawClass.getGenericInterfaces(), closures);
        }
    }

    private static Set<Type> getTypeClosure(Type ofType) {
        Class<?> rawClass;
        HashSet<Type> retVal = new HashSet<Type>();
        Type currentType = ofType;
        while (currentType != null && (rawClass = ReflectionHelper.getRawClass(currentType)) != null) {
            retVal.add(currentType);
            ReflectionHelper.addAllGenericInterfaces(rawClass.getGenericInterfaces(), retVal);
            currentType = rawClass.getGenericSuperclass();
        }
        return retVal;
    }

    public static Set<Type> getTypeClosure(Type ofType, Set<String> contracts) {
        Set<Type> closure = ReflectionHelper.getTypeClosure(ofType);
        HashSet<Type> retVal = new HashSet<Type>();
        for (Type t : closure) {
            Class<?> rawClass = ReflectionHelper.getRawClass(t);
            if (rawClass == null || !contracts.contains(rawClass.getName())) continue;
            retVal.add(t);
        }
        return retVal;
    }

    public static Set<Type> getAdvertisedTypesFromClass(Type type, Class<? extends Annotation> markerAnnotation) {
        Class<?> rawClass;
        LinkedHashSet<Type> retVal = new LinkedHashSet<Type>();
        if (type == null) {
            return retVal;
        }
        retVal.add(type);
        Class<?> originalRawClass = ReflectionHelper.getRawClass(type);
        if (originalRawClass == null) {
            return retVal;
        }
        Type genericSuperclass = originalRawClass.getGenericSuperclass();
        while (genericSuperclass != null && (rawClass = ReflectionHelper.getRawClass(genericSuperclass)) != null) {
            if (rawClass.isAnnotationPresent(markerAnnotation)) {
                retVal.add(genericSuperclass);
            }
            genericSuperclass = rawClass.getGenericSuperclass();
        }
        while (originalRawClass != null) {
            Type[] genericInterfaces;
            for (Type genericInterface : genericInterfaces = originalRawClass.getGenericInterfaces()) {
                Class<?> rawClass2 = ReflectionHelper.getRawClass(genericInterface);
                if (rawClass2 == null || !rawClass2.isAnnotationPresent(markerAnnotation)) continue;
                retVal.add(genericInterface);
            }
            originalRawClass = originalRawClass.getSuperclass();
        }
        return retVal;
    }

    public static Set<Type> getAdvertisedTypesFromObject(Object t, Class<? extends Annotation> markerAnnotation) {
        if (t == null) {
            return Collections.emptySet();
        }
        return ReflectionHelper.getAdvertisedTypesFromClass(t.getClass(), markerAnnotation);
    }

    public static Set<String> getContractsFromClass(Class<?> clazz, Class<? extends Annotation> markerAnnotation) {
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        if (clazz == null) {
            return retVal;
        }
        retVal.add(clazz.getName());
        for (Class<?> extendsClasses = clazz.getSuperclass(); extendsClasses != null; extendsClasses = extendsClasses.getSuperclass()) {
            if (!extendsClasses.isAnnotationPresent(markerAnnotation)) continue;
            retVal.add(extendsClasses.getName());
        }
        while (clazz != null) {
            Class<?>[] interfaces;
            for (Class<?> iFace : interfaces = clazz.getInterfaces()) {
                if (!iFace.isAnnotationPresent(markerAnnotation)) continue;
                retVal.add(iFace.getName());
            }
            clazz = clazz.getSuperclass();
        }
        return retVal;
    }

    public static Class<? extends Annotation> getScopeFromObject(Object t, Class<? extends Annotation> annoDefault) {
        if (t == null) {
            return annoDefault;
        }
        return ReflectionHelper.getScopeFromClass(t.getClass(), annoDefault);
    }

    public static Class<? extends Annotation> getScopeFromClass(Class<?> clazz, Class<? extends Annotation> annoDefault) {
        if (clazz == null) {
            return annoDefault;
        }
        for (Annotation annotation : clazz.getAnnotations()) {
            Class<? extends Annotation> annoClass = annotation.annotationType();
            if (!annoClass.isAnnotationPresent(Scope.class)) continue;
            return annoClass;
        }
        return annoDefault;
    }

    public static boolean isAnnotationAQualifier(Annotation anno) {
        Class<? extends Annotation> annoType = anno.annotationType();
        return annoType.isAnnotationPresent(Qualifier.class);
    }

    public static Set<Annotation> getQualifiersFromObject(Object t) {
        if (t == null) {
            return Collections.emptySet();
        }
        return ReflectionHelper.getQualifierAnnotations(t.getClass());
    }

    public static Set<String> getQualifiersFromClass(Class<?> clazz) {
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        if (clazz == null) {
            return retVal;
        }
        for (Annotation annotation : clazz.getAnnotations()) {
            if (!ReflectionHelper.isAnnotationAQualifier(annotation)) continue;
            retVal.add(annotation.annotationType().getName());
        }
        while (clazz != null) {
            for (Class<?> iFace : clazz.getInterfaces()) {
                for (Annotation annotation : iFace.getAnnotations()) {
                    if (!ReflectionHelper.isAnnotationAQualifier(annotation)) continue;
                    retVal.add(annotation.annotationType().getName());
                }
            }
            clazz = clazz.getSuperclass();
        }
        return retVal;
    }

    private static Set<Annotation> internalGetQualifierAnnotations(AnnotatedElement annotatedGuy) {
        LinkedHashSet<Annotation> retVal = new LinkedHashSet<Annotation>();
        if (annotatedGuy == null) {
            return retVal;
        }
        for (Annotation annotation : annotatedGuy.getAnnotations()) {
            if (!ReflectionHelper.isAnnotationAQualifier(annotation)) continue;
            retVal.add(annotation);
        }
        if (!(annotatedGuy instanceof Class)) {
            return retVal;
        }
        for (Class clazz = (Class)annotatedGuy; clazz != null; clazz = clazz.getSuperclass()) {
            for (Class<?> iFace : clazz.getInterfaces()) {
                for (Annotation annotation : iFace.getAnnotations()) {
                    if (!ReflectionHelper.isAnnotationAQualifier(annotation)) continue;
                    retVal.add(annotation);
                }
            }
        }
        return retVal;
    }

    public static Set<Annotation> getQualifierAnnotations(final AnnotatedElement annotatedGuy) {
        Set<Annotation> retVal = AccessController.doPrivileged(new PrivilegedAction<Set<Annotation>>(){

            @Override
            public Set<Annotation> run() {
                return ReflectionHelper.internalGetQualifierAnnotations(annotatedGuy);
            }
        });
        return retVal;
    }

    public static String writeSet(Set<?> set) {
        if (set == null) {
            return "{}";
        }
        StringBuffer sb = new StringBuffer("{");
        boolean first = true;
        for (Object writeMe : set) {
            if (first) {
                first = false;
                sb.append(ReflectionHelper.escapeString(writeMe.toString()));
                continue;
            }
            sb.append("," + ReflectionHelper.escapeString(writeMe.toString()));
        }
        sb.append("}");
        return sb.toString();
    }

    public static void readSet(String line, Collection<String> addToMe) throws IOException {
        char[] asChars = new char[line.length()];
        line.getChars(0, line.length(), asChars, 0);
        ReflectionHelper.internalReadSet(asChars, 0, addToMe);
    }

    private static int internalReadSet(char[] asChars, int startIndex, Collection<String> addToMe) throws IOException {
        int dot;
        int startOfSet = -1;
        for (dot = startIndex; dot < asChars.length; ++dot) {
            if (asChars[dot] != '{') continue;
            startOfSet = dot++;
            break;
        }
        if (startOfSet == -1) {
            throw new IOException("Unknown set format, no initial { character : " + new String(asChars));
        }
        StringBuffer elementBuffer = new StringBuffer();
        int endOfSet = -1;
        while (dot < asChars.length) {
            char dotChar = asChars[dot];
            if (dotChar == '}') {
                addToMe.add(elementBuffer.toString());
                endOfSet = dot;
                break;
            }
            if (dotChar == ',') {
                addToMe.add(elementBuffer.toString());
                elementBuffer = new StringBuffer();
            } else if (dotChar != '\\') {
                elementBuffer.append(dotChar);
            } else {
                if (dot + 1 >= asChars.length) break;
                if ((dotChar = asChars[++dot]) == 'n') {
                    elementBuffer.append('\n');
                } else if (dotChar == 'r') {
                    elementBuffer.append('\r');
                } else {
                    elementBuffer.append(dotChar);
                }
            }
            ++dot;
        }
        if (endOfSet == -1) {
            throw new IOException("Unknown set format, no ending } character : " + new String(asChars));
        }
        return dot - startIndex;
    }

    private static int readKeyStringListLine(char[] asChars, int startIndex, Map<String, List<String>> addToMe) throws IOException {
        char skipComma;
        int dot;
        int equalsIndex = -1;
        for (dot = startIndex; dot < asChars.length; ++dot) {
            char dotChar = asChars[dot];
            if (dotChar != '=') continue;
            equalsIndex = dot;
            break;
        }
        if (equalsIndex < 0) {
            throw new IOException("Unknown key-string list format, no equals: " + new String(asChars));
        }
        String key = new String(asChars, startIndex, equalsIndex - startIndex);
        if (++dot >= asChars.length) {
            throw new IOException("Found a key with no value, " + key + " in line " + new String(asChars));
        }
        LinkedList<String> listValues = new LinkedList<String>();
        int addOn = ReflectionHelper.internalReadSet(asChars, dot, listValues);
        if (!listValues.isEmpty()) {
            addToMe.put(key, listValues);
        }
        if ((dot += addOn + 1) < asChars.length && (skipComma = asChars[dot]) == ',') {
            ++dot;
        }
        return dot - startIndex;
    }

    public static void readMetadataMap(String line, Map<String, List<String>> addToMe) throws IOException {
        int addMe;
        char[] asChars = new char[line.length()];
        line.getChars(0, line.length(), asChars, 0);
        for (int dot = 0; dot < asChars.length; dot += addMe) {
            addMe = ReflectionHelper.readKeyStringListLine(asChars, dot, addToMe);
        }
    }

    private static String escapeString(String escapeMe) {
        char[] asChars = new char[escapeMe.length()];
        escapeMe.getChars(0, escapeMe.length(), asChars, 0);
        StringBuffer sb = new StringBuffer();
        for (int lcv = 0; lcv < asChars.length; ++lcv) {
            char candidateChar = asChars[lcv];
            if (ESCAPE_CHARACTERS.contains(Character.valueOf(candidateChar))) {
                sb.append('\\');
                sb.append(candidateChar);
                continue;
            }
            if (REPLACE_CHARACTERS.containsKey(Character.valueOf(candidateChar))) {
                char replaceWithMe = REPLACE_CHARACTERS.get(Character.valueOf(candidateChar)).charValue();
                sb.append('\\');
                sb.append(replaceWithMe);
                continue;
            }
            sb.append(candidateChar);
        }
        return sb.toString();
    }

    private static String writeList(List<String> list) {
        StringBuffer sb = new StringBuffer("{");
        boolean first = true;
        for (String writeMe : list) {
            if (first) {
                first = false;
                sb.append(ReflectionHelper.escapeString(writeMe.toString()));
                continue;
            }
            sb.append("," + ReflectionHelper.escapeString(writeMe.toString()));
        }
        sb.append("}");
        return sb.toString();
    }

    public static String writeMetadata(Map<String, List<String>> metadata) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Map.Entry<String, List<String>> entry : metadata.entrySet()) {
            if (first) {
                first = false;
                sb.append(entry.getKey() + '=');
            } else {
                sb.append("," + entry.getKey() + '=');
            }
            sb.append(ReflectionHelper.writeList(entry.getValue()));
        }
        return sb.toString();
    }

    public static void addMetadata(Map<String, List<String>> metadatas, String key, String value) {
        if (key == null || value == null) {
            return;
        }
        if (key.indexOf(61) >= 0) {
            throw new IllegalArgumentException("The key field may not have an = in it:" + key);
        }
        List<String> inner = metadatas.get(key);
        if (inner == null) {
            inner = new LinkedList<String>();
            metadatas.put(key, inner);
        }
        inner.add(value);
    }

    public static boolean removeMetadata(Map<String, List<String>> metadatas, String key, String value) {
        if (key == null || value == null) {
            return false;
        }
        List<String> inner = metadatas.get(key);
        if (inner == null) {
            return false;
        }
        boolean retVal = inner.remove(value);
        if (inner.size() <= 0) {
            metadatas.remove(key);
        }
        return retVal;
    }

    public static boolean removeAllMetadata(Map<String, List<String>> metadatas, String key) {
        List<String> values = metadatas.remove(key);
        return values != null && values.size() > 0;
    }

    public static Map<String, List<String>> deepCopyMetadata(Map<String, List<String>> copyMe) {
        if (copyMe == null) {
            return null;
        }
        LinkedHashMap<String, List<String>> retVal = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : copyMe.entrySet()) {
            String key = entry.getKey();
            if (key.indexOf(61) >= 0) {
                throw new IllegalArgumentException("The key field may not have an = in it:" + key);
            }
            List<String> values = entry.getValue();
            LinkedList<String> valuesCopy = new LinkedList<String>();
            for (String value : values) {
                valuesCopy.add(value);
            }
            retVal.put(key, valuesCopy);
        }
        return retVal;
    }

    static {
        for (char illegal : ILLEGAL_CHARACTERS) {
            ESCAPE_CHARACTERS.add(Character.valueOf(illegal));
        }
        REPLACE_CHARACTERS.put(Character.valueOf('\n'), Character.valueOf('n'));
        REPLACE_CHARACTERS.put(Character.valueOf('\r'), Character.valueOf('r'));
    }
}

