/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.persistence.properties.internal;

import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.configuration.hub.api.WriteableType;
import org.glassfish.hk2.configuration.persistence.properties.PropertyFileBean;
import org.glassfish.hk2.configuration.persistence.properties.PropertyFileHandle;
import org.glassfish.hk2.configuration.persistence.properties.PropertyFileService;
import org.glassfish.hk2.configuration.persistence.properties.internal.PropertyFileHandleImpl;
import org.jvnet.hk2.annotations.Service;

@Service
public class PropertyFileServiceImpl
implements PropertyFileService {
    private static final int MAX_TRIES = 10000;
    @Inject
    private Hub hub;

    @Override
    public PropertyFileHandle createPropertyHandleOfSpecificType(String specificTypeName, String defaultInstanceName) {
        return new PropertyFileHandleImpl(specificTypeName, null, defaultInstanceName, this.hub);
    }

    @Override
    public PropertyFileHandle createPropertyHandleOfSpecificType(String specificTypeName) {
        return new PropertyFileHandleImpl(specificTypeName, null, null, this.hub);
    }

    @Override
    public PropertyFileHandle createPropertyHandleOfAnyType(String defaultTypeName, String defaultInstanceName) {
        return new PropertyFileHandleImpl(null, defaultTypeName, defaultInstanceName, this.hub);
    }

    @Override
    public PropertyFileHandle createPropertyHandleOfAnyType() {
        return new PropertyFileHandleImpl(null, null, null, this.hub);
    }

    @Override
    public void addPropertyFileBean(PropertyFileBean propertyFileBean) {
        boolean success = false;
        for (int lcv = 0; lcv < 10000; ++lcv) {
            WriteableBeanDatabase wbd = this.hub.getWriteableDatabaseCopy();
            WriteableType wt = wbd.findOrAddWriteableType("PropertyFileServiceBean");
            Instance oldInstance = wt.getInstance("DEFAULT");
            if (oldInstance != null) {
                PropertyFileBean oldBean = (PropertyFileBean)oldInstance.getBean();
                wt.modifyInstance("DEFAULT", (Object)propertyFileBean, new PropertyChangeEvent[]{new PropertyChangeEvent(propertyFileBean, "typeMapping", oldBean.getTypeMapping(), propertyFileBean.getTypeMapping())});
            } else {
                wt.addInstance("DEFAULT", (Object)propertyFileBean);
            }
            try {
                wbd.commit();
                success = true;
                break;
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
        }
        if (!success) {
            throw new IllegalStateException("Could not update hub with propertyFileBean " + propertyFileBean);
        }
    }

    @Override
    public void removePropertyFileBean() {
        boolean success = false;
        for (int lcv = 0; lcv < 10000; ++lcv) {
            WriteableBeanDatabase wbd = this.hub.getWriteableDatabaseCopy();
            wbd.removeType("PropertyFileServiceBean");
            try {
                wbd.commit();
                success = true;
                break;
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
        }
        if (!success) {
            throw new IllegalStateException("Could not update hub to remove the propertyFileBean");
        }
    }
}

