/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.pbuf.internal;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.beans.Introspector;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.pbuf.api.annotations.Comment;
import org.glassfish.hk2.pbuf.api.annotations.OneOf;
import org.glassfish.hk2.pbuf.internal.PBUtilities;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.xml.internal.Utilities;

@SupportedAnnotationTypes(value={"org.glassfish.hk2.pbuf.api.annotations.GenerateProto"})
public class PBufGeneratorProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Filer filer = this.processingEnv.getFiler();
        Elements elements = this.processingEnv.getElementUtils();
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> clazzes = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : clazzes) {
                TypeElement clazz;
                ElementKind cKind;
                if (!(element instanceof TypeElement) || !ElementKind.INTERFACE.equals((Object)(cKind = (clazz = (TypeElement)element).getKind()))) continue;
                Writer writer = this.openWriter(clazz, elements, filer);
                try {
                    this.buildHeader(writer, clazz, elements);
                    List<? extends Element> members = elements.getAllMembers(clazz);
                    this.handleMethods(writer, clazz, members, elements);
                }
                finally {
                    try {
                        writer.close();
                    }
                    catch (IOException ioe) {
                        throw new MultiException((Throwable)ioe);
                    }
                }
            }
        }
        return true;
    }

    private static void writeBlankLine(Writer writer) throws IOException {
        writer.write("\n");
    }

    private static void writeTab(Writer writer) throws IOException {
        writer.write("    ");
    }

    private Writer openWriter(TypeElement clazz, Elements elements, Filer filer) {
        PackageElement clazzPackage = elements.getPackageOf(clazz);
        String clazzPackageName = Utilities.convertNameToString((Name)clazzPackage.getQualifiedName());
        Object clazzSimpleName = Utilities.convertNameToString((Name)clazz.getSimpleName());
        clazzSimpleName = (String)clazzSimpleName + ".proto";
        try {
            FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, clazzPackageName, (CharSequence)clazzSimpleName, clazz);
            return fileObject.openWriter();
        }
        catch (IOException ioe) {
            throw new MultiException((Throwable)ioe);
        }
    }

    private Writer buildHeader(Writer writer, TypeElement clazz, Elements elements) {
        PackageElement clazzPackage = elements.getPackageOf(clazz);
        String clazzPackageName = Utilities.convertNameToString((Name)clazzPackage.getQualifiedName());
        String name = Utilities.convertNameToString((Name)clazz.getQualifiedName());
        name = name.replace('.', '/');
        try {
            writer.write("// Generated by PBufGeneratorProcessor\n");
            writer.write("// Source File: " + name + ".java\n");
            PBufGeneratorProcessor.writeBlankLine(writer);
            writer.write("syntax = \"proto3\";\n");
            PBufGeneratorProcessor.writeBlankLine(writer);
            if (clazzPackageName != null && !clazzPackageName.isEmpty()) {
                writer.write("package " + clazzPackageName + ";\n\n");
            }
            return writer;
        }
        catch (IOException ioe) {
            throw new MultiException((Throwable)ioe);
        }
    }

    private void doComment(Writer writer, String comment, int indentLevel) throws IOException {
        if (comment == null || comment.isEmpty()) {
            return;
        }
        StringTokenizer nlTokenizer = new StringTokenizer(comment, "\n\r");
        while (nlTokenizer.hasMoreTokens()) {
            String singleLine = "// " + nlTokenizer.nextToken() + "\n";
            for (int lcv = 0; lcv < indentLevel; ++lcv) {
                PBufGeneratorProcessor.writeTab(writer);
            }
            writer.write(singleLine);
        }
    }

    private void handleMethods(Writer writer, TypeElement clazz, List<? extends Element> allMethods, Elements elements) {
        String clazzSimpleName = Utilities.convertNameToString((Name)clazz.getSimpleName());
        Comment commentAnnotation = clazz.getAnnotation(Comment.class);
        String comment = null;
        if (commentAnnotation != null) {
            comment = commentAnnotation.value();
        }
        try {
            List<XmlElementInfo> infos = this.doImports(writer, clazz, allMethods, elements);
            this.doComment(writer, comment, 0);
            writer.write("message " + clazzSimpleName + " {\n");
            String currentOneOf = null;
            int indentLevel = 1;
            int number = 1;
            for (XmlElementInfo info : infos) {
                boolean incrementCount;
                String thisOneOf = info.getOneOf();
                if (!GeneralUtilities.safeEquals(currentOneOf, (Object)thisOneOf)) {
                    if (currentOneOf != null) {
                        PBufGeneratorProcessor.writeTab(writer);
                        writer.write("}\n");
                        indentLevel = 1;
                    }
                    if (thisOneOf != null) {
                        if (number > 1) {
                            PBufGeneratorProcessor.writeBlankLine(writer);
                        }
                        PBufGeneratorProcessor.writeTab(writer);
                        writer.write("oneof " + thisOneOf + " {\n");
                        indentLevel = 2;
                    }
                    currentOneOf = thisOneOf;
                }
                if (!(incrementCount = this.handleMethod(writer, info, number, indentLevel))) continue;
                ++number;
            }
            if (currentOneOf != null) {
                PBufGeneratorProcessor.writeTab(writer);
                writer.write("}\n");
            }
            writer.write("}\n");
            PBufGeneratorProcessor.writeBlankLine(writer);
        }
        catch (IOException ioe) {
            throw new MultiException((Throwable)ioe);
        }
    }

    private boolean handleMethod(Writer writer, XmlElementInfo info, int number, int indentLevel) throws IOException {
        PBufGeneratorProcessor.writeBlankLine(writer);
        this.doComment(writer, info.getComment(), indentLevel);
        for (int lcv = 0; lcv < indentLevel; ++lcv) {
            PBufGeneratorProcessor.writeTab(writer);
        }
        String translatedName = PBUtilities.camelCaseToUnderscore(info.getName());
        if (info.getChildInfo() == null) {
            writer.write(info.getType() + " " + translatedName + " = " + number);
        } else {
            if (info.getChildInfo().isRepeated()) {
                writer.write("repeated ");
            }
            writer.write(info.getChildInfo().getName() + " " + translatedName + " = " + number);
        }
        writer.write(";\n");
        return true;
    }

    private static ExecutableElement getFieldFromAnnotation(TypeElement annotation, String field) {
        List<? extends Element> elements = annotation.getEnclosedElements();
        for (Element element : elements) {
            ExecutableElement ee;
            String executableName;
            if (!(element instanceof ExecutableElement) || !field.equals(executableName = Utilities.convertNameToString((Name)(ee = (ExecutableElement)element).getSimpleName()))) continue;
            return ee;
        }
        return null;
    }

    private static String getDeclaredType(DeclaredType declaredType) {
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        String fullName = Utilities.convertNameToString((Name)typeElement.getQualifiedName());
        if (Boolean.class.getName().equals(fullName)) {
            return "bool";
        }
        if (Byte.class.getName().equals(fullName) || Short.class.getName().equals(fullName) || Integer.class.getName().equals(fullName)) {
            return "int32";
        }
        if (Long.class.getName().equals(fullName)) {
            return "int64";
        }
        if (Character.class.getName().equals(fullName) || String.class.getName().equals(fullName)) {
            return "string";
        }
        if (Float.class.getName().equals(fullName)) {
            return "float";
        }
        if (Double.class.getName().equals(fullName)) {
            return "double";
        }
        return "string";
    }

    private static String getPBufType(ExecutableElement method, TypeMirror mirror) {
        TypeKind kind = mirror.getKind();
        switch (kind) {
            case BOOLEAN: {
                return "bool";
            }
            case BYTE: 
            case SHORT: 
            case INT: {
                return "int32";
            }
            case LONG: {
                return "int64";
            }
            case CHAR: {
                return "string";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case DECLARED: {
                return PBufGeneratorProcessor.getDeclaredType((DeclaredType)mirror);
            }
            case ARRAY: {
                return "string";
            }
        }
        throw new AssertionError((Object)("Unknown getter has a unknown return type: " + kind + " for method " + method + " and mirror " + mirror));
    }

    private static boolean isSetter(ExecutableElement method) {
        String methodName = Utilities.convertNameToString((Name)method.getSimpleName());
        return methodName.startsWith("set") && methodName.length() > 3;
    }

    private static boolean isGetter(ExecutableElement method) {
        String methodName = Utilities.convertNameToString((Name)method.getSimpleName());
        if (methodName.startsWith("get") && methodName.length() > 3) {
            return true;
        }
        if (!methodName.startsWith("is")) {
            return false;
        }
        if (methodName.length() <= 2) {
            return false;
        }
        TypeMirror mirror = method.getReturnType();
        if (mirror.getKind().equals((Object)TypeKind.BOOLEAN)) {
            return true;
        }
        if (mirror.getKind().equals((Object)TypeKind.DECLARED)) {
            DeclaredType declared = (DeclaredType)mirror;
            TypeElement asElement = (TypeElement)declared.asElement();
            String elementName = Utilities.convertNameToString((Name)asElement.getQualifiedName());
            if (Boolean.class.getName().equals(elementName)) {
                return true;
            }
        }
        return false;
    }

    private static String getPBufType(ExecutableElement method) {
        String methodName = Utilities.convertNameToString((Name)method.getSimpleName());
        if (PBufGeneratorProcessor.isSetter(method)) {
            List<? extends VariableElement> parameters = method.getParameters();
            if (parameters.size() != 1) {
                throw new AssertionError((Object)("Unknown setter has more than one input parameter: " + methodName));
            }
            TypeMirror asType = parameters.get(0).asType();
            String retVal = PBufGeneratorProcessor.getPBufType(method, asType);
            return retVal;
        }
        if (PBufGeneratorProcessor.isGetter(method)) {
            TypeMirror type = method.getReturnType();
            if (type == null) {
                throw new AssertionError((Object)("Unknown getter does not have a return type: " + methodName));
            }
            String retVal = PBufGeneratorProcessor.getPBufType(method, type);
            return retVal;
        }
        throw new AssertionError((Object)("Cannot determing type as XmlElement not on a get or set method " + methodName));
    }

    private static String getRawFieldNameFromMethod(ExecutableElement method) {
        String simpleName = Utilities.convertNameToString((Name)method.getSimpleName());
        if (simpleName.startsWith("get") || simpleName.startsWith("set")) {
            return simpleName.substring(3);
        }
        if (simpleName.startsWith("is")) {
            return simpleName.substring(2);
        }
        throw new AssertionError((Object)("Unknown method name " + simpleName + " is neither a getter nor a setter"));
    }

    private static XmlElementInfo getXmlElementName(ExecutableElement method, Elements elements) {
        Comment commentAnnotation = method.getAnnotation(Comment.class);
        String comment = null;
        if (commentAnnotation != null) {
            comment = commentAnnotation.value();
        }
        OneOf oneOfAnnotation = method.getAnnotation(OneOf.class);
        String oneOf = null;
        if (oneOfAnnotation != null) {
            oneOf = oneOfAnnotation.value();
        }
        List<? extends AnnotationMirror> annotationMirrors = elements.getAllAnnotationMirrors(method);
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            ExecutableElement foundNameExecutable;
            TypeElement te;
            String mirrorTypeName;
            DeclaredType mirrorType = annotationMirror.getAnnotationType();
            Element e = mirrorType.asElement();
            if (!(e instanceof TypeElement) || !(mirrorTypeName = Utilities.convertNameToString((Name)(te = (TypeElement)e).getQualifiedName())).equals(XmlElement.class.getName()) && !mirrorTypeName.equals(XmlAttribute.class.getName())) continue;
            String type = PBufGeneratorProcessor.getPBufType(method);
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = elements.getElementValuesWithDefaults(annotationMirror);
            AnnotationValue av = values.get(foundNameExecutable = PBufGeneratorProcessor.getFieldFromAnnotation(te, "name"));
            if (av == null) {
                throw new AssertionError((Object)"The value of name must never be null");
            }
            String nameValue = null;
            String sValue = (String)av.getValue();
            if ("##default".equals(sValue)) {
                nameValue = PBufGeneratorProcessor.getRawFieldNameFromMethod(method);
                nameValue = Introspector.decapitalize(nameValue);
            } else {
                nameValue = sValue;
            }
            String sortField = PBufGeneratorProcessor.getRawFieldNameFromMethod(method);
            sortField = Introspector.decapitalize(sortField);
            return new XmlElementInfo(nameValue, type, sortField, comment, oneOf);
        }
        return null;
    }

    private static ChildInfo getChildName(ExecutableElement method) {
        DeclaredType dt;
        Element asElement;
        ElementKind elementKind;
        TypeMirror tm = method.getReturnType();
        TypeKind kind = tm.getKind();
        if (TypeKind.ARRAY.equals((Object)kind)) {
            DeclaredType dt2;
            Element asElement2;
            ElementKind elementKind2;
            ArrayType at = (ArrayType)tm;
            TypeMirror componentType = at.getComponentType();
            TypeKind componentKind = componentType.getKind();
            if (TypeKind.DECLARED.equals((Object)componentKind) && ElementKind.INTERFACE.equals((Object)(elementKind2 = (asElement2 = (dt2 = (DeclaredType)componentType).asElement()).getKind()))) {
                TypeElement interfaceElement = (TypeElement)asElement2;
                return new ChildInfo(Utilities.convertNameToString((Name)interfaceElement.getQualifiedName()), true);
            }
        } else if (TypeKind.DECLARED.equals((Object)kind) && ElementKind.INTERFACE.equals((Object)(elementKind = (asElement = (dt = (DeclaredType)tm).asElement()).getKind()))) {
            TypeElement possibleList = (TypeElement)asElement;
            String possibleListType = Utilities.convertNameToString((Name)possibleList.getQualifiedName());
            if (List.class.getName().equals(possibleListType)) {
                List<? extends TypeMirror> typeArguments = dt.getTypeArguments();
                if (typeArguments == null || typeArguments.isEmpty()) {
                    return null;
                }
                TypeMirror firstArgument = typeArguments.get(0);
                TypeKind firstTypeKind = firstArgument.getKind();
                if (TypeKind.DECLARED.equals((Object)firstTypeKind)) {
                    DeclaredType firstDT = (DeclaredType)firstArgument;
                    Element firstElement = firstDT.asElement();
                    ElementKind firstElementKind = firstElement.getKind();
                    if (!ElementKind.INTERFACE.equals((Object)firstElementKind)) {
                        return null;
                    }
                    TypeElement firstElementType = (TypeElement)firstElement;
                    return new ChildInfo(Utilities.convertNameToString((Name)firstElementType.getQualifiedName()), true);
                }
            } else {
                return new ChildInfo(possibleListType, false);
            }
        }
        return null;
    }

    private List<XmlElementInfo> doImports(Writer writer, TypeElement clazz, List<? extends Element> allMethods, Elements elements) throws IOException {
        XmlType xmlType;
        String clazzName = Utilities.convertNameToString((Name)clazz.getQualifiedName());
        boolean atLeastOne = false;
        ArrayList<XmlElementInfo> retVal = new ArrayList<XmlElementInfo>(allMethods.size());
        HashSet<CallSite> alreadyDone = new HashSet<CallSite>();
        for (Element element : allMethods) {
            ExecutableElement method;
            XmlElementInfo xmlElementName;
            if (!(element instanceof ExecutableElement) || (xmlElementName = PBufGeneratorProcessor.getXmlElementName(method = (ExecutableElement)element, elements)) == null) continue;
            retVal.add(xmlElementName);
            ChildInfo childName = PBufGeneratorProcessor.getChildName(method);
            if (childName == null) continue;
            xmlElementName.setChildInfo(childName);
            String importName = childName.getName().replace('.', '/') + ".proto";
            if (alreadyDone.contains(importName)) continue;
            alreadyDone.add((CallSite)((Object)importName));
            writer.write("import \"" + importName + "\";\n");
            atLeastOne = true;
        }
        if (atLeastOne) {
            PBufGeneratorProcessor.writeBlankLine(writer);
        }
        if ((xmlType = clazz.getAnnotation(XmlType.class)) == null) {
            return retVal;
        }
        String[] stringArray = xmlType.propOrder();
        ElementOrderer comparator = new ElementOrderer(stringArray, clazzName);
        TreeSet<XmlElementInfo> sortedMap = new TreeSet<XmlElementInfo>(comparator);
        sortedMap.addAll(retVal);
        ArrayList<XmlElementInfo> sortedRetVal = new ArrayList<XmlElementInfo>(retVal.size());
        sortedRetVal.addAll(sortedMap);
        return sortedRetVal;
    }

    private static final class XmlElementInfo {
        private final String name;
        private final String type;
        private ChildInfo childInfo;
        private final String sortField;
        private final String comment;
        private final String oneOf;

        private XmlElementInfo(String name, String type, String sortField, String comment, String oneOf) {
            this.name = name;
            this.type = type;
            this.sortField = sortField;
            this.comment = comment;
            this.oneOf = oneOf;
        }

        private String getName() {
            return this.name;
        }

        private String getType() {
            return this.type;
        }

        private void setChildInfo(ChildInfo info) {
            this.childInfo = info;
        }

        private ChildInfo getChildInfo() {
            return this.childInfo;
        }

        private String getSortField() {
            return this.sortField;
        }

        private String getComment() {
            return this.comment;
        }

        private String getOneOf() {
            return this.oneOf;
        }

        public int hashCode() {
            return this.sortField.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof XmlElementInfo)) {
                return false;
            }
            XmlElementInfo other = (XmlElementInfo)o;
            return other.sortField.equals(this.sortField);
        }
    }

    private static final class ChildInfo {
        private final String name;
        private final boolean repeated;

        private ChildInfo(String name, boolean repeated) {
            this.name = name;
            this.repeated = repeated;
        }

        private String getName() {
            return this.name;
        }

        private boolean isRepeated() {
            return this.repeated;
        }
    }

    private static final class ElementOrderer
    implements Comparator<XmlElementInfo> {
        private final Map<String, Integer> sorter = new HashMap<String, Integer>();
        private final String clazzName;

        private ElementOrderer(String[] order, String clazzName) {
            this.clazzName = clazzName;
            for (int lcv = 0; lcv < order.length; ++lcv) {
                this.sorter.put(order[lcv], lcv);
            }
        }

        @Override
        public int compare(XmlElementInfo o1, XmlElementInfo o2) {
            String o1SortField = o1.getSortField();
            String o2SortField = o2.getSortField();
            if (!this.sorter.containsKey(o1SortField)) {
                throw new AssertionError((Object)("XmlType must contain all XmlElement and XmlAttribute names, the name " + o1SortField + " was not found in XmlType on " + this.clazzName));
            }
            if (!this.sorter.containsKey(o2SortField)) {
                throw new AssertionError((Object)("XmlType must contain all XmlElement and XmlAttribute names, the name " + o1SortField + " was not found in XmlType on " + this.clazzName));
            }
            int o1Spot = this.sorter.get(o1SortField);
            int o2Spot = this.sorter.get(o2SortField);
            return o1Spot - o2Spot;
        }
    }
}

