/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.pbuf.internal;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import java.beans.Introspector;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.pbuf.internal.PBUtilities;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.internal.ChildDataModel;
import org.glassfish.hk2.xml.internal.ChildDescriptor;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.ModelImpl;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;
import org.glassfish.hk2.xml.spi.Model;
import org.glassfish.hk2.xml.spi.PreGenerationRequirement;
import org.glassfish.hk2.xml.spi.XmlServiceParser;

@Singleton
@Named(value="PBufXmlParser")
@Visibility(value=DescriptorVisibility.LOCAL)
public class PBufParser
implements XmlServiceParser {
    private final HashMap<Class<?>, Descriptors.Descriptor> allProtos = new HashMap();
    private final HashMap<Class<?>, Descriptors.EnumDescriptor> allEnums = new HashMap();
    @Inject
    @Named(value="PBufXmlParser")
    private IterableProvider<XmlService> xmlService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T parseRoot(Model rootModel, URI location, Unmarshaller.Listener listener, Map<String, Object> options) throws Exception {
        InputStream is = location.toURL().openStream();
        try {
            T t = this.parseRoot(rootModel, is, listener, options);
            return t;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T parseRoot(Model rootModel, InputStream input, Unmarshaller.Listener listener, Map<String, Object> options) throws Exception {
        DynamicMessage message;
        byte[] rawBytes;
        try {
            HashSet<Descriptors.FileDescriptor> protoFiles = new HashSet<Descriptors.FileDescriptor>();
            this.convertAllModels((ModelImpl)rootModel, protoFiles);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        boolean markSupported = input.markSupported();
        if (markSupported) {
            input.mark(Integer.MAX_VALUE);
        }
        boolean useLength = PBufParser.getPrependSize(options);
        int size = -1;
        if (useLength) {
            CodedInputStream cis;
            CodedInputStream usedCIS = PBufParser.getUsedInputStream(options);
            CodedInputStream codedInputStream = cis = usedCIS != null ? usedCIS : CodedInputStream.newInstance((InputStream)input);
            if (options != null) {
                options.put("PbufStream", new CISStreamCloser(cis));
            }
            try {
                size = cis.readInt32();
            }
            catch (InvalidProtocolBufferException ipbe) {
                MultiException me = new MultiException((Throwable)new EOFException());
                me.addError((Throwable)ipbe);
                throw me;
            }
            if (size <= 0) {
                throw new AssertionError((Object)("Invalid size of protocol buffer on the wire: " + size));
            }
            rawBytes = cis.readRawBytes(size);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                int readLength;
                byte[] buffer = new byte[1000];
                while ((readLength = input.read(buffer)) > 0) {
                    baos.write(buffer, 0, readLength);
                }
            }
            finally {
                baos.close();
            }
            rawBytes = baos.toByteArray();
        }
        try {
            message = this.internalUnmarshal((ModelImpl)rootModel, rawBytes);
        }
        catch (InvalidProtocolBufferException ipbe) {
            MultiException me = new MultiException((Throwable)ipbe);
            if (markSupported) {
                byte[] debugBytes;
                if (useLength) {
                    input.reset();
                    byte[] lengthBytes = PBufParser.getLengthBytes(input);
                    debugBytes = new byte[lengthBytes.length + rawBytes.length];
                    System.arraycopy(lengthBytes, 0, debugBytes, 0, lengthBytes.length);
                    System.arraycopy(rawBytes, 0, debugBytes, lengthBytes.length, rawBytes.length);
                } else {
                    debugBytes = rawBytes;
                }
                String inputAsString = GeneralUtilities.prettyPrintBytes((byte[])debugBytes);
                IllegalStateException ise = new IllegalStateException("Invalid protocol buffer:\n" + inputAsString);
                me.addError((Throwable)ise);
            }
            throw me;
        }
        XmlHk2ConfigurationBean retVal = this.parseDynamicMessage((ModelImpl)rootModel, null, message, listener);
        return (T)retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getLengthBytes(InputStream input) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int b = input.read();
            baos.write(b);
            if ((b & 0x80) == 0) {
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
        }
        finally {
            baos.close();
        }
        throw new IOException("Reached end of stream without an end to the length!");
    }

    public PreGenerationRequirement getPreGenerationRequirement() {
        return PreGenerationRequirement.MUST_PREGENERATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void marshal(OutputStream outputStream, XmlRootHandle<T> root, Map<String, Object> options) throws IOException {
        CodedOutputStream cos;
        Object rootObject = root.getRoot();
        if (rootObject == null) {
            return;
        }
        XmlHk2ConfigurationBean rootBean = (XmlHk2ConfigurationBean)rootObject;
        ModelImpl model = rootBean._getModel();
        try {
            HashSet<Descriptors.FileDescriptor> protoFiles = new HashSet<Descriptors.FileDescriptor>();
            this.convertAllModels(model, protoFiles);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        DynamicMessage dynamicMessage = this.internalMarshal(rootBean);
        int size = dynamicMessage.getSerializedSize();
        CodedOutputStream usedCos = PBufParser.getUsedOutputStream(options);
        CodedOutputStream codedOutputStream = cos = usedCos != null ? usedCos : CodedOutputStream.newInstance((OutputStream)outputStream);
        if (options != null) {
            options.put("PbufStream", new COSStreamCloser(cos));
        }
        boolean prependSize = PBufParser.getPrependSize(options);
        try {
            if (prependSize) {
                cos.writeInt32NoTag(size);
            }
            dynamicMessage.writeTo(cos);
        }
        finally {
            cos.flush();
        }
    }

    private XmlHk2ConfigurationBean parseDynamicMessage(ModelImpl model, XmlHk2ConfigurationBean parent, DynamicMessage message, Unmarshaller.Listener listener) throws IOException {
        BaseHK2JAXBBean bean = (BaseHK2JAXBBean)((XmlService)this.xmlService.get()).createBean(model.getOriginalInterfaceAsClass());
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        listener.beforeUnmarshal((Object)bean, (Object)parent);
        block5: for (Map.Entry entry : model.getAllChildrenDescriptors().entrySet()) {
            boolean fieldSet;
            Object value;
            QName qname = (QName)entry.getKey();
            ChildDescriptor childDescriptor = (ChildDescriptor)entry.getValue();
            String localPart = qname.getLocalPart();
            String protoPart = PBUtilities.camelCaseToUnderscore(localPart);
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(protoPart);
            if (fieldDescriptor == null) {
                throw new IOException("Unknown field " + protoPart + " in " + bean);
            }
            ChildDataModel childDataModel = childDescriptor.getChildDataModel();
            if (childDataModel != null) {
                boolean fieldSet2 = message.hasField(fieldDescriptor);
                if (!fieldSet2) continue;
                value = message.getField(fieldDescriptor);
                value = this.convertFieldForUnmarshal(value, childDataModel);
                bean._setProperty(qname, value);
                continue;
            }
            ParentedModel parentedNode = childDescriptor.getParentedModel();
            if (ChildType.DIRECT.equals((Object)parentedNode.getChildType()) && !(fieldSet = message.hasField(fieldDescriptor)) || (value = message.getField(fieldDescriptor)) == null) continue;
            DynamicMessage dynamicChild = null;
            XmlHk2ConfigurationBean child = null;
            int repeatedFieldCount = 0;
            switch (parentedNode.getChildType()) {
                case DIRECT: {
                    if (!(value instanceof DynamicMessage)) {
                        throw new AssertionError((Object)("Do not know how to handle a non-dynamic direct message " + value));
                    }
                    dynamicChild = (DynamicMessage)value;
                    child = this.parseDynamicMessage(parentedNode.getChildModel(), (XmlHk2ConfigurationBean)bean, dynamicChild, listener);
                    bean._setProperty(qname, (Object)child);
                    continue block5;
                }
                case LIST: {
                    repeatedFieldCount = message.getRepeatedFieldCount(fieldDescriptor);
                    ArrayList<XmlHk2ConfigurationBean> list = new ArrayList<XmlHk2ConfigurationBean>(repeatedFieldCount);
                    for (int lcv = 0; lcv < repeatedFieldCount; ++lcv) {
                        Object childBean = message.getRepeatedField(fieldDescriptor, lcv);
                        if (!(childBean instanceof DynamicMessage)) {
                            throw new AssertionError((Object)("Do not know how to handle a non-dynamic list message " + childBean));
                        }
                        dynamicChild = (DynamicMessage)childBean;
                        child = this.parseDynamicMessage(parentedNode.getChildModel(), (XmlHk2ConfigurationBean)bean, dynamicChild, listener);
                        list.add(child);
                    }
                    bean._setProperty(qname, list);
                    continue block5;
                }
                case ARRAY: {
                    ModelImpl childModel = parentedNode.getChildModel();
                    repeatedFieldCount = message.getRepeatedFieldCount(fieldDescriptor);
                    Object array = Array.newInstance(childModel.getOriginalInterfaceAsClass(), repeatedFieldCount);
                    for (int lcv = 0; lcv < repeatedFieldCount; ++lcv) {
                        Object childBean = message.getRepeatedField(fieldDescriptor, lcv);
                        if (!(childBean instanceof DynamicMessage)) {
                            throw new AssertionError((Object)("Do not know how to handle a non-dynamic array message " + childBean));
                        }
                        dynamicChild = (DynamicMessage)childBean;
                        child = this.parseDynamicMessage(parentedNode.getChildModel(), (XmlHk2ConfigurationBean)bean, dynamicChild, listener);
                        Array.set(array, lcv, child);
                    }
                    bean._setProperty(qname, array);
                    continue block5;
                }
            }
            throw new IOException("Unknown child type: " + parentedNode.getChildType());
        }
        listener.afterUnmarshal((Object)bean, (Object)parent);
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicMessage internalUnmarshal(ModelImpl model, byte[] bytes) throws Exception {
        Descriptors.Descriptor descriptor;
        Class originalAsClass = model.getOriginalInterfaceAsClass();
        String originalInterface = model.getOriginalInterface();
        String protoName = PBufParser.getSimpleName(originalInterface);
        HashMap<Class<?>, Descriptors.Descriptor> hashMap = this.allProtos;
        synchronized (hashMap) {
            descriptor = this.allProtos.get(originalAsClass);
        }
        if (descriptor == null) {
            throw new IOException("Unknown model: " + originalInterface + " with protoName=" + protoName);
        }
        DynamicMessage retVal = DynamicMessage.parseFrom((Descriptors.Descriptor)descriptor, (byte[])bytes);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> DynamicMessage internalMarshal(XmlHk2ConfigurationBean bean) throws IOException {
        Descriptors.Descriptor descriptor;
        Map blm = bean._getBeanLikeMap();
        ModelImpl model = bean._getModel();
        Class originalAsClass = model.getOriginalInterfaceAsClass();
        String originalInterface = model.getOriginalInterface();
        String protoName = PBufParser.getSimpleName(originalInterface);
        HashMap<Class<?>, Descriptors.Descriptor> hashMap = this.allProtos;
        synchronized (hashMap) {
            descriptor = this.allProtos.get(originalAsClass);
        }
        if (descriptor == null) {
            throw new IOException("Unknown model: " + originalInterface + " with protoName=" + protoName);
        }
        DynamicMessage.Builder retValBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        block8: for (Map.Entry allEntry : model.getAllChildrenDescriptors().entrySet()) {
            QName qname = (QName)allEntry.getKey();
            ChildDescriptor childDescriptor = (ChildDescriptor)allEntry.getValue();
            String localPart = qname.getLocalPart();
            String protoPart = PBUtilities.camelCaseToUnderscore(localPart);
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(protoPart);
            if (fieldDescriptor == null) {
                throw new IOException("Unknown field " + protoPart + " in " + bean);
            }
            ChildDataModel childDataModel = childDescriptor.getChildDataModel();
            if (childDataModel != null) {
                Class childType;
                Object value;
                Object convertedValue;
                if (!bean._isSet(localPart) || (convertedValue = this.convertFieldForMarshal(value = blm.get(localPart), childType = childDataModel.getChildTypeAsClass())) == null) continue;
                retValBuilder.setField(fieldDescriptor, convertedValue);
                continue;
            }
            ParentedModel parentedModel = childDescriptor.getParentedModel();
            switch (parentedModel.getChildType()) {
                case DIRECT: {
                    Object directValue = blm.get(localPart);
                    if (directValue == null) continue block8;
                    DynamicMessage subMessage = this.internalMarshal((XmlHk2ConfigurationBean)directValue);
                    retValBuilder.setField(fieldDescriptor, (Object)subMessage);
                    break;
                }
                case LIST: {
                    Object listValue = blm.get(localPart);
                    if (listValue == null) continue block8;
                    List asList = (List)listValue;
                    for (XmlHk2ConfigurationBean childBean : asList) {
                        DynamicMessage subMessage = this.internalMarshal(childBean);
                        retValBuilder.addRepeatedField(fieldDescriptor, (Object)subMessage);
                    }
                    continue block8;
                }
                case ARRAY: {
                    int count;
                    Object arrayValue = blm.get(localPart);
                    if (arrayValue == null || (count = Array.getLength(arrayValue)) <= 0) continue block8;
                    for (int lcv = 0; lcv < count; ++lcv) {
                        XmlHk2ConfigurationBean child = (XmlHk2ConfigurationBean)Array.get(arrayValue, lcv);
                        DynamicMessage subMessage = this.internalMarshal(child);
                        retValBuilder.addRepeatedField(fieldDescriptor, (Object)subMessage);
                    }
                    continue block8;
                }
                default: {
                    throw new AssertionError((Object)("Unknown child type: " + parentedModel.getChildType()));
                }
            }
        }
        return retValBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertAllModels(ModelImpl model, Set<Descriptors.FileDescriptor> protoFiles) throws Exception {
        HashMap<Class<?>, Descriptors.Descriptor> hashMap = this.allProtos;
        synchronized (hashMap) {
            Class modelClass = model.getOriginalInterfaceAsClass();
            Descriptors.Descriptor dd = this.allProtos.get(modelClass);
            if (dd != null) {
                protoFiles.add(dd.getFile());
                return;
            }
            for (ParentedModel pModel : model.getAllChildren()) {
                this.convertAllModels(pModel.getChildModel(), protoFiles);
            }
            dd = this.allProtos.get(modelClass);
            if (dd != null) {
                protoFiles.add(dd.getFile());
                return;
            }
            Descriptors.Descriptor converted = this.convertModelToDescriptor(model, protoFiles);
            protoFiles.add(converted.getFile());
            this.allProtos.put(modelClass, converted);
        }
    }

    private static DescriptorProtos.FieldDescriptorProto.Type convertChildDataModelToType(ChildDataModel cdm) {
        Class childClass = cdm.getChildTypeAsClass();
        if (childClass.equals(String.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING;
        }
        if (childClass.equals(Integer.TYPE) || childClass.equals(Integer.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32;
        }
        if (childClass.equals(Long.TYPE) || childClass.equals(Long.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64;
        }
        if (childClass.equals(Boolean.TYPE) || childClass.equals(Boolean.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL;
        }
        if (childClass.equals(Double.TYPE) || childClass.equals(Double.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE;
        }
        if (childClass.equals(Float.TYPE) || childClass.equals(Float.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT;
        }
        if (childClass.equals(Byte.TYPE) || childClass.equals(Byte.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES;
        }
        if (childClass.equals(Character.TYPE) || childClass.equals(Character.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING;
        }
        if (childClass.equals(Short.TYPE) || childClass.equals(Short.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32;
        }
        if (childClass.isEnum()) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_ENUM;
        }
        throw new AssertionError((Object)("Unknown type to convert " + childClass.getName()));
    }

    private static String getSimpleName(String dotDelimitedName) {
        int index = dotDelimitedName.lastIndexOf(46);
        if (index < 0) {
            return dotDelimitedName;
        }
        return dotDelimitedName.substring(index + 1);
    }

    private static String getPackageName(String dotDelimitedName) {
        int index = dotDelimitedName.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return dotDelimitedName.substring(0, index);
    }

    private static String getProtoNameFromModel(ModelImpl mi) {
        String originalInterface = mi.getOriginalInterface();
        String protoName = PBufParser.getSimpleName(originalInterface);
        return protoName;
    }

    private static String getPackageNameFromModel(ModelImpl mi) {
        String originalInterface = mi.getOriginalInterface();
        String packageName = PBufParser.getPackageName(originalInterface);
        return packageName;
    }

    private static String getXmlTypeValueFromMethodName(String methodName, Object source) {
        if (methodName == null) {
            throw new AssertionError((Object)("Do not know the method name of " + source));
        }
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        throw new IllegalStateException("Unknown method name pattern, not a get or a set or an is: " + methodName);
    }

    private static void validateXmlType(Class<?> originalInterface, Map<QName, ChildDescriptor> allChildren) {
        XmlType xmlType = originalInterface.getAnnotation(XmlType.class);
        if (xmlType == null) {
            throw new IllegalStateException("When using protocol buffers the XmlType MUST be on the interface.  The interface " + originalInterface.getName() + " does not have one");
        }
        String[] propOrder = xmlType.propOrder();
        HashSet<String> uniq = new HashSet<String>();
        for (String order : propOrder) {
            if (uniq.contains(order)) {
                throw new IllegalStateException("XmlType propOrder field on " + originalInterface.getName() + " has duplicate value " + order);
            }
            uniq.add(order);
        }
        HashSet<String> extras = new HashSet<String>();
        HashSet missing = new HashSet(uniq);
        for (ChildDescriptor cd : allChildren.values()) {
            String interfaceMethod;
            ChildDataModel cdm = cd.getChildDataModel();
            if (cdm != null) {
                interfaceMethod = PBufParser.getXmlTypeValueFromMethodName(cdm.getOriginalMethodName(), cdm);
            } else {
                ParentedModel pm = cd.getParentedModel();
                interfaceMethod = PBufParser.getXmlTypeValueFromMethodName(pm.getOriginalMethodName(), pm);
            }
            missing.remove(interfaceMethod);
            if (uniq.contains(interfaceMethod)) continue;
            extras.add(interfaceMethod);
        }
        if (!missing.isEmpty() || !extras.isEmpty()) {
            throw new IllegalStateException("On interface " + originalInterface.getName() + " the XmlType propOrder field had these extra fields " + missing + " or missing fields " + extras);
        }
    }

    private Descriptors.Descriptor convertModelToDescriptor(ModelImpl model, Set<Descriptors.FileDescriptor> knownFiles) throws Exception {
        Map allChildren = model.getAllChildrenDescriptors();
        String protoName = PBufParser.getProtoNameFromModel(model);
        String packageName = PBufParser.getPackageNameFromModel(model);
        DescriptorProtos.DescriptorProto.Builder builder = DescriptorProtos.DescriptorProto.newBuilder();
        builder.setName(protoName);
        Class originalInterface = model.getOriginalInterfaceAsClass();
        PBufParser.validateXmlType(originalInterface, allChildren);
        int oneOfNumber = 0;
        HashMap<String, Integer> oneOfToIndexMap = new HashMap<String, Integer>();
        String currentOneOf = null;
        int number = 1;
        for (Map.Entry entry : allChildren.entrySet()) {
            QName entryKey = (QName)entry.getKey();
            String localPart = entryKey.getLocalPart();
            ChildDescriptor childDescriptor = (ChildDescriptor)entry.getValue();
            String protoPart = PBUtilities.camelCaseToUnderscore(localPart);
            DescriptorProtos.FieldDescriptorProto.Builder fBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder().setName(protoPart);
            fBuilder.setNumber(number);
            ++number;
            ChildDataModel dataModel = childDescriptor.getChildDataModel();
            if (dataModel != null) {
                DescriptorProtos.FieldDescriptorProto.Type fieldType;
                fBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL);
                Class dataType = dataModel.getChildTypeAsClass();
                String originalMethodName = dataModel.getOriginalMethodName();
                String oneOfValue = PBUtilities.getOneOf(originalInterface, originalMethodName, dataType);
                if (GeneralUtilities.safeEquals((Object)oneOfValue, currentOneOf)) {
                    if (oneOfValue != null) {
                        int oneOfDeclIndex = (Integer)oneOfToIndexMap.get(oneOfValue);
                        fBuilder.setOneofIndex(oneOfDeclIndex);
                    }
                } else {
                    if (oneOfValue != null) {
                        DescriptorProtos.OneofDescriptorProto.Builder oneOfBuilder = DescriptorProtos.OneofDescriptorProto.newBuilder();
                        oneOfBuilder.setName(oneOfValue);
                        int oneOfIndex = oneOfNumber++;
                        builder.addOneofDecl(oneOfIndex, oneOfBuilder.build());
                        oneOfToIndexMap.put(oneOfValue, oneOfIndex);
                        fBuilder.setOneofIndex(oneOfIndex);
                    }
                    currentOneOf = oneOfValue;
                }
                if (dataModel.getDefaultAsString() != null) {
                    fBuilder.setDefaultValue(dataModel.getDefaultAsString());
                }
                if (DescriptorProtos.FieldDescriptorProto.Type.TYPE_ENUM.equals((Object)(fieldType = PBufParser.convertChildDataModelToType(dataModel)))) {
                    String fieldTypeName = this.convertEnumToDescriptor(dataModel, knownFiles);
                    fBuilder.setTypeName(fieldTypeName);
                }
                fBuilder.setType(fieldType);
            } else {
                ParentedModel pm = childDescriptor.getParentedModel();
                fBuilder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE);
                Class childDataType = pm.getChildModel().getOriginalInterfaceAsClass();
                String originalMethodName = pm.getOriginalMethodName();
                String oneOfValue = PBUtilities.getOneOf(originalInterface, originalMethodName, childDataType);
                if (GeneralUtilities.safeEquals((Object)oneOfValue, currentOneOf)) {
                    if (oneOfValue != null) {
                        int oneOfDeclIndex = (Integer)oneOfToIndexMap.get(oneOfValue);
                        fBuilder.setOneofIndex(oneOfDeclIndex);
                    }
                } else {
                    if (oneOfValue != null) {
                        DescriptorProtos.OneofDescriptorProto.Builder oneOfBuilder = DescriptorProtos.OneofDescriptorProto.newBuilder();
                        oneOfBuilder.setName(oneOfValue);
                        int oneOfIndex = oneOfNumber++;
                        builder.addOneofDecl(oneOfIndex, oneOfBuilder.build());
                        oneOfToIndexMap.put(oneOfValue, oneOfIndex);
                        fBuilder.setOneofIndex(oneOfIndex);
                    }
                    currentOneOf = oneOfValue;
                }
                ModelImpl childModel = pm.getChildModel();
                String childTypeName = childModel.getOriginalInterface();
                fBuilder.setTypeName("." + childTypeName);
                ChildType childType = pm.getChildType();
                if (childType.equals((Object)ChildType.ARRAY) || childType.equals((Object)ChildType.LIST)) {
                    fBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED);
                } else {
                    fBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL);
                }
            }
            builder.addField(fBuilder.build());
        }
        DescriptorProtos.DescriptorProto proto = builder.build();
        DescriptorProtos.FileDescriptorProto.Builder fileBuilder = DescriptorProtos.FileDescriptorProto.newBuilder();
        fileBuilder.addMessageType(proto);
        if (packageName != null) {
            fileBuilder.setPackage(packageName);
        }
        DescriptorProtos.FileDescriptorProto fProto = fileBuilder.build();
        Descriptors.FileDescriptor fDesc = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fProto, (Descriptors.FileDescriptor[])knownFiles.toArray(new Descriptors.FileDescriptor[knownFiles.size()]));
        Descriptors.Descriptor fD = fDesc.findMessageTypeByName(protoName);
        return fD;
    }

    private static String getExtendedSimpleName(Class<?> expectedType) {
        String name = expectedType.getName();
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return name;
        }
        String retVal = name.substring(index + 1);
        retVal = retVal.replace('$', '_');
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertEnumToDescriptor(ChildDataModel childDataModel, Set<Descriptors.FileDescriptor> knownFiles) throws Exception {
        HashMap<Class<?>, Descriptors.EnumDescriptor> hashMap = this.allEnums;
        synchronized (hashMap) {
            Class expectedType = childDataModel.getChildTypeAsClass();
            if (this.allEnums.containsKey(expectedType)) {
                return "." + expectedType.getName();
            }
            String enumSimpleTypeName = PBufParser.getExtendedSimpleName(expectedType);
            String enumPackageName = expectedType.getPackage().getName();
            String enumTypeName = enumPackageName + "." + enumSimpleTypeName;
            DescriptorProtos.EnumDescriptorProto.Builder builder = DescriptorProtos.EnumDescriptorProto.newBuilder();
            builder.setName(enumSimpleTypeName);
            int number = 0;
            for (Object e : expectedType.getEnumConstants()) {
                DescriptorProtos.EnumValueDescriptorProto.Builder enumBuilder = DescriptorProtos.EnumValueDescriptorProto.newBuilder();
                enumBuilder.setName(e.toString());
                enumBuilder.setNumber(number);
                ++number;
                builder.addValue(enumBuilder.build());
            }
            DescriptorProtos.EnumDescriptorProto eProto = builder.build();
            DescriptorProtos.FileDescriptorProto.Builder fileBuilder = DescriptorProtos.FileDescriptorProto.newBuilder();
            fileBuilder.addEnumType(eProto);
            if (enumPackageName != null) {
                fileBuilder.setPackage(enumPackageName);
            }
            DescriptorProtos.FileDescriptorProto fProto = fileBuilder.build();
            Descriptors.FileDescriptor fDesc = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fProto, (Descriptors.FileDescriptor[])knownFiles.toArray(new Descriptors.FileDescriptor[knownFiles.size()]));
            knownFiles.add(fDesc);
            Descriptors.EnumDescriptor fD = fDesc.findEnumTypeByName(enumSimpleTypeName);
            this.allEnums.put(expectedType, fD);
            return "." + enumTypeName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object convertFieldForMarshal(Object field, Class<?> expectedType) {
        if (field == null) {
            if (String.class.equals(expectedType)) {
                return new String("");
            }
            return null;
        }
        if (expectedType.isEnum()) {
            Descriptors.EnumDescriptor enumDescriptor;
            HashMap<Class<?>, Descriptors.EnumDescriptor> hashMap = this.allEnums;
            synchronized (hashMap) {
                enumDescriptor = this.allEnums.get(expectedType);
            }
            if (enumDescriptor == null) {
                throw new IllegalStateException("Unknown enum type " + expectedType.getName());
            }
            Descriptors.EnumValueDescriptor retVal = enumDescriptor.findValueByName(field.toString());
            if (retVal == null) {
                throw new IllegalStateException("Unknown enum value " + field + " in enumeration " + expectedType.getName());
            }
            return retVal;
        }
        if (field instanceof Short) {
            Short s = (Short)field;
            return new Integer(s.intValue());
        }
        if (field instanceof Character) {
            Character c = (Character)field;
            return new String(c.toString());
        }
        if (field instanceof Byte) {
            Byte b = (Byte)field;
            byte[] retVal = new byte[]{b};
            return retVal;
        }
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object convertFieldForUnmarshal(Object field, ChildDataModel expected) {
        if (field == null) {
            return null;
        }
        Class expectedType = expected.getChildTypeAsClass();
        if (expectedType.isEnum()) {
            Descriptors.EnumDescriptor enumDescriptor;
            HashMap<Class<?>, Descriptors.EnumDescriptor> hashMap = this.allEnums;
            synchronized (hashMap) {
                enumDescriptor = this.allEnums.get(expectedType);
            }
            if (enumDescriptor == null) {
                throw new IllegalStateException("Could not find enumeration type " + expectedType.getName());
            }
            Descriptors.EnumValueDescriptor evd = (Descriptors.EnumValueDescriptor)field;
            String enumValueName = evd.getName();
            Object found = null;
            for (Object c : expectedType.getEnumConstants()) {
                if (!c.toString().equals(enumValueName)) continue;
                found = c;
                break;
            }
            if (found == null) {
                throw new IllegalStateException("Could not find enumeration value " + enumValueName + " in enum " + expectedType.getName());
            }
            return found;
        }
        if (expectedType.equals(Short.TYPE) || expectedType.equals(Short.class)) {
            Integer i = (Integer)field;
            return i.shortValue();
        }
        if (expectedType.equals(Character.TYPE) || expectedType.equals(Character.class)) {
            String s = (String)field;
            return Character.valueOf(s.charAt(0));
        }
        if (expectedType.equals(Byte.TYPE) || expectedType.equals(Byte.class)) {
            ByteString b = (ByteString)field;
            return b.byteAt(0);
        }
        if (String.class.equals((Object)expectedType) && ((String)field).isEmpty()) {
            return null;
        }
        return field;
    }

    private static CodedInputStream getUsedInputStream(Map<String, Object> options) {
        if (options == null) {
            return null;
        }
        CISStreamCloser retVal = (CISStreamCloser)options.get("PbufStream");
        if (retVal == null) {
            return null;
        }
        return retVal.stream;
    }

    private static CodedOutputStream getUsedOutputStream(Map<String, Object> options) {
        if (options == null) {
            return null;
        }
        COSStreamCloser retVal = (COSStreamCloser)options.get("PbufStream");
        if (retVal == null) {
            return null;
        }
        return retVal.stream;
    }

    private static boolean getPrependSize(Map<String, Object> options) {
        if (options == null) {
            return true;
        }
        Boolean val = (Boolean)options.get("PbufInt32Header");
        if (val == null) {
            return true;
        }
        return val;
    }

    public String toString() {
        return "PBufParser(" + System.identityHashCode(this) + ")";
    }

    private static class COSStreamCloser
    implements AutoCloseable {
        private final CodedOutputStream stream;

        private COSStreamCloser(CodedOutputStream stream) {
            this.stream = stream;
        }

        @Override
        public void close() throws Exception {
        }
    }

    private static class CISStreamCloser
    implements AutoCloseable {
        private final CodedInputStream stream;

        private CISStreamCloser(CodedInputStream stream) {
            this.stream = stream;
        }

        @Override
        public void close() throws Exception {
        }
    }
}

