/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.pbuf.internal;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.hk2.pbuf.api.annotations.OneOf;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.MethodWrapper;
import org.glassfish.hk2.utilities.reflection.internal.ClassReflectionHelperImpl;

public class PBUtilities {
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String SET = "set";
    private static final ClassReflectionHelper reflectionHelper = new ClassReflectionHelperImpl();

    public static String getOneOf(Class<?> oInterface, String methodName, Class<?> type) {
        Set<Method> allNamed = PBUtilities.getAllMethodsWithName(oInterface, methodName);
        if (allNamed.isEmpty()) {
            throw new AssertionError((Object)("Could not find method " + methodName + " on bean " + oInterface.getName()));
        }
        if (allNamed.size() == 1) {
            Method method = allNamed.iterator().next();
            OneOf oneOf = method.getAnnotation(OneOf.class);
            if (oneOf == null) {
                return null;
            }
            return oneOf.value();
        }
        Method found = null;
        if (PBUtilities.isGetter(methodName)) {
            for (Method m : allNamed) {
                Class<?>[] allParams;
                Class<?> retType = m.getReturnType();
                if (!retType.equals(type) || (allParams = m.getParameterTypes()) != null && allParams.length != 0) continue;
                found = m;
                break;
            }
        } else if (PBUtilities.isSetter(methodName)) {
            for (Method m : allNamed) {
                Class<?>[] allParams;
                Class<?> retType = m.getReturnType();
                if (!Void.TYPE.equals(retType) || (allParams = m.getParameterTypes()) == null || allParams.length != 1 || !allParams[0].equals(type)) continue;
                found = m;
                break;
            }
        } else {
            throw new AssertionError((Object)("Unable to analyze a method that is neiter a getter or a setter: " + methodName + " on " + oInterface.getName()));
        }
        if (found == null) {
            throw new AssertionError((Object)("Could not find method " + methodName + " on bean " + oInterface.getName() + " with type " + type.getName()));
        }
        OneOf oneOf = found.getAnnotation(OneOf.class);
        if (oneOf == null) {
            return null;
        }
        return oneOf.value();
    }

    private static boolean isGetter(String methodName) {
        if (methodName.startsWith(GET) && methodName.length() > 3) {
            return true;
        }
        return methodName.startsWith(IS) && methodName.length() > 2;
    }

    private static boolean isSetter(String methodName) {
        return methodName.startsWith(SET) && methodName.length() > 3;
    }

    private static Set<Method> getAllMethodsWithName(Class<?> oInterface, String methodName) {
        HashSet<Method> retVal = new HashSet<Method>();
        Set allMethods = reflectionHelper.getAllMethods(oInterface);
        for (MethodWrapper wrapper : allMethods) {
            if (!methodName.equals(wrapper.getMethod().getName())) continue;
            retVal.add(wrapper.getMethod());
        }
        return retVal;
    }

    public static String camelCaseToUnderscore(String camelCase) {
        StringBuffer sb = new StringBuffer();
        char oneBackCache = '\u0000';
        boolean firstAlreadyWritten = false;
        boolean previousLowerCase = false;
        for (int lcv = 0; lcv < camelCase.length(); ++lcv) {
            char charAt = camelCase.charAt(lcv);
            if (Character.isUpperCase(charAt)) {
                charAt = Character.toLowerCase(charAt);
                if (oneBackCache != '\u0000') {
                    if (firstAlreadyWritten && previousLowerCase) {
                        sb.append("_");
                    }
                    sb.append(oneBackCache);
                    firstAlreadyWritten = true;
                    previousLowerCase = false;
                }
                oneBackCache = charAt;
                continue;
            }
            if (oneBackCache != '\u0000') {
                if (firstAlreadyWritten) {
                    sb.append("_");
                    firstAlreadyWritten = true;
                }
                sb.append(oneBackCache);
                firstAlreadyWritten = true;
                oneBackCache = '\u0000';
            }
            sb.append(charAt);
            firstAlreadyWritten = true;
            previousLowerCase = true;
        }
        if (oneBackCache != '\u0000') {
            if (firstAlreadyWritten && previousLowerCase) {
                sb.append("_");
            }
            sb.append(oneBackCache);
        }
        return sb.toString();
    }
}

