/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.testing.hk2mockito.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.ServiceHandle;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.internal.Utilities;
import org.jvnet.testing.hk2mockito.HK2MockitoInjectionResolver;
import org.jvnet.testing.hk2mockito.MC;
import org.jvnet.testing.hk2mockito.SC;
import org.jvnet.testing.hk2mockito.SUT;
import org.jvnet.testing.hk2mockito.internal.MockitoCacheKey;
import org.jvnet.testing.hk2mockito.internal.ObjectFactory;
import org.jvnet.testing.hk2mockito.internal.cache.MemberCache;
import org.jvnet.testing.hk2mockito.internal.cache.ParentCache;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@Service
public class MockitoService {
    private final MemberCache memberCache;
    private final ParentCache parentCache;
    private final ObjectFactory objectFactory;
    private final IterableProvider<InjectionResolver> resolvers;
    private final InjectionResolver<Inject> systemResolver;

    @Inject
    MockitoService(MemberCache memberCache, ParentCache parentCache, ObjectFactory objectFactory, IterableProvider<InjectionResolver> resolvers, @Named(value="SystemInjectResolver") InjectionResolver<Inject> systemResolver) {
        this.memberCache = memberCache;
        this.parentCache = parentCache;
        this.objectFactory = objectFactory;
        this.resolvers = resolvers;
        this.systemResolver = systemResolver;
    }

    private Object resolve(Injectee injectee, ServiceHandle<?> root) {
        Member member = (Member)((Object)injectee.getParent());
        Class<?> parentType = member.getDeclaringClass();
        if (InjectionResolver.class.isAssignableFrom(parentType)) {
            return this.systemResolver.resolve(injectee, root);
        }
        for (InjectionResolver resolver : this.resolvers) {
            Object service;
            if (resolver instanceof HK2MockitoInjectionResolver || (service = resolver.resolve(injectee, root)) == null) continue;
            return service;
        }
        return null;
    }

    public Object findOrCreateSUT(Injectee injectee, ServiceHandle<?> root) {
        Member member = (Member)((Object)injectee.getParent());
        Type requiredType = injectee.getRequiredType();
        Class<?> parentType = member.getDeclaringClass();
        Map<MockitoCacheKey, Object> cache = this.primeCache(parentType, root);
        MockitoCacheKey key = this.objectFactory.newKey(requiredType, member.getName());
        return cache.get(key);
    }

    public Object createOrFindService(Injectee injectee, ServiceHandle<?> root) {
        Object service;
        Member member = (Member)((Object)injectee.getParent());
        Class<?> parentType = member.getDeclaringClass();
        Type requiredType = injectee.getRequiredType();
        Type serviceParent = this.parentCache.get(parentType);
        if (serviceParent == null) {
            return this.resolve(injectee, root);
        }
        Type grandParent = this.parentCache.get(serviceParent);
        while (grandParent != null) {
            serviceParent = grandParent;
            grandParent = this.parentCache.get(serviceParent);
        }
        Map<MockitoCacheKey, Object> cache = this.memberCache.get(serviceParent);
        if (cache == null) {
            return this.resolve(injectee, root);
        }
        if (member instanceof Field) {
            MockitoCacheKey key = this.objectFactory.newKey(requiredType, member.getName());
            service = cache.get(key);
        } else {
            MockitoCacheKey key = this.objectFactory.newKey(requiredType, injectee.getPosition());
            service = cache.get(key);
            if (service == null) {
                key = this.objectFactory.newKey(requiredType, -1);
                service = cache.get(key);
            }
        }
        if (service == null) {
            service = this.resolve(injectee, root);
        }
        return service;
    }

    public Object findOrCreateCollaborator(int position, String fieldName, Injectee injectee, ServiceHandle<?> root) {
        Member member = (Member)((Object)injectee.getParent());
        Class<?> parentType = member.getDeclaringClass();
        Type requiredType = injectee.getRequiredType();
        Map<MockitoCacheKey, Object> cache = this.primeCache(parentType, root);
        MockitoCacheKey key = member instanceof Field && position >= 0 ? this.objectFactory.newKey(requiredType, position) : this.objectFactory.newKey(requiredType, this.getOrDefault(fieldName, member.getName()));
        return cache.get(key);
    }

    private Map<MockitoCacheKey, Object> primeCache(Class type, ServiceHandle<?> root) {
        String name;
        Field[] fields;
        Map<MockitoCacheKey, Object> cache = this.memberCache.get(type);
        if (cache != null) {
            return cache;
        }
        cache = this.memberCache.add(type);
        for (Field field : fields = AccessController.doPrivileged(type::getDeclaredFields)) {
            name = field.getName();
            Class<?> fieldClass = field.getType();
            Type fieldType = field.getGenericType();
            SUT sut = field.getAnnotation(SUT.class);
            SC sc = field.getAnnotation(SC.class);
            MC mc = field.getAnnotation(MC.class);
            if (sut != null || sc != null || mc != null) {
                this.parentCache.put(fieldType, type);
            }
            if (sc != null) {
                List injectees = Utilities.getFieldInjectees((Class)type, (Field)field, null);
                Object service = this.resolve((Injectee)injectees.get(0), root);
                if (service == null) continue;
                MockitoCacheKey executableKey = this.objectFactory.newKey(fieldType, sc.value());
                MockitoCacheKey fieldKey = this.objectFactory.newKey(fieldType, this.getOrDefault(sc.field(), name));
                Object spy = this.objectFactory.newSpy(service);
                cache.put(executableKey, spy);
                cache.put(fieldKey, spy);
                continue;
            }
            if (mc == null) continue;
            MockSettings settings = Mockito.withSettings().name(this.getOrDefault(mc.name(), name)).defaultAnswer((Answer)mc.answer());
            Class[] interfaces = mc.extraInterfaces();
            if (interfaces.length > 0) {
                settings.extraInterfaces(interfaces);
            }
            Object service = this.objectFactory.newMock(fieldClass, settings);
            MockitoCacheKey executableKey = this.objectFactory.newKey(fieldClass, mc.value());
            MockitoCacheKey fieldKey = this.objectFactory.newKey(fieldClass, this.getOrDefault(mc.field(), name));
            cache.put(executableKey, service);
            cache.put(fieldKey, service);
        }
        for (Field field : fields) {
            name = field.getName();
            Type fieldType = field.getGenericType();
            SUT sut = field.getAnnotation(SUT.class);
            if (sut == null) continue;
            List injectees = Utilities.getFieldInjectees((Class)type, (Field)field, null);
            Object service = this.resolve((Injectee)injectees.get(0), root);
            if (sut.value()) {
                service = this.objectFactory.newSpy(service);
            }
            MockitoCacheKey fieldKey = this.objectFactory.newKey(fieldType, name);
            cache.put(fieldKey, service);
        }
        return cache;
    }

    private String getOrDefault(String value, String defaultValue) {
        if ("".equals(value)) {
            return defaultValue;
        }
        return value;
    }
}

