/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.testing.hk2mockito.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.internal.Utilities;
import org.jvnet.testing.hk2mockito.HK2MockitoInjectionResolver;
import org.jvnet.testing.hk2mockito.MC;
import org.jvnet.testing.hk2mockito.SC;
import org.jvnet.testing.hk2mockito.SUT;
import org.jvnet.testing.hk2mockito.internal.MockitoCacheKey;
import org.jvnet.testing.hk2mockito.internal.ObjectFactory;
import org.jvnet.testing.hk2mockito.internal.cache.MemberCache;
import org.jvnet.testing.hk2mockito.internal.cache.ParentCache;
import org.mockito.MockSettings;
import org.mockito.Mockito;

@Service
public class MockitoService {
    private final MemberCache memberCache;
    private final ParentCache parentCache;
    private final ObjectFactory objectFactory;
    private final IterableProvider<InjectionResolver> resolvers;
    private final InjectionResolver<Inject> systemResolver;
    private final ServiceLocator locator;
    private Class sut;

    @Inject
    MockitoService(MemberCache memberCache, ParentCache parentCache, ObjectFactory objectFactory, ServiceLocator locator, IterableProvider<InjectionResolver> resolvers, @Named(value="SystemInjectResolver") InjectionResolver systemResolver) {
        this.memberCache = memberCache;
        this.parentCache = parentCache;
        this.objectFactory = objectFactory;
        this.locator = locator;
        this.resolvers = resolvers;
        this.systemResolver = systemResolver;
    }

    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        Member member = (Member)((Object)injectee.getParent());
        Class<?> parentType = member.getDeclaringClass();
        if (InjectionResolver.class.isAssignableFrom(parentType)) {
            return this.systemResolver.resolve(injectee, root);
        }
        for (InjectionResolver resolver : this.resolvers) {
            Object service;
            if (resolver instanceof HK2MockitoInjectionResolver || (service = resolver.resolve(injectee, root)) == null) continue;
            return service;
        }
        return null;
    }

    public Object findOrCreateSUT(SUT sut, Injectee injectee, ServiceHandle<?> root) {
        this.sut = (Class)injectee.getRequiredType();
        Member member = (Member)((Object)injectee.getParent());
        Class<?> parentType = member.getDeclaringClass();
        this.primeCache(parentType);
        Object service = sut.value() ? this.objectFactory.newSpy(this.resolve(injectee, root)) : this.resolve(injectee, root);
        return service;
    }

    public Object createOrFindService(Injectee injectee, ServiceHandle<?> root) {
        Member member = (Member)((Object)injectee.getParent());
        Class<?> parentType = member.getDeclaringClass();
        Type requiredType = injectee.getRequiredType();
        Object service = this.resolve(injectee, root);
        Type serviceParent = this.parentCache.get(parentType);
        if (serviceParent == null) {
            return service;
        }
        Map<MockitoCacheKey, Object> cache = this.memberCache.get(serviceParent);
        if (cache == null) {
            return service;
        }
        MockitoCacheKey key = member instanceof Field ? this.objectFactory.newKey(requiredType, member.getName()) : this.objectFactory.newKey(requiredType, injectee.getPosition());
        service = cache.get(key);
        if (service == null) {
            service = this.resolve(injectee, root);
        }
        return service;
    }

    public Object findOrCreateCollaborator(int position, String fieldName, Injectee injectee, ServiceHandle<?> root) {
        Member member = (Member)((Object)injectee.getParent());
        Class<?> parentType = member.getDeclaringClass();
        Type requiredType = injectee.getRequiredType();
        Map<MockitoCacheKey, Object> cache = this.primeCache(parentType);
        MockitoCacheKey key = member instanceof Field ? this.objectFactory.newKey(requiredType, position) : this.objectFactory.newKey(requiredType, this.getFieldName(fieldName, member.getName()));
        return cache.get(key);
    }

    private Map<MockitoCacheKey, Object> primeCache(final Class type) {
        Field[] fields;
        Map<MockitoCacheKey, Object> cache = this.memberCache.get(type);
        if (cache != null) {
            return cache;
        }
        cache = this.memberCache.add(type);
        for (Field field : fields = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return type.getDeclaredFields();
            }
        })) {
            String name = field.getName();
            Class<?> fieldClass = field.getType();
            Type fieldType = field.getGenericType();
            SC sc = field.getAnnotation(SC.class);
            MC mc = field.getAnnotation(MC.class);
            if (sc != null) {
                List injectees = Utilities.getFieldInjectees((Class)type, (Field)field, null);
                Object service = this.resolve((Injectee)injectees.get(0), null);
                if (service == null) continue;
                MockitoCacheKey executableKey = this.objectFactory.newKey(fieldType, sc.value());
                MockitoCacheKey fieldKey = this.objectFactory.newKey(fieldType, this.getFieldName(sc.field(), name));
                Object spy = this.objectFactory.newSpy(service);
                cache.put(executableKey, spy);
                cache.put(fieldKey, spy);
                continue;
            }
            if (mc == null) continue;
            Class<?>[] interfaces = mc.extraInterfaces();
            String mockName = mc.name();
            if ("".equals(mockName)) {
                mockName = name;
            }
            MockSettings settings = Mockito.withSettings().name(mockName).defaultAnswer(mc.answer().get());
            if (interfaces != null && interfaces.length > 0) {
                settings.extraInterfaces((Class[])mc.extraInterfaces());
            }
            Object service = this.objectFactory.newMock(fieldClass, settings);
            MockitoCacheKey executableKey = this.objectFactory.newKey(fieldClass, mc.value());
            MockitoCacheKey fieldKey = this.objectFactory.newKey(fieldClass, this.getFieldName(mc.field(), name));
            cache.put(executableKey, service);
            cache.put(fieldKey, service);
        }
        return cache;
    }

    private String getFieldName(String fieldName, String defaultName) {
        if ("".equals(fieldName)) {
            return defaultName;
        }
        return fieldName;
    }
}

