/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.testing.hk2mockito;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import javax.inject.Inject;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.Rank;
import org.glassfish.hk2.api.ServiceHandle;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.testing.hk2mockito.SC;
import org.jvnet.testing.hk2mockito.SUT;
import org.jvnet.testing.hk2mockito.internal.ParentCache;
import org.jvnet.testing.hk2mockito.internal.SpyService;

@Rank(value=100)
@Service
public class HK2MockitoSpyInjectionResolver
implements InjectionResolver<Inject> {
    private final SpyService spyService;
    private final ParentCache parentCache;

    @Inject
    HK2MockitoSpyInjectionResolver(SpyService spyService, ParentCache parentCache) {
        this.spyService = spyService;
        this.parentCache = parentCache;
    }

    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        AnnotatedElement parent = injectee.getParent();
        Member member = (Member)((Object)parent);
        Type requiredType = injectee.getRequiredType();
        Class<?> parentType = member.getDeclaringClass();
        SUT sut = parent.getAnnotation(SUT.class);
        SC sc = parent.getAnnotation(SC.class);
        this.parentCache.put(requiredType, parentType);
        Object service = sut != null ? this.spyService.findOrCreateSUT(injectee, root) : (sc != null ? this.spyService.findOrCreateSC(sc, injectee, root) : this.spyService.createOrFindService(injectee, root));
        return service;
    }

    public boolean isConstructorParameterIndicator() {
        return false;
    }

    public boolean isMethodParameterIndicator() {
        return false;
    }
}

