/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.stub.generator;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.inject.Named;
import javax.inject.Scope;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.metadata.generator.ServiceUtilities;
import org.glassfish.hk2.utilities.Stub;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.jvnet.hk2.annotations.ContractsProvided;

@SupportedAnnotationTypes(value={"org.glassfish.hk2.utilities.Stub"})
public class StubProcessor
extends AbstractProcessor {
    private static final String NAMED_ANNO = Named.class.getName();
    private static final String EXCEPTIONS = "EXCEPTIONS";
    private static final String PROVIDED_ANNO = ContractsProvided.class.getName();
    private static final String STUB_EXTENSION = "_hk2Stub";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        MultiException me = null;
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> clazzes = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : clazzes) {
                if (!(element instanceof TypeElement)) continue;
                TypeElement clazz = (TypeElement)element;
                try {
                    this.writeStub(clazz);
                }
                catch (IOException ioe) {
                    if (me == null) {
                        me = new MultiException((Throwable)ioe);
                        continue;
                    }
                    me.addError((Throwable)ioe);
                }
            }
        }
        if (me != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, me.getMessage());
            me.printStackTrace();
            return true;
        }
        return true;
    }

    private static boolean isScopeAnnotation(AnnotationMirror annotation) {
        DeclaredType dt = annotation.getAnnotationType();
        TypeElement asElement = (TypeElement)dt.asElement();
        Scope scope = asElement.getAnnotation(Scope.class);
        return scope != null;
    }

    private void getAllGenericMappings(TypeElement clazz, Map<String, Map<String, String>> retVal, Map<String, String> subclassMap) {
        Types types = this.processingEnv.getTypeUtils();
        TypeMirror clazzTypeMirror = clazz.asType();
        List<? extends TypeMirror> extendList = types.directSupertypes(clazzTypeMirror);
        for (TypeMirror typeMirror : extendList) {
            if (!TypeKind.DECLARED.equals((Object)typeMirror.getKind())) continue;
            DeclaredType dt = (DeclaredType)typeMirror;
            List<? extends TypeMirror> mirrorTypes = dt.getTypeArguments();
            TypeElement te = (TypeElement)dt.asElement();
            String extenderName = ServiceUtilities.nameToString(te.getQualifiedName());
            if (Object.class.getName().equals(extenderName) || retVal.containsKey(extenderName)) continue;
            HashMap<String, String> typeParamToTypeMap = new HashMap<String, String>();
            retVal.put(extenderName, typeParamToTypeMap);
            List<? extends TypeParameterElement> typeParameters = te.getTypeParameters();
            if (mirrorTypes.size() != typeParameters.size()) {
                throw new AssertionError((Object)("The mirror types and parameter types of " + te.getQualifiedName() + " should match, they are " + mirrorTypes.size() + " and " + typeParameters.size()));
            }
            for (int lcv = 0; lcv < typeParameters.size(); ++lcv) {
                TypeMirror mirror = mirrorTypes.get(lcv);
                TypeParameterElement typeParameter = typeParameters.get(lcv);
                String typeParameterName = ServiceUtilities.nameToString(typeParameter.getSimpleName());
                String typeName = StubProcessor.getTypeName(mirror, subclassMap);
                typeParamToTypeMap.put(typeParameterName, typeName);
            }
            this.getAllGenericMappings(te, retVal, typeParamToTypeMap);
        }
    }

    private static boolean hasTypeParameters(TypeElement clazz) {
        List<? extends TypeParameterElement> typeParams = clazz.getTypeParameters();
        return typeParams != null && !typeParams.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private void writeStub(TypeElement clazz) throws IOException {
        void var8_11;
        HashMap<String, Map<String, String>> genericMapping = new HashMap<String, Map<String, String>>();
        if (!StubProcessor.hasTypeParameters(clazz)) {
            this.getAllGenericMappings(clazz, genericMapping, new HashMap<String, String>());
        }
        Elements elementUtils = this.processingEnv.getElementUtils();
        LinkedHashSet<ExecutableElement> abstractMethods = new LinkedHashSet<ExecutableElement>();
        List<? extends Element> enclosedElements = elementUtils.getAllMembers(clazz);
        HashSet<ExecutableElementDuplicateFinder> dupFinder = new HashSet<ExecutableElementDuplicateFinder>();
        for (Element element : enclosedElements) {
            ExecutableElement executableMethod;
            ExecutableElementDuplicateFinder eedf;
            Set<Modifier> modifiers;
            if (!ElementKind.METHOD.equals((Object)element.getKind()) || !(modifiers = element.getModifiers()).contains((Object)Modifier.ABSTRACT) || dupFinder.contains(eedf = new ExecutableElementDuplicateFinder(executableMethod = (ExecutableElement)element))) continue;
            dupFinder.add(eedf);
            abstractMethods.add(executableMethod);
        }
        boolean exceptions = false;
        Object var8_10 = null;
        LinkedList<TypeElement> contractsProvided = null;
        String scope = null;
        List<? extends AnnotationMirror> annotationMirrors = elementUtils.getAllAnnotationMirrors(clazz);
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Iterator<? extends AnnotationValue> ve;
            AnnotationValue v;
            Iterator<? extends AnnotationValue> iterator;
            AnnotationValue value;
            Map<? extends ExecutableElement, ? extends AnnotationValue> values;
            DeclaredType annoType = annotationMirror.getAnnotationType();
            TypeElement annoElement = (TypeElement)annoType.asElement();
            String annoQualifiedName = ServiceUtilities.nameToString(annoElement.getQualifiedName());
            if (annoQualifiedName.equals(NAMED_ANNO)) {
                values = annotationMirror.getElementValues();
                value = null;
                iterator = values.values().iterator();
                if (iterator.hasNext()) {
                    value = v = iterator.next();
                }
                if (value == null) {
                    String string = ServiceUtilities.nameToString(clazz.getSimpleName());
                    continue;
                }
                String string = (String)value.getValue();
                continue;
            }
            if (annoQualifiedName.equals(Stub.class.getName())) {
                values = annotationMirror.getElementValues();
                value = null;
                iterator = values.values().iterator();
                if (iterator.hasNext()) {
                    value = v = iterator.next();
                }
                if (value == null) continue;
                ve = (VariableElement)value.getValue();
                String stubType = ServiceUtilities.nameToString(ve.getSimpleName());
                exceptions = EXCEPTIONS.equals(stubType);
                continue;
            }
            if (annoQualifiedName.equals(PROVIDED_ANNO)) {
                values = annotationMirror.getElementValues();
                value = null;
                ve = values.values().iterator();
                if (ve.hasNext()) {
                    value = v = ve.next();
                }
                if (value == null) continue;
                List contracts = (List)value.getValue();
                contractsProvided = new LinkedList<TypeElement>();
                for (AnnotationValue contract : contracts) {
                    DeclaredType dt = (DeclaredType)contract.getValue();
                    TypeElement te = (TypeElement)dt.asElement();
                    contractsProvided.add(te);
                }
                continue;
            }
            if (!StubProcessor.isScopeAnnotation(annotationMirror)) continue;
            scope = "@" + annoQualifiedName;
        }
        this.writeJavaFile(clazz, abstractMethods, (String)var8_11, exceptions, contractsProvided, scope, genericMapping);
    }

    private String getFullyQualifiedStubName(TypeElement clazz) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        String clazzSimpleName = ServiceUtilities.nameToString(clazz.getSimpleName());
        Element enclosingElement = clazz.getEnclosingElement();
        ElementKind kind = enclosingElement.getKind();
        PackageElement packageElement = elementUtils.getPackageOf(clazz);
        String packageName = ServiceUtilities.nameToString(packageElement.getQualifiedName());
        if (ElementKind.PACKAGE.equals((Object)kind)) {
            if (packageName == null || packageName.isEmpty()) {
                return clazzSimpleName;
            }
            return packageName + "." + clazzSimpleName + STUB_EXTENSION;
        }
        String enclosingName = ServiceUtilities.nameToString(enclosingElement.getSimpleName());
        if (packageName == null || packageName.isEmpty()) {
            return enclosingName + "_" + clazzSimpleName + STUB_EXTENSION;
        }
        return packageName + "." + enclosingName + "_" + clazzSimpleName + STUB_EXTENSION;
    }

    private static String getJustClassPart(String fullyQualifiedFileNameWithDots) {
        int index = fullyQualifiedFileNameWithDots.lastIndexOf(46);
        if (index < 0) {
            return fullyQualifiedFileNameWithDots;
        }
        return fullyQualifiedFileNameWithDots.substring(index + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJavaFile(TypeElement clazz, Set<ExecutableElement> abstractMethods, String name, boolean exceptions, List<TypeElement> contractsProvided, String scope, Map<String, Map<String, String>> genericMapper) throws IOException {
        Elements elementUtils = this.processingEnv.getElementUtils();
        PackageElement packageElement = elementUtils.getPackageOf(clazz);
        String packageName = ServiceUtilities.nameToString(packageElement.getQualifiedName());
        String clazzQualifiedName = ServiceUtilities.nameToString(clazz.getQualifiedName());
        String fullyQualifiedStubName = this.getFullyQualifiedStubName(clazz);
        String clazzSimpleName = ServiceUtilities.nameToString(clazz.getSimpleName());
        String stubClazzName = StubProcessor.getJustClassPart(fullyQualifiedStubName);
        Filer filer = this.processingEnv.getFiler();
        JavaFileObject jfo = filer.createSourceFile(fullyQualifiedStubName, clazz);
        try (Writer writer = jfo.openWriter();){
            writer.append("package " + packageName + ";\n\n");
            writer.append("import javax.annotation.Generated;\n");
            if (name != null) {
                writer.append("import javax.inject.Named;\n");
            }
            writer.append("import org.jvnet.hk2.annotations.Service;\n");
            if (contractsProvided != null) {
                writer.append("import org.jvnet.hk2.annotations.ContractsProvided;\n");
            }
            writer.append("import " + clazzQualifiedName + ";\n\n");
            writer.append("@Service\n@Generated(\"org.glassfish.hk2.stub.generator.StubProcessor\")\n");
            if (name != null) {
                writer.append("@Named(\"" + name + "\")\n");
            }
            if (contractsProvided != null) {
                writer.append("@ContractsProvided({");
                boolean first = true;
                for (TypeElement contract : contractsProvided) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append(",\n    ");
                    }
                    String cName = ServiceUtilities.nameToString(contract.getQualifiedName()) + ".class";
                    writer.append(cName);
                }
                writer.append("})\n");
            }
            if (scope != null) {
                writer.append(scope + "\n");
            }
            writer.append("public class " + stubClazzName + " extends " + clazzSimpleName + " {\n");
            for (ExecutableElement abstractMethod : abstractMethods) {
                this.writeAbstractMethod(abstractMethod, genericMapper, writer, exceptions);
            }
            writer.append("}\n");
        }
    }

    private void writeAbstractMethod(ExecutableElement abstractMethod, Map<String, Map<String, String>> genericMapper, Writer writer, boolean exceptions) throws IOException {
        Set<Modifier> modifiers = abstractMethod.getModifiers();
        TypeElement element = (TypeElement)abstractMethod.getEnclosingElement();
        String elementQName = ServiceUtilities.nameToString(element.getQualifiedName());
        Map<String, String> typeMapper = genericMapper.get(elementQName);
        writer.append("    ");
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            writer.append("public ");
        } else if (modifiers.contains((Object)Modifier.PROTECTED)) {
            writer.append("protected ");
        }
        TypeMirror returnType = abstractMethod.getReturnType();
        TypeMirrorOutputs returnOutputs = this.typeMirrorToString(returnType, false, typeMapper);
        writer.append(returnOutputs.leftHandSide + " " + abstractMethod.getSimpleName() + "(");
        List<? extends VariableElement> parameterElements = abstractMethod.getParameters();
        int numParams = parameterElements.size();
        int lcv = 0;
        for (VariableElement variableElement : parameterElements) {
            TypeMirror variableAsType = variableElement.asType();
            boolean varArgs = abstractMethod.isVarArgs() && lcv + 1 == numParams;
            TypeMirrorOutputs paramOutputs = this.typeMirrorToString(variableAsType, varArgs, typeMapper);
            if (lcv > 0) {
                writer.append(", ");
            }
            writer.append(paramOutputs.leftHandSide);
            if (varArgs) {
                writer.append("...");
            }
            writer.append(" p" + lcv);
            ++lcv;
        }
        if (exceptions) {
            writer.append(") {\n        throw new UnsupportedOperationException(\"" + abstractMethod + "\");\n    }\n\n");
        } else {
            writer.append(") {\n        return " + returnOutputs.body + ";\n    }\n\n");
        }
    }

    private TypeMirrorOutputs typeMirrorToString(TypeMirror mirror, boolean varArg, Map<String, String> typeMap) throws IOException {
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeKind returnKind = mirror.getKind();
        switch (returnKind) {
            case ARRAY: {
                return new TypeMirrorOutputs(this.arrayTypeToString((ArrayType)mirror, varArg, typeMap), "null");
            }
            case VOID: {
                return new TypeMirrorOutputs("void", "");
            }
            case BOOLEAN: {
                return new TypeMirrorOutputs("boolean", "true");
            }
            case BYTE: {
                return new TypeMirrorOutputs("byte", "0");
            }
            case CHAR: {
                return new TypeMirrorOutputs("char", "0");
            }
            case DOUBLE: {
                return new TypeMirrorOutputs("double", "(double) 0.0");
            }
            case FLOAT: {
                return new TypeMirrorOutputs("float", "(float) 0.0");
            }
            case INT: {
                return new TypeMirrorOutputs("int", "0");
            }
            case LONG: {
                return new TypeMirrorOutputs("long", "0");
            }
            case SHORT: {
                return new TypeMirrorOutputs("short", "0");
            }
            case DECLARED: {
                TypeElement element = (TypeElement)typeUtils.asElement(mirror);
                return new TypeMirrorOutputs(ServiceUtilities.nameToString(element.getQualifiedName()), "null");
            }
            case TYPEVAR: {
                if (typeMap == null) {
                    return new TypeMirrorOutputs("Object", "null");
                }
                TypeVariable tv = (TypeVariable)mirror;
                Element typeElement = tv.asElement();
                String typeElementName = ServiceUtilities.nameToString(typeElement.getSimpleName());
                String leftSide = typeMap.get(typeElementName);
                if (leftSide == null) {
                    leftSide = "Object";
                }
                return new TypeMirrorOutputs(leftSide, "null");
            }
        }
        throw new IOException("Unknown kind: " + (Object)((Object)returnKind));
    }

    private String arrayTypeToString(ArrayType arrayType, boolean varArgs, Map<String, String> typeMapper) throws IOException {
        int numBraces = varArgs ? 0 : 1;
        TypeMirror arrayOfType = arrayType.getComponentType();
        while (arrayOfType instanceof ArrayType) {
            ++numBraces;
            arrayOfType = ((ArrayType)arrayOfType).getComponentType();
        }
        TypeMirrorOutputs underlyingType = this.typeMirrorToString(arrayOfType, false, typeMapper);
        StringBuffer sb = new StringBuffer(underlyingType.leftHandSide);
        for (int lcv = 0; lcv < numBraces; ++lcv) {
            sb.append("[]");
        }
        return sb.toString();
    }

    private static String getTypeName(TypeMirror mirror) {
        return StubProcessor.getTypeName(mirror, null);
    }

    private static String getTypeName(TypeMirror mirror, Map<String, String> typeMap) {
        switch (mirror.getKind()) {
            case DECLARED: {
                DeclaredType dt = (DeclaredType)mirror;
                TypeElement te = (TypeElement)dt.asElement();
                return ServiceUtilities.nameToString(te.getQualifiedName());
            }
            case ARRAY: {
                ArrayType at = (ArrayType)mirror;
                TypeMirror atm = at.getComponentType();
                return StubProcessor.getTypeName(atm) + "[]";
            }
            case TYPEVAR: {
                if (typeMap == null) {
                    return Object.class.getName();
                }
                TypeVariable tv = (TypeVariable)mirror;
                String tvSimpleName = ServiceUtilities.nameToString(tv.asElement().getSimpleName());
                String retVal = typeMap.get(tvSimpleName);
                if (retVal == null) {
                    return Object.class.getName();
                }
                return retVal;
            }
            case BOOLEAN: {
                return "boolean";
            }
            case BYTE: {
                return "byte";
            }
            case CHAR: {
                return "char";
            }
            case DOUBLE: {
                return "double";
            }
            case FLOAT: {
                return "float";
            }
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case SHORT: {
                return "short";
            }
            case VOID: {
                return "void";
            }
        }
        return "";
    }

    private static class ExecutableElementDuplicateFinder {
        private final ExecutableElement executableElement;
        private final int hash;

        private ExecutableElementDuplicateFinder(ExecutableElement executableElement) {
            this.executableElement = executableElement;
            int localHash = 0;
            Name name = executableElement.getSimpleName();
            localHash ^= name.hashCode();
            TypeMirror returnMirror = executableElement.getReturnType();
            localHash ^= StubProcessor.getTypeName(returnMirror).hashCode();
            for (VariableElement variableElement : executableElement.getParameters()) {
                TypeMirror asType = variableElement.asType();
                localHash ^= StubProcessor.getTypeName(asType).hashCode();
            }
            this.hash = localHash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            String otherReturnMirrorAsString;
            Name otherName;
            if (o == null) {
                return false;
            }
            if (!(o instanceof ExecutableElementDuplicateFinder)) {
                return false;
            }
            ExecutableElementDuplicateFinder other = (ExecutableElementDuplicateFinder)o;
            Name name = this.executableElement.getSimpleName();
            if (!GeneralUtilities.safeEquals((Object)name, (Object)(otherName = other.executableElement.getSimpleName()))) {
                return false;
            }
            TypeMirror returnMirror = this.executableElement.getReturnType();
            TypeMirror otherReturnMirror = other.executableElement.getReturnType();
            String returnMirrorAsString = StubProcessor.getTypeName(returnMirror);
            if (!GeneralUtilities.safeEquals((Object)returnMirrorAsString, (Object)(otherReturnMirrorAsString = StubProcessor.getTypeName(otherReturnMirror)))) {
                return false;
            }
            List<? extends VariableElement> params = this.executableElement.getParameters();
            List<? extends VariableElement> otherParams = other.executableElement.getParameters();
            if (params.size() != otherParams.size()) {
                return false;
            }
            for (int lcv = 0; lcv < params.size(); ++lcv) {
                String otherAsStringType;
                VariableElement ve = params.get(lcv);
                VariableElement otherVE = otherParams.get(lcv);
                TypeMirror asType = ve.asType();
                TypeMirror otherAsType = otherVE.asType();
                String asStringType = StubProcessor.getTypeName(asType);
                if (GeneralUtilities.safeEquals((Object)asStringType, (Object)(otherAsStringType = StubProcessor.getTypeName(otherAsType)))) continue;
                return false;
            }
            return true;
        }
    }

    private static class TypeMirrorOutputs {
        private final String leftHandSide;
        private final String body;

        private TypeMirrorOutputs(String leftHandSide, String body) {
            this.leftHandSide = leftHandSide;
            this.body = body;
        }
    }
}

