/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.stub.generator;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.inject.Named;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.metadata.generator.ServiceUtilities;
import org.glassfish.hk2.utilities.Stub;

@SupportedAnnotationTypes(value={"org.glassfish.hk2.utilities.Stub"})
public class StubProcessor
extends AbstractProcessor {
    private static final String NAMED_ANNO = Named.class.getName();
    private static final String EXCEPTIONS = "EXCEPTIONS";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        MultiException me = null;
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> clazzes = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : clazzes) {
                if (!(element instanceof TypeElement)) continue;
                TypeElement clazz = (TypeElement)element;
                try {
                    this.writeStub(clazz);
                }
                catch (IOException ioe) {
                    if (me == null) {
                        me = new MultiException((Throwable)ioe);
                        continue;
                    }
                    me.addError((Throwable)ioe);
                }
            }
        }
        if (me != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, me.getMessage());
            me.printStackTrace();
            return true;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void writeStub(TypeElement clazz) throws IOException {
        void var6_9;
        Elements elementUtils = this.processingEnv.getElementUtils();
        LinkedHashSet<ExecutableElement> abstractMethods = new LinkedHashSet<ExecutableElement>();
        List<? extends Element> enclosedElements = elementUtils.getAllMembers(clazz);
        for (Element element : enclosedElements) {
            Set<Modifier> modifiers;
            if (!ElementKind.METHOD.equals((Object)element.getKind()) || !(modifiers = element.getModifiers()).contains((Object)Modifier.ABSTRACT)) continue;
            ExecutableElement executableMethod = (ExecutableElement)element;
            abstractMethods.add(executableMethod);
        }
        boolean exceptions = false;
        Object var6_8 = null;
        List<? extends AnnotationMirror> annotationMirrors = elementUtils.getAllAnnotationMirrors(clazz);
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            AnnotationValue v;
            Iterator<? extends AnnotationValue> i$;
            AnnotationValue value;
            Map<? extends ExecutableElement, ? extends AnnotationValue> values;
            DeclaredType annoType = annotationMirror.getAnnotationType();
            TypeElement annoElement = (TypeElement)annoType.asElement();
            String annoQualifiedName = ServiceUtilities.nameToString(annoElement.getQualifiedName());
            if (annoQualifiedName.equals(NAMED_ANNO)) {
                values = annotationMirror.getElementValues();
                value = null;
                i$ = values.values().iterator();
                if (i$.hasNext()) {
                    value = v = i$.next();
                }
                if (value == null) {
                    String string = ServiceUtilities.nameToString(clazz.getSimpleName());
                    continue;
                }
                String string = (String)value.getValue();
                continue;
            }
            if (!annoQualifiedName.equals(Stub.class.getName())) continue;
            values = annotationMirror.getElementValues();
            value = null;
            i$ = values.values().iterator();
            if (i$.hasNext()) {
                value = v = i$.next();
            }
            if (value == null) continue;
            VariableElement ve = (VariableElement)value.getValue();
            String stubType = ServiceUtilities.nameToString(ve.getSimpleName());
            exceptions = EXCEPTIONS.equals(stubType);
        }
        this.writeJavaFile(clazz, abstractMethods, (String)var6_9, exceptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJavaFile(TypeElement clazz, Set<ExecutableElement> abstractMethods, String name, boolean exceptions) throws IOException {
        Elements elementUtils = this.processingEnv.getElementUtils();
        PackageElement packageElement = elementUtils.getPackageOf(clazz);
        String packageName = ServiceUtilities.nameToString(packageElement.getQualifiedName());
        String clazzQualifiedName = ServiceUtilities.nameToString(clazz.getQualifiedName());
        String clazzSimpleName = ServiceUtilities.nameToString(clazz.getSimpleName());
        String stubClazzName = ServiceUtilities.nameToString(clazz.getSimpleName()) + "_hk2Stub";
        Filer filer = this.processingEnv.getFiler();
        JavaFileObject jfo = filer.createSourceFile(stubClazzName, clazz);
        Writer writer = jfo.openWriter();
        try {
            writer.append("package " + packageName + ";\n\n");
            writer.append("import javax.annotation.Generated;\n");
            if (name != null) {
                writer.append("import javax.inject.Named;\n");
            }
            writer.append("import org.jvnet.hk2.annotations.Service;\n");
            writer.append("import " + clazzQualifiedName + ";\n\n");
            writer.append("@Service @Generated(\"org.glassfish.hk2.stub.generator.StubProcessor\")\n");
            if (name != null) {
                writer.append("@Named(\"" + name + "\")\n");
            }
            writer.append("public class " + stubClazzName + " extends " + clazzSimpleName + " {\n");
            for (ExecutableElement abstractMethod : abstractMethods) {
                this.writeAbstractMethod(abstractMethod, writer, exceptions);
            }
            writer.append("}\n");
        }
        finally {
            writer.close();
        }
    }

    private void writeAbstractMethod(ExecutableElement abstractMethod, Writer writer, boolean exceptions) throws IOException {
        Set<Modifier> modifiers = abstractMethod.getModifiers();
        writer.append("    ");
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            writer.append("public ");
        } else if (modifiers.contains((Object)Modifier.PROTECTED)) {
            writer.append("protected ");
        }
        TypeMirror returnType = abstractMethod.getReturnType();
        TypeMirrorOutputs returnOutputs = this.typeMirrorToString(returnType, false);
        writer.append(returnOutputs.leftHandSide + " " + abstractMethod.getSimpleName() + "(");
        List<? extends VariableElement> parameterElements = abstractMethod.getParameters();
        int numParams = parameterElements.size();
        int lcv = 0;
        for (VariableElement variableElement : parameterElements) {
            TypeMirror variableAsType = variableElement.asType();
            boolean varArgs = abstractMethod.isVarArgs() && lcv + 1 == numParams;
            TypeMirrorOutputs paramOutputs = this.typeMirrorToString(variableAsType, varArgs);
            if (lcv > 0) {
                writer.append(", ");
            }
            writer.append(paramOutputs.leftHandSide);
            if (varArgs) {
                writer.append("...");
            }
            writer.append(" p" + lcv);
            ++lcv;
        }
        if (exceptions) {
            writer.append(") {\n        throw new UnsupportedOperationException(\"" + abstractMethod + "\");\n    }\n\n");
        } else {
            writer.append(") {\n        return " + returnOutputs.body + ";\n    }\n\n");
        }
    }

    private TypeMirrorOutputs typeMirrorToString(TypeMirror mirror, boolean varArg) throws IOException {
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeKind returnKind = mirror.getKind();
        switch (returnKind) {
            case ARRAY: {
                return new TypeMirrorOutputs(this.arrayTypeToString((ArrayType)mirror, varArg), "null");
            }
            case VOID: {
                return new TypeMirrorOutputs("void", "");
            }
            case BOOLEAN: {
                return new TypeMirrorOutputs("boolean", "true");
            }
            case BYTE: {
                return new TypeMirrorOutputs("byte", "0");
            }
            case CHAR: {
                return new TypeMirrorOutputs("char", "0");
            }
            case DOUBLE: {
                return new TypeMirrorOutputs("double", "(double) 0.0");
            }
            case FLOAT: {
                return new TypeMirrorOutputs("float", "(float) 0.0");
            }
            case INT: {
                return new TypeMirrorOutputs("int", "0");
            }
            case LONG: {
                return new TypeMirrorOutputs("long", "0");
            }
            case SHORT: {
                return new TypeMirrorOutputs("short", "0");
            }
            case DECLARED: {
                TypeElement element = (TypeElement)typeUtils.asElement(mirror);
                return new TypeMirrorOutputs(ServiceUtilities.nameToString(element.getQualifiedName()), "null");
            }
            case TYPEVAR: {
                return new TypeMirrorOutputs("Object", "null");
            }
        }
        throw new IOException("Unknown kind: " + (Object)((Object)returnKind));
    }

    private String arrayTypeToString(ArrayType arrayType, boolean varArgs) throws IOException {
        int numBraces = varArgs ? 0 : 1;
        TypeMirror arrayOfType = arrayType.getComponentType();
        while (arrayOfType instanceof ArrayType) {
            ++numBraces;
            arrayOfType = ((ArrayType)arrayOfType).getComponentType();
        }
        TypeMirrorOutputs underlyingType = this.typeMirrorToString(arrayOfType, false);
        StringBuffer sb = new StringBuffer(underlyingType.leftHandSide);
        for (int lcv = 0; lcv < numBraces; ++lcv) {
            sb.append("[]");
        }
        return sb.toString();
    }

    private static class TypeMirrorOutputs {
        private final String leftHandSide;
        private final String body;

        private TypeMirrorOutputs(String leftHandSide, String body) {
            this.leftHandSide = leftHandSide;
            this.body = body;
        }
    }
}

