/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.metadata.generator;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.metadata.generator.ServiceUtilities;
import org.glassfish.hk2.utilities.DescriptorImpl;

@SupportedAnnotationTypes(value={"org.jvnet.hk2.annotations.Service"})
@SupportedOptions(value={"org.glassfish.hk2.metadata.location"})
public class ServiceProcessor
extends AbstractProcessor {
    private static final String LOCATION_OPTION = "org.glassfish.hk2.metadata.location";
    private static final String LOCATION_DEFAULT = "META-INF/hk2-locator/default";
    private final TreeSet<DescriptorImpl> allDescriptors = new TreeSet<DescriptorImpl>(new DescriptorComparitor());
    private final ArrayList<Element> originators = new ArrayList();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        MultiException collectedExceptions = null;
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> clazzes = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : clazzes) {
                List<DescriptorImpl> descriptors;
                if (!(element instanceof TypeElement)) continue;
                TypeElement clazz = (TypeElement)element;
                try {
                    descriptors = ServiceUtilities.getDescriptorsFromClass(clazz, this.processingEnv);
                }
                catch (Throwable th) {
                    if (collectedExceptions == null) {
                        collectedExceptions = new MultiException(th);
                        continue;
                    }
                    collectedExceptions.addError(th);
                    continue;
                }
                this.allDescriptors.addAll(descriptors);
                if (descriptors.isEmpty()) continue;
                this.originators.add(element);
            }
        }
        if (collectedExceptions != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, collectedExceptions.getMessage());
            collectedExceptions.printStackTrace();
            return true;
        }
        if (this.allDescriptors.isEmpty()) {
            return true;
        }
        if (!roundEnv.processingOver()) {
            return true;
        }
        try {
            this.createFile();
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile() throws IOException {
        String location = this.processingEnv.getOptions().get(LOCATION_OPTION);
        if (location == null) {
            location = LOCATION_DEFAULT;
        }
        if ((location = location.trim()).startsWith("/")) {
            throw new IOException("The org.glassfish.hk2.metadata.location option to hk2-inhabitant-locator must be a relative path, it was " + location);
        }
        Filer filer = this.processingEnv.getFiler();
        FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", location, this.originators.toArray(new Element[this.originators.size()]));
        Writer fileWriter = fileObject.openWriter();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(fileWriter);
            printWriter.println("#");
            printWriter.println("# Generated by hk2-metadata-generator");
            printWriter.println("#");
            printWriter.println();
            for (DescriptorImpl di : this.allDescriptors) {
                di.writeObject(printWriter);
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            fileWriter.close();
        }
    }

    private static class DescriptorComparitor
    implements Comparator<DescriptorImpl> {
        private DescriptorComparitor() {
        }

        private static <T> int safeCompare(Comparable<T> a, T b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return a.compareTo(b);
        }

        private static int compareStringMaps(Set<String> s1, Set<String> s2) {
            int size2;
            int size1 = s1.size();
            if (size1 != (size2 = s2.size())) {
                return size1 - size2;
            }
            TreeSet<String> s1sorted = new TreeSet<String>(s1);
            TreeSet<String> s2sorted = new TreeSet<String>(s2);
            StringBuffer s1b = new StringBuffer();
            for (String s1sv : s1sorted) {
                s1b.append(s1sv);
            }
            StringBuffer s2b = new StringBuffer();
            for (String s2sv : s2sorted) {
                s2b.append(s2sv);
            }
            return DescriptorComparitor.safeCompare(s1b.toString(), s2b.toString());
        }

        @Override
        public int compare(DescriptorImpl o1, DescriptorImpl o2) {
            int retVal = o2.getRanking() - o1.getRanking();
            if (retVal != 0) {
                return retVal;
            }
            retVal = DescriptorComparitor.safeCompare(o1.getImplementation(), o2.getImplementation());
            if (retVal != 0) {
                return retVal;
            }
            retVal = DescriptorComparitor.safeCompare(o1.getName(), o2.getName());
            if (retVal != 0) {
                return retVal;
            }
            retVal = DescriptorComparitor.safeCompare(o1.getScope(), o2.getScope());
            if (retVal != 0) {
                return retVal;
            }
            retVal = DescriptorComparitor.compareStringMaps(o1.getAdvertisedContracts(), o2.getAdvertisedContracts());
            if (retVal != 0) {
                return retVal;
            }
            retVal = DescriptorComparitor.compareStringMaps(o1.getQualifiers(), o2.getQualifiers());
            if (retVal != 0) {
                return retVal;
            }
            retVal = o1.getDescriptorType().compareTo((Enum)o2.getDescriptorType());
            if (retVal != 0) {
                return retVal;
            }
            retVal = o1.getDescriptorVisibility().compareTo((Enum)o2.getDescriptorVisibility());
            if (retVal != 0) {
                return retVal;
            }
            return 0;
        }
    }
}

