/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.testing.junit.internal;

import java.util.List;
import java.util.Set;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;

public class ClassVisitorImpl
extends ClassVisitor {
    private static final String SERVICE_CLASS_FORM = "Lorg/jvnet/hk2/annotations/Service;";
    private final ServiceLocator locator;
    private final boolean verbose;
    private String implName;
    private boolean isAService = false;
    private final Set<String> excludes;

    public ClassVisitorImpl(ServiceLocator locator, boolean verbose, Set<String> excludes) {
        super(589824);
        this.locator = locator;
        this.verbose = verbose;
        this.excludes = excludes;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.implName = name.replace("/", ".");
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (!visible) {
            return null;
        }
        if (SERVICE_CLASS_FORM.equals(desc)) {
            this.isAService = true;
        }
        return null;
    }

    public void visitEnd() {
        if (!this.isAService) {
            return;
        }
        if (this.excludes.contains(this.implName)) {
            return;
        }
        Class<?> implClass = null;
        try {
            implClass = Class.forName(this.implName);
        }
        catch (Throwable th) {
            System.out.println("HK2Runner could not classload service " + this.implName + ", skipping...");
            return;
        }
        List added = ServiceLocatorUtilities.addClasses((ServiceLocator)this.locator, (Class[])new Class[]{implClass});
        if (this.verbose && !added.isEmpty()) {
            System.out.println("HK2Runner bound service " + added.get(0));
        }
    }
}

