/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.testing.junit.internal;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.JustInTimeInjectionResolver;

@Singleton
public class JustInTimeInjectionResolverImpl
implements JustInTimeInjectionResolver {
    private final Collection<?> excludes;
    @Inject
    private DynamicConfigurationService dcs;

    public JustInTimeInjectionResolverImpl() {
        this(Collections.emptySet());
    }

    public JustInTimeInjectionResolverImpl(Collection<?> excludes) {
        this.excludes = excludes == null ? Collections.emptySet() : excludes;
    }

    protected boolean isLookup(Injectee failedInjectionPoint) {
        return failedInjectionPoint == null || failedInjectionPoint.getParent() == null;
    }

    public boolean justInTimeResolution(Injectee failedInjectionPoint) {
        boolean returnValue = false;
        if (failedInjectionPoint != null && !this.isLookup(failedInjectionPoint)) {
            Type rawType;
            Type needType = failedInjectionPoint.getRequiredType();
            Class needClass = null;
            if (needType instanceof Class) {
                needClass = (Class)needType;
            } else if (needType instanceof ParameterizedType && (rawType = ((ParameterizedType)needType).getRawType()) instanceof Class) {
                needClass = (Class)rawType;
            }
            if (needClass == null || needClass.isInterface() || this.excludes != null && this.excludes.contains(needClass.getName())) {
                return false;
            }
            DynamicConfiguration config = this.dcs.createDynamicConfiguration();
            try {
                ActiveDescriptor ad = config.addActiveDescriptor(needClass);
                config.commit();
                returnValue = true;
            }
            catch (Throwable th) {
                returnValue = false;
            }
        }
        return returnValue;
    }
}

